﻿// JavaScript Document

//根据身份证获取相关信息
function getBirthAndSexByIDNo(prefix){
	var idType = $('#' + prefix + 'idType').val();
	var idNo = $('#' + prefix + 'idNumber').val();
	if (idNo == '') {
		return;
	}
	if(idType == 'IDCARD'){
		if(!validateIdent.IdentityCodeValid(idNo)){
		    alert('您输入的身份证格式有误');
		    $('#' + prefix + 'idNumber').focus();
		    return;
		}
		//获取出生日期
		var birth = getBirthdayFromIDNo(idNo);
		//获取性别
		var sex = getSexFromIDNo(idNo);
		$('#' + prefix + 'birthDate').val(birth);
		
		if('M' == sex) {
			$('#' + prefix + 'MALE').attr("checked", "checked");
		} else if('F' == sex){
			$('#' + prefix + 'FEMALE').attr("checked", "checked");
		}
		
	}
}

function calDateTip(showId, obj, type, benefit) {
	if(obj == null || obj.value == null || obj.value == '') {
		return;
	}
	var interval = 'd ';
	if(type == 'ANNUAL') {
		interval = 'y ';
	} else if(type == 'MONTHLY') {
		interval = 'm ';
	} 
	var inception = new Date(Date.parse(obj.value));
	var newDate = DateAdd(interval, benefit, new Date(Date.parse(obj.value)));
	newDate = DateAdd('d ', -1, newDate);
	$("#" + showId).html("自" + inception.format('yyyy-MM-dd') + "零时起至" + newDate.format('yyyy-MM-dd') + "二十四时止");
}

function changeIdType(prefix) {
	var idType = $('#' + prefix + 'idType').val();
	if(idType == 'IDCARD'){ 
		$('#' + prefix + 'birthDate').attr("disabled", "disabled");
		$('#' + prefix + 'MALE').attr("disabled", "disabled");
		$('#' + prefix + 'FEMALE').attr("disabled", "disabled");
	} else {
		$('#' + prefix + 'birthDate').attr("disabled", false);
		$('#' + prefix + 'MALE').attr("checked", "checked");
		$('#' + prefix + 'MALE').attr("disabled", false);
		$('#' + prefix + 'FEMALE').attr("disabled", false);
	}
}

function changeRelatedToRole(obj) {
	if(obj == null || obj.value == '') {
		$("#insuredTable").hide();
		alert("请选择与投保人关系");
	} else {
		if(obj.value == 'SELF') {
			$("#insured_fullName").val($("#applicant_fullName").val());
			$("#insured_idType").val($("#applicant_idType").val());
			$("#insured_idNumber").val($("#applicant_idNumber").val());
			$("#insured_birthDate").val($("#applicant_birthDate").val());
			$("#insured_MALE").attr("checked", $("#applicant_MALE").attr("checked"));
			$("#insured_FEMALE").attr("checked", $("#applicant_FEMALE").attr("checked"));
			
			$("#insured_mobileNumber").val($("#applicant_mobileNumber").val());
			$("#insured_email").val($("#applicant_email").val());
			$("#insured_addressLines").val($("#applicant_addressLines").val());
			$("#insured_postalCode").val($("#applicant_postalCode").val());
			
			changeIdType("insured_");
		} else {
			changeIdType("insured_");
			$("#insuredTable input[id^='insured_']").each(function() {
				$(this).val("");
			});
			$("#insuredTable select[id^='insured_']").each(function() {
				$(this).val("");
			});
			$("#insured_MALE").attr("checked", "checked");
		}
		
		$("#insuredTable").show();
	}
}

/**
 * 显示隐藏收件人表单信息
 */
function showDeliverForm(){
	var dlvFlag1 = $("#need_insur_bill");
	var dlvFlag2 = $("#need_receipt");
	if ((dlvFlag1.attr("checked") == true || dlvFlag1.attr("checked") == "checked") && (dlvFlag2.attr("checked") == true || dlvFlag2.attr("checked") == "checked")) {
		$("#receiptHeadTable").show();
		$("#receiverTable").show();
		
		return;
	}
	if ((dlvFlag1.attr("checked") == true || dlvFlag1.attr("checked") == "checked") && (dlvFlag2.attr("checked") != true && dlvFlag2.attr("checked") != "checked")) {
		$("#receiverTable").show();
		$("#receiptHeadTable").hide();
		return;
	}
	if ((dlvFlag2.attr("checked") == true || dlvFlag2.attr("checked") == "checked") && (dlvFlag1.attr("checked") != true && dlvFlag1.attr("checked") != "checked")) {
		$("#receiptHeadTable").show();
		$("#receiverTable").show();
		$("#need_insur_bill").attr("checked","checked");
		return;
	}
	if ((dlvFlag2.attr("checked") != true && dlvFlag2.attr("checked") != "checked") && (dlvFlag1.attr("checked") != true && dlvFlag1.attr("checked") != "checked")) {
		$("#receiverTable").hide();
		$("#receiptHeadTable").hide();
		return;
	}
	
}

/**
 * 我是会员功能
 */
function initApplicantInfo() {
	if($("#isMember").attr("checked") == true || $("#isMember").attr("checked") == "checked") {
		$.ajax({
			   type: 'POST',
			   url: baseUrl + "/user/findCurrentUser.json",
			   data:{},
			   beforeSend:function(){
			   },
			   success: function(json){
				   var currentUser = json.currentUser;
				   if(currentUser != null) {
						$("#applicant_fullName").val(currentUser.custName);
						if(currentUser.idType != 'IDCARD') {
							$("#applicant_MALE").attr("disabled", false);
							$("#applicant_FEMALE").attr("disabled", false);
							$("#applicant_birthDate").attr("disabled", false);
						}
						$("#applicant_idType").val(currentUser.idType);
						$("#applicant_idNumber").val(currentUser.idNo);
						$("#applicant_birthDate").val(currentUser.birthday);
						$("#applicant_MALE").attr("checked", (currentUser.sex == "M"));
						$("#applicant_FEMALE").attr("checked", (currentUser.sex == "F"));
						
						$("#applicant_mobileNumber").val(currentUser.mobile);
						$("#applicant_email").val(currentUser.email);
						$("#applicant_addressLines").val(currentUser.addressDetail);
						$("#applicant_postalCode").val(currentUser.zipCode);
				   }
			   },
			   error:function (XMLHttpRequest, textStatus, errorThrown){
			      alert('请求失败');
			   }
			});
	}
}
function checkInsuranceForm() {
	if($("#inceptionDate").val()=="") {
		alert("请填写生效日期!");
		$("#inceptionDate").focus();
		return false;
	}
	
	if(!checkPolicyRequriedItem()) {
		return false;
	}
	if(!checkAppRequriedItem()) {
		return false;
	}
	
	if(!checkInsRequriedItem()) {
		return false;
	}
	
	if(!otherInfoRequriedItem()) {
		return false;
	}
	
	if(!checkAppValid()) {
		return false;
	}
	if(!checkInsuredValid()) {
		return false;
	}
	
	return true;
}

function checkPolicyRequriedItem() {
	var temp = $(".requiredPolicyItem");
	for(var i = 0; i < temp.length; i++){
	  if(temp[i].value==""){
	  	alert("投保单信息填写不全，请补充完整！");
	  	temp[i].focus();
	  	return false;
	  }
	}
	return true;
}


function checkAppRequriedItem() {
	var appRI = $(".requiredAppItem");
	for(var i = 0; i < appRI.length; i++){
	  if(appRI[i].value==""){
	  	alert("投保人信息填写不全，请补充完整！");
	  	appRI[i].focus();
	  	return false;
	  }
	}
	return true;
}

//校验被保人必填项
function checkInsRequriedItem(){
	var insRI = $(".requiredInsItem");
	for(var i = 0; i < insRI.length; i++){
	  if(insRI[i].value==""){
	  	alert("被保人信息填写不全，请补充完整！");
	  	insRI[i].focus();
	  	return false;
	  }
	}
	return true;
}

function otherInfoRequriedItem() {
	var dlvFlag1 = $("#need_insur_bill");
	var dlvFlag2 = $("#need_receipt");
	if (dlvFlag1.attr("checked") == true || dlvFlag1.attr("checked") == "checked") {
		if($("#receiver_address_detail").val()=="" || $("#receiver_address_detail").val()==null || $("#receiver_address_detail").val()=="") {
			alert("请填写收件人地址!");
			$("#receiver_address_detail").focus();
			return false;
		}
		if($("#receiver_name").val()=="") {
			alert("请填写收件人名字!");
			$("#receiver_name").focus();
			return false;
		}
		if($("#receiver_mobile").val()=="" && $("#receiver_mobile").val()=="") {
			alert("请填写收件人联系方式!");
			$("#receiver_mobile").focus();
			return false;
		}
	}
	
	if (dlvFlag2.attr("checked") == true || dlvFlag2.attr("checked") == "checked") {
		if($("#receipt_head").val()=="") {
			alert("请填写发票抬头!");
			$("#receipt_head").focus();
			return false;
		}
	}
	return true;
}
//校验投保人信息
function checkAppValid() {
	var appName = $('#applicant_fullName');
	var appIdType = $('#applicant_idType');
	var appIdNo = $('#applicant_idNumber');
	var appBirthday = $('#applicant_birthDate');
	var appMobile = $('#applicant_mobileNumber');
	var appEmail = $('#applicant_email');
	var appPostalCode = $('#applicant_postalCode');
	//有效性校验
	//校验身份证号码
	if(appIdType.val() == 'IDCARD') {
		if(!validateIdent.IdentityCodeValid(appIdNo.val())) {
			alert("您输入投保人信息中的身份证号码不正确");
			return false;
		}
		var birthday = getBirthdayFromIDNo(appIdNo.val());
		if(appBirthday.val() != undefined && birthday != appBirthday.val()) {
			alert("您输入投保人信息中的出生日期与身份证号码不符");
			return false;
		}
	}
	//校验姓名
	if(checkValid(appName.val()) && (/\d+/gi).test(appName.val())){
		alert("您输入投保人信息中的姓名不能包含数字！");
		return false;
	}
	
	//校验移动电话
	if(checkValid(appMobile.val()) && !checkMobile(appMobile.val())) {
		alert("您输入投保人信息中的手机号码不正确");
		return false;
	}
	//校验电子邮箱
	if(checkValid(appEmail.val()) && !checkEmail(appEmail.val())) {
		alert("您输入投保人信息中的电子邮箱不正确");
		return false;
	}
	//校验邮政编码
	if(checkValid(appPostalCode.val()) && !checkZipCode(appPostalCode.val())) {
		alert("您输入投保人信息中的邮政编码不正确");
		return false;
	}
	return true;
}
function checkInsuredValid() {
	var insIdType = $('#insured_idType');
	var insIdNo = $('#insIdNo');
	var insBirthday = $('#insured_birthDate');
	var insMobile = $('#insured_mobileNumber');
	var insEmail = $('#insured_email');
	var insZipCode = $('#insured_postalCode');
	var insRelationToApp = $('#relatedToAppCode');
	//校验姓名
	if(checkValid($('#insured_fullName').val()) && (/\d+/gi).test($('#insured_fullName').val())){
		alert("您输入的姓名不能包含数字！");
		return false;
	}
	
	//校验移动电话
	if(checkValid(insMobile.val()) && !checkMobile(insMobile.val())) {
		alert("您输入的手机号码不正确");
		return false;
	}
	//校验电子邮箱
	if(checkValid(insEmail.val()) && !checkEmail(insEmail.val())) {
		alert("您输入的电子邮箱不正确");
		return false;
	}
	//校验邮政编码
	if(checkValid(insZipCode.val()) && !checkZipCode(insZipCode.val())) {
		alert("您输入的邮政编码不正确");
		return false;
	}
	return true;
}

function checkValid(value){
	if(value != undefined && value != "" && value != null){
		return true;
	}
	return false;
}
