/*前端公共js*/
function g_ajax(url,p,callback,async,errorCallback){
    if(async) async=true;
    $.ajax({async:async, type: 'post', dataType: 'json', url:url, data:p,
        success: function (json) {callback(json) },
        error: function(event, jqXHR, options, errorMsg){
            if(errorCallback) errorCallback(event, jqXHR, options, errorMsg);
        }
    });
}

var districtObj = {
    init:function(obj){
        $(".picker_area_div").find("[name=province]").val(obj.province);
        $(".picker_area_div").find(".picker_province").trigger("mouseup");
        $(".picker_area_div").find("[name=city]").val(obj.city);
        $(".picker_area_div").find(".picker_city").trigger("mouseup");
        $(".picker_area_div").find("[name=district]").val(obj.district);
    },
    districtRender : function(){
        //ajax获得省市县数据
        var list;
        if(sessionStorage.getItem("district_china")==null){
            // console.log("没走缓存")
            g_ajax("/synopsis/district",{},function(json){ list = json},false);
            sessionStorage.setItem("district_china",JSON.stringify(list));
        }else{
            // console.log("走缓存")
            list = JSON.parse(sessionStorage.getItem("district_china"));
        }


        //获得节点的方法
        function getOpt(obj){ //得到节点的html
            return "<option value='"+obj.codes+"'>"+obj.named+"</option>";
        }

        //初始化省份
        var province=getOpt({codes:"",named:"请选择省"});
        for(var i in list){
            if(list[i].code_level==1) province +=getOpt(list[i]);
        }
        $(".picker_area_div").find(".picker_province").html(province);

        //初始化市
        var city = getOpt({codes:"",named:"请选择市"});
        for(var i in list){
            if(list[i].code_level==2) city +=getOpt(list[i]);
        }
        $(".picker_area_div").find(".picker_city").html(city);
        $(".picker_area_div").find(".picker_city").attr("disabled","disabled");

        //初始化区
        var district = getOpt({codes:"",named:"请选择区"});
        for(var i in list){
            if(list[i].code_level==3) district +=getOpt(list[i]);
        }
        $(".picker_area_div").find(".picker_district").html(district);
        $(".picker_area_div").find(".picker_district").attr("disabled","disabled");


        //省份是确定的数据
        $(".picker_province").change(function(){
            var pid =$(this).children('option:selected').val();
            var city=getOpt({codes:"",named:"请选择市"});
            for(var i in list){
                if(list[i].code_level==2 && list[i].parent_id==pid) city +=getOpt(list[i]);
            }
            $(".picker_area_div").find(".picker_city").html(city);
            $(".picker_area_div").find(".picker_city").removeAttr("disabled");
            $(".picker_area_div").find(".picker_district").html(getOpt({codes:"",named:"请选择区"}));
            $(".picker_area_div").find(".picker_district").attr("disabled","disabled");
        });
        //市的数据是根据省来确定
        $(".picker_city").change(function(){
            var pid =$(this).children('option:selected').val();
            var district = getOpt({codes: "", named: "请选择区"});
            for(var i in list){
                if(list[i].code_level==3 && list[i].parent_id==pid) district +=getOpt(list[i]);
            }
            $(".picker_area_div").find(".picker_district").html(district);
            $(".picker_area_div").find(".picker_district").removeAttr("disabled");
        });
        //县的数据是根据市来确定
        // $(".picker_area_div").on('change',".picker_district",function(){
        //
        // });
    }
};

var bankDistrictObj = {
    init:function(obj){
        $(".picker_area_div").find("[name=province_code]").val(obj.province);
        $(".picker_area_div").find(".picker_province_code").trigger("mouseup");
        $(".picker_area_div").find("[name=region_code]").val(obj.city);
        $(".picker_area_div").find(".picker_region_code").trigger("mouseup");
    },
    districtRender : function(){
        //ajax获得省市县数据
        var list;
        if(sessionStorage.getItem("district_china")==null){
            // console.log("没走缓存")
            g_ajax("/synopsis/district",{},function(json){ list = json},false);
            sessionStorage.setItem("district_china",JSON.stringify(list));
        }else{
            // console.log("走缓存")
            list = JSON.parse(sessionStorage.getItem("district_china"));
        }
        //获得节点的方法
        function getOpt(obj){ //得到节点的html
            return "<option value='"+obj.codes+"'>"+obj.named+"</option>";
        }

        //初始化省份
        var province=getOpt({codes:"",named:"请选择省"});
        for(var i in list){
            if(list[i].code_level==1) province +=getOpt(list[i]);
        }
        $(".picker_area_div").find(".picker_province_code").html(province);

        //初始化市
        var city = getOpt({codes:"",named:"请选择市"});
        for(var i in list){
            if(list[i].code_level==2) city +=getOpt(list[i]);
        }
        $(".picker_area_div").find(".picker_region_code").html(city);
        $(".picker_area_div").find(".picker_region_code").attr("disabled","disabled");

        //省份是确定的数据
        $(".picker_province_code").change(function(){
            var pid =$(this).children('option:selected').val();
            var pstr =$(this).children('option:selected').text();
            $('#province_name').val(pstr);
            var city=getOpt({codes:"",named:"请选择市"});
            for(var i in list){
                if(list[i].code_level==2 && list[i].parent_id==pid) city +=getOpt(list[i]);
            }
            $(".picker_area_div").find(".picker_region_code").html(city);
            $(".picker_area_div").find(".picker_region_code").removeAttr("disabled");
        });
        //市的数据是根据省来确定
        $(".picker_region_code").change(function(){
            var pstr =$(this).children('option:selected').text();
            $('#city_name').val(pstr);
        });
    }
};

var enterpriseType = {
    init: function(obj){
        $(".enterprise_type_div").find("[enterprise_type_one]").val(obj.enterprise_type_one);
        $(".enterprise_type_div").find("[enterprise_type_one]").trigger("mouseup");
        $(".enterprise_type_div").find("[enterprise_type_two]").val(obj.enterprise_type_two);
        $(".enterprise_type_div").find("[enterprise_type_two]").trigger("mouseup");
    },
    render : function(){
        var comboOne  =  $(".enterprise_type_div").find(".enterprise_type_one");
        var comboTwo  =  $(".enterprise_type_div").find(".enterprise_type_two");
        var comboTwoDiv  =  $(".enterprise_type_div").find(".enterprise_type_two_div");
        var data  = [
            {id:0,text:"机关",pid:-1},
            {id:1,text:"事业单位",pid:-1},
            {id:2,text:"社会团体",pid:-1},
            {id:3,text:"国有企业",pid:-1},
            {id:4,text:"民营企业",pid:-1},
            {id:5,text:"外资企业",pid:-1},
            {id:6,text:"国有独资",pid:3},
            {id:7,text:"国有控股",pid:3},
            {id:8,text:"国有联营",pid:3},
            {id:9,text:"私营企业",pid:4},
            {id:10,text:"乡镇企业",pid:4},
            {id:11,text:"个体企业",pid:4},
            {id:12,text:"外商独资",pid:5},
            {id:13,text:"中外合资",pid:5},
            {id:14,text:"中外合作",pid:5},
            {id:15,text:"其他",pid:-1}
        ];
        //获得数据的方法，根据父亲节点去获得
        function getSubNode(pid){
            var r = [];
            for(var i in data){
                if(data[i].pid==pid) r.push(data[i]);
            }
            return r;
        }
        //获得节点的方法
        function getOpt(obj){ //得到节点的html
            return "<option value='"+obj.codes+"'>"+obj.named+"</option>";
        }

        $(".enterprise_type_one").change(function(){
            var pid =$(this).children('option:selected').val();
            var initData = getSubNode(pid);
            var str = "<option value=''>请选择</option>";
            if(initData.length==0 || pid == ''){ //清空并隐藏
                comboTwoDiv.hide();
            }else{//赋值并显示
                for(var i in initData){
                    if (initData[i].id != undefined) str += "<option value='"+initData[i].id+"'>"+initData[i].text+"</option>";
                }
                comboTwoDiv.show();
            }
            comboTwo.html(str);

        });

        var initData = getSubNode(-1), str = "<option value=''>-请选择-</option>";
        for(var i in initData){
            if (initData[i].id != undefined) str += "<option value='"+initData[i].id+"'>"+initData[i].text+"</option>";
        }
        //初始化
        comboOne.html(str);
    }
};


var accidentCauseLevelDiv = {
    init: function(obj){
        $(".accident_cause_level_div").find("[accident_cause_level_1]").val(obj.accident_cause_level_1);
        $(".accident_cause_level_div").find("[accident_cause_level_1]").trigger("mouseup");
        $(".accident_cause_level_div").find("[accident_cause_level_2]").val(obj.accident_cause_level_2);
        $(".accident_cause_level_div").find("[accident_cause_level_2]").trigger("mouseup");
    },
    render : function(){
        var comboOne  =  $(".accident_cause_level_div").find(".accident_cause_level_1");
        var comboTwo  =  $(".accident_cause_level_div").find(".accident_cause_level_2");
        var comboTwoDiv  =  $(".enterprise_type_div").find(".accident_cause_level_2_div");
        var data  = [
            {id:'A01',text:"意外伤害事故",pid:'-1'},
            {id:'A06',text:"疾病",pid:'-1'},
            {id:'N0298',text:"外来暴力侵害事故",pid:'A01'},
            {id:'N0092',text:"电、光、火、热、腐蚀、蒸气引起的事故",pid:'A01'},
            {id:'N0101',text:"动物咬伤、抓伤等伤害",pid:'A01'},
            {id:'N0127',text:"工作场所内摔倒",pid:'A01'},
            {id:'N0211',text:"溺水、触电、烧、烫伤",pid:'A01'},
            {id:'N0227',text:"器械事故",pid:'A01'},
            {id:'N0250',text:"上下班途中",pid:'A01'},
            {id:'N0252',text:"烧、烫伤",pid:'A01'},
            {id:'N0263',text:"食物中毒",pid:'A01'},
            {id:'N0364',text:"运动、社会、文娱活动",pid:'A01'},
            {id:'N0397',text:"坠落、摔倒、滑倒",pid:'A01'},
            {id:'N0226',text:"其他意外事故",pid:'A01'},
            {id:'N0079',text:"猝死",pid:'A06'},
            {id:'N0379',text:"职业病",pid:'A06'},
            {id:'N0417',text:"其他疾病",pid:'A06'}
        ];
        //获得数据的方法，根据父亲节点去获得
        function getSubNode(pid){
            var r = [];
            for(var i in data){
                if(data[i].pid==pid) r.push(data[i]);
            }
            return r;
        }
        //获得节点的方法
        function getOpt(obj){ //得到节点的html
            return "<option value='"+obj.codes+"'>"+obj.named+"</option>";
        }

        $(".accident_cause_level_1").change(function(){
            var pid =$(this).children('option:selected').val();
            var initData = getSubNode(pid);
            var str = "<option value=''>请选择</option>";
            if(initData.length==0 || pid == ''){ //清空并隐藏
                comboTwoDiv.hide();
            }else{//赋值并显示
                for(var i in initData){
                    if (initData[i].id != undefined) str += "<option value='"+initData[i].id+"'>"+initData[i].text+"</option>";
                }
                comboTwoDiv.show();
            }
            comboTwo.html(str);

        });

        var initData = getSubNode(-1), str = "<option value=''>-请选择-</option>";
        for(var i in initData){
            if (initData[i].id != undefined) str += "<option value='"+initData[i].id+"'>"+initData[i].text+"</option>";
        }
        //初始化
        comboOne.html(str);
    }
};


var clientBankCodeDiv = {
    init: function(obj){
        $(".client_bank_code_div").find("[client_bank_code]").val(obj.client_bank_code);
        $(".client_bank_code_div").find("[client_bank_code]").trigger("mouseup");
    },
    render : function(){
        var comboOne  =  $(".client_bank_code_div").find(".client_bank_code");
        var data  = [{"bankTypeCode":"102","bankTypeName":"中国工商银行"},{"bankTypeCode":"104","bankTypeName":"中国银行"},{"bankTypeCode":"308","bankTypeName":"招商银行"},{"bankTypeCode":"301","bankTypeName":"交通银行"},{"bankTypeCode":"A00","bankTypeName":"平安银行(原平安)"},{"bankTypeCode":"303","bankTypeName":"中国光大银行"},{"bankTypeCode":"310","bankTypeName":"上海浦东发展银行"},{"bankTypeCode":"306","bankTypeName":"广发银行"},{"bankTypeCode":"A01","bankTypeName":"上海银行"},{"bankTypeCode":"305","bankTypeName":"中国民生银行"},{"bankTypeCode":"309","bankTypeName":"兴业银行"},{"bankTypeCode":"314","bankTypeName":"农村商业银行"},{"bankTypeCode":"307","bankTypeName":"平安银行"},{"bankTypeCode":"304","bankTypeName":"华夏银行"},{"bankTypeCode":"319","bankTypeName":"徽商银行"},{"bankTypeCode":"A05","bankTypeName":"江苏银行"},{"bankTypeCode":"A63","bankTypeName":"哈尔滨银行"},{"bankTypeCode":"C20","bankTypeName":"德阳银行"},{"bankTypeCode":"A02","bankTypeName":"北京银行"},{"bankTypeCode":"C04","bankTypeName":"东莞银行"},{"bankTypeCode":"A03","bankTypeName":"宁波银行"},{"bankTypeCode":"B89","bankTypeName":"广州银行"},{"bankTypeCode":"C45","bankTypeName":"富滇银行"},{"bankTypeCode":"A07","bankTypeName":"天津银行"},{"bankTypeCode":"318","bankTypeName":"渤海银行"},{"bankTypeCode":"C16","bankTypeName":"重庆银行"},{"bankTypeCode":"A06","bankTypeName":"杭州银行"},{"bankTypeCode":"A55","bankTypeName":"吉林银行"},{"bankTypeCode":"C06","bankTypeName":"广西北部湾银行"},{"bankTypeCode":"A42","bankTypeName":"大连银行"},{"bankTypeCode":"B65","bankTypeName":"长沙银行"},{"bankTypeCode":"402","bankTypeName":"农村信用联社"},{"bankTypeCode":"D02","bankTypeName":"乌鲁木齐市商业银行"},{"bankTypeCode":"C36","bankTypeName":"贵阳银行"},{"bankTypeCode":"A76","bankTypeName":"南京银行"},{"bankTypeCode":"B53","bankTypeName":"汉口银行"},{"bankTypeCode":"A86","bankTypeName":"台州银行"},{"bankTypeCode":"C21","bankTypeName":"绵阳市商业银行"},{"bankTypeCode":"D29","bankTypeName":"龙江银行"},{"bankTypeCode":"A08","bankTypeName":"河北银行"},{"bankTypeCode":"B10","bankTypeName":"南昌银行"},{"bankTypeCode":"D28","bankTypeName":"宁夏银行"},{"bankTypeCode":"B26","bankTypeName":"烟台银行"},{"bankTypeCode":"C78","bankTypeName":"兰州银行"},{"bankTypeCode":"316","bankTypeName":"浙商银行"},{"bankTypeCode":"B36","bankTypeName":"郑州银行"},{"bankTypeCode":"A47","bankTypeName":"锦州银行"},{"bankTypeCode":"315","bankTypeName":"恒丰银行"},{"bankTypeCode":"A48","bankTypeName":"营口银行"},{"bankTypeCode":"A19","bankTypeName":"晋商银行"},{"bankTypeCode":"D26","bankTypeName":"浙江泰隆商业银行"},{"bankTypeCode":"B22","bankTypeName":"青岛银行"},{"bankTypeCode":"C92","bankTypeName":"青海银行"},{"bankTypeCode":"B30","bankTypeName":"威海银行"},{"bankTypeCode":"C18","bankTypeName":"攀枝花市商业银行"},{"bankTypeCode":"B25","bankTypeName":"东营银行"},{"bankTypeCode":"D21","bankTypeName":"日照银行"},{"bankTypeCode":"D03","bankTypeName":"昆仑银行"},{"bankTypeCode":"B23","bankTypeName":"齐商银行"},{"bankTypeCode":"A14","bankTypeName":"张家口市商业银行"},{"bankTypeCode":"B27","bankTypeName":"潍坊银行"},{"bankTypeCode":"B01","bankTypeName":"海峡银行"},{"bankTypeCode":"A31","bankTypeName":"包包典当"},{"bankTypeCode":"B34","bankTypeName":"临商银行"},{"bankTypeCode":"C07","bankTypeName":"柳州银行"},{"bankTypeCode":"D22","bankTypeName":"葫芦岛银行"},{"bankTypeCode":"B28","bankTypeName":"济宁银行"},{"bankTypeCode":"B02","bankTypeName":"厦门银行"},{"bankTypeCode":"A11","bankTypeName":"邯郸银行"},{"bankTypeCode":"B16","bankTypeName":"赣州银行"},{"bankTypeCode":"A23","bankTypeName":"晋城银行"},{"bankTypeCode":"B18","bankTypeName":"上饶银行"},{"bankTypeCode":"B29","bankTypeName":"泰安市商业银行"},{"bankTypeCode":"A30","bankTypeName":"内蒙古银行"},{"bankTypeCode":"105","bankTypeName":"中国建设银行"},{"bankTypeCode":"103","bankTypeName":"中国农业银行"},{"bankTypeCode":"D25","bankTypeName":"浙江民泰商业银行"},{"bankTypeCode":"B38","bankTypeName":"洛阳银行"},{"bankTypeCode":"A81","bankTypeName":"绍兴银行"},{"bankTypeCode":"A16","bankTypeName":"沧州银行"},{"bankTypeCode":"B32","bankTypeName":"德州银行"},{"bankTypeCode":"A80","bankTypeName":"湖州银行"},{"bankTypeCode":"A49","bankTypeName":"阜新银行"},{"bankTypeCode":"D30","bankTypeName":"苏州银行"},{"bankTypeCode":"A78","bankTypeName":"温州银行"},{"bankTypeCode":"B51","bankTypeName":"南阳市商业银行"},{"bankTypeCode":"B48","bankTypeName":"商丘银行"},{"bankTypeCode":"A15","bankTypeName":"承德银行"},{"bankTypeCode":"A12","bankTypeName":"邢台银行"},{"bankTypeCode":"B37","bankTypeName":"开封市商业银行"},{"bankTypeCode":"B46","bankTypeName":"漯河银行"},{"bankTypeCode":"A39","bankTypeName":"鄂尔多斯银行"},{"bankTypeCode":"595","bankTypeName":"韩国新韩银行"},{"bankTypeCode":"596","bankTypeName":"韩国中小企业银行"},{"bankTypeCode":"597","bankTypeName":"韩亚银行"},{"bankTypeCode":"591","bankTypeName":"韩国外换银行"},{"bankTypeCode":"D23","bankTypeName":"莱商银行"},{"bankTypeCode":"D32","bankTypeName":"浙江稠州商业银行"},{"bankTypeCode":"798","bankTypeName":"鄞州银行"}];
        //获得节点的方法
        function getOpt(obj){ //得到节点的html
            return "<option value='"+obj.bankTypeCode+"'>"+obj.bankTypeName+"</option>";
        }

        $(".client_bank_code").change(function(){
            var pstr =$(this).children('option:selected').text();
            $('#client_bank_name').val(pstr);
        });

        var str = "<option value=''>-请选择-</option>";
        for(var i in data){
            if (data[i].bankTypeCode != undefined) str += getOpt(data[i]);
        }
        //初始化
        comboOne.html(str);
    }
};

var damageCodeDiv = {
    init: function(obj){
        $(".damageCode_div").find("[damageCode]").val(obj.accident_cause_level_1);
        $(".damageCode_div").find("[damageCode]").trigger("mouseup");
    },
    render : function(){
        var comboOne  =  $(".damageCode_div").find(".damageCode");
        var data  = [{"damageCode":"101","damageName":"雷电"}
        ,{"damageCode":"102","damageName":"飓风"}
        ,{"damageCode":"103","damageName":"台风"}
        ,{"damageCode":"104","damageName":"龙卷风"}
        ,{"damageCode":"105","damageName":"风暴"}
        ,{"damageCode":"106","damageName":"暴雨"}
        ,{"damageCode":"107","damageName":"洪水"}
        ,{"damageCode":"108","damageName":"水灾"}
        ,{"damageCode":"109","damageName":"冰雹、雹灾"}
        ,{"damageCode":"110","damageName":"冻灾"}
        ,{"damageCode":"111","damageName":"山崩、地崩、崖崩"}
        ,{"damageCode":"112","damageName":"火山爆发"}
        ,{"damageCode":"113","damageName":"温差变化、冻灾、旱灾"}
        ,{"damageCode":"114","damageName":"泥石流"}
        ,{"damageCode":"115","damageName":"突发性滑坡"}
        ,{"damageCode":"116","damageName":"滑坡"}
        ,{"damageCode":"117","damageName":"冰凌、凌汛"}
        ,{"damageCode":"118","damageName":"地震"}
        ,{"damageCode":"119","damageName":"海啸"}
        ,{"damageCode":"120","damageName":"海侵"}
        ,{"damageCode":"121","damageName":"海潮"}
        ,{"damageCode":"122","damageName":"地面突然下陷"}
        ,{"damageCode":"123","damageName":"其它自然灾害"}
        ,{"damageCode":"201","damageName":"火灾"}
        ,{"damageCode":"202","damageName":"爆炸"}
        ,{"damageCode":"203","damageName":"空中运行物体坠落"}
        ,{"damageCode":"204","damageName":"碰撞"}
        ,{"damageCode":"205","damageName":"倾覆、倒塌"}
        ,{"damageCode":"206","damageName":"水管、水箱爆裂、水灾（水浸）"}
        ,{"damageCode":"207","damageName":"爆裂、断裂"}
        ,{"damageCode":"208","damageName":"短路、“三停”、电器意外"}
        ,{"damageCode":"209","damageName":"渗漏、沾污、污染"}
        ,{"damageCode":"210","damageName":"自然磨损、氧化、腐蚀、锈蚀、孔蚀、锅垢"}
        ,{"damageCode":"211","damageName":"负压变形、负压爆炸"}
        ,{"damageCode":"212","damageName":"自燃、阴燃"}
        ,{"damageCode":"213","damageName":"其它意外事故"}
        ,{"damageCode":"301","damageName":"盗窃"}
        ,{"damageCode":"302","damageName":"抢夺"}
        ,{"damageCode":"303","damageName":"抢劫"}
        ,{"damageCode":"304","damageName":"恶意行为"}
        ,{"damageCode":"305","damageName":"贪污、挪用、携款潜逃"}
        ,{"damageCode":"306","damageName":"信用卡透支"}
        ,{"damageCode":"307","damageName":"信用卡盗用"}
        ,{"damageCode":"308","damageName":"信用卡欺诈交易"}
        ,{"damageCode":"309","damageName":"其它人为因素风险"}
        ,{"damageCode":"401","damageName":"战争、军事冲突"}
        ,{"damageCode":"402","damageName":"类似战争行为、政变"}
        ,{"damageCode":"403","damageName":"罢工、暴动、民众骚乱"}
        ,{"damageCode":"404","damageName":"恐怖行为"}
        ,{"damageCode":"405","damageName":"政府罚没、接管"}
        ,{"damageCode":"406","damageName":"外汇管制"}
        ,{"damageCode":"407","damageName":"其他政治风险"}
        ];
        //获得节点的方法
        function getOpt(obj){ //得到节点的html
            return "<option value='"+obj.damageCode+"'>"+obj.damageName+"</option>";
        }

        var str = "<option value=''>-请选择-</option>";
        for(var i in data){
            if (data[i].damageCode != undefined) str += getOpt(data[i]);
        }
        //初始化
        comboOne.html(str);
    }
};

function g_comm_back(json){//回调函数
    if (json.success == true) {
        // layer.msg(json.msg, {icon: 1, time: 1000});
        layer.alert(json.msg, {icon: 1, closeBtn:0 ,yes:function(){   layer.closeAll();  }});
    } else {
        layer.alert(json.msg, {icon: 2, closeBtn:0 ,yes:function(){   layer.closeAll();  }});
    }
}

$(document).ajaxStart(g_onStart)
    .ajaxComplete(g_onComplete)
    .ajaxSuccess(g_onSuccess)
    .ajaxError(g_onError);

function g_onStart(event) {
    //加载层-默认风格
    //g_layer = layer.load(1); //layer.load();
    //判断服务器session是否存在

    // var h = document.body.clientHeight;
    // $("<div class=\"datagrid-mask\"></div>").css({display:"block",width:"100%",height:h}).appendTo("body");
    layer.load();//1 2
//	layer.msg('加载中...', {icon: 16});
//     $("<div class=\"datagrid-mask-msg\"></div>").html("<font style='font-size: 13px;'>服务器正在努力的处理，请稍候...</font>").appendTo("body").css({display:"block",
//         left:($(document.body).outerWidth(true) - 190) / 2, top:(h - 45) / 2,"background-color":"#fff","color":"#000","border":"0px","border-radius":"8px"});
}
function g_onComplete(event, xhr, settings) {
    // $('.datagrid-mask-msg').remove();
    layer.closeAll('loading');
//     $('.datagrid-mask').remove();
    //此处演示关闭
//	layer.close(g_layer);
    /*setTimeout(function(){
     layer.closeAll('loading');
     }, 88);*/
}
function g_onSuccess(event, xhr, settings) {
    /*try {
     var json = $.parseJSON(xhr.responseText);
     if(true==json.isSessionTimeOut){
     window.location.href="login.do";
     $.messager.alert("提示", "登录超时，请重新登录", "info", function () {});
     }
     } catch (e) {
     }*/
}
function g_onError(event, jqXHR, options, errorMsg){
    if(jqXHR.status=="200") return;
    layer.msg("连接服务错误",{icon:2,time:2000});
    console.log(errorMsg);
    console.log(event);
    console.log(jqXHR.status);
    console.log(options);
}
$.ajaxSetup({
    contentType : "application/x-www-form-urlencoded;charset=utf-8",
    complete : function(xhr, textStatus) {
        // $.ts.hideLoading();
        //session timeout
        // if (xhr.status == 404) {
        //     top.location.href="login.do";
        //     return;
        // }
    }/*,
     error: function(jqXHR, textStatus, errorThrown){
     if(jqXHR.status==404){
     $.messager.alert("提示", "连接服务器错误，错误代码："+jqXHR.status, "info", function () {});
     }
     } */
});


$(document).ready(function(){
    districtObj.districtRender();
    bankDistrictObj.districtRender();
    enterpriseType.render();
    accidentCauseLevelDiv.render();
    clientBankCodeDiv.render();
    damageCodeDiv.render();
});