
		function loadDataAndPage(){
			totalCount = Number($('#totalCount').val()) || 0;
			$('#callBackPager').extendPagination({
				totalCount: totalCount,
				showCount: showCount,
				limit: limit,
				callback: function (curr, limit, totalCount) {
					getListForPage("orderForm","policysArea");
				}
			});
		};

        function searchList(){
            $("#starDate").val($("#start-s1").val());
            $("#endDate").val($("#end-s1").val());
            $("#keyword").val($("#keyword_it").val());
            choisePolicyStatus($("#policyStatus").val(),$('#totalCount').val());
        }

        function resetSearch(){
            $("#keyword_it").val("");
            $("#start-s1").val("");
            $("#end-s1").val("");
        }

		function getListForPage(formId,contentId){
            var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/pc/order/getPcOrderListForPage",
				data : $("#"+formId).serialize(),
				dataType : "text",
				success : function(data) {
					layer.closeAll();
					$("#"+contentId).html(data);
				},
				error: function(){
                    layer.closeAll();
				}
			});
		}
		
		function choisePolicyStatus(policyStatus,totalCount,obj){
            var index = layer.load(0, {shade: [0.3,'#808080']});
			$(".order-list li").removeClass("active");
			if(obj != undefined){
                $(obj).addClass("active");
            }
			$("#policyStatus").val(policyStatus);
			// $('#totalCount').val(totalCount);
			$('#pageNum').val("1");
			//获取搜索框
            $("#starDate").val($("#start-s1").val());
            $("#endDate").val($("#end-s1").val());
            $("#keyword").val($("#keyword_it").val());
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/order/tabTotal",
                data : {
                    'policyStatus':policyStatus,
                    'keyword':$("#keyword").val(),
                    'starDate':$("#starDate").val(),
                    'endDate':$("#endDate").val()
                },
                dataType : "text",
                success : function(data) {
                    $(".order-list").html(data);
                    loadDataAndPage();
                    getListForPage("orderForm","policysArea");
                }
            });
		}

        function tabTotal(policyStatus){
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/order/tabTotal",
                async :false,
                data : {
                	'policyStatus':policyStatus,
                	'keyword':$("#keyword").val(),
                	'starDate':$("#starDate").val(),
                	'endDate':$("#endDate").val()
				},
                dataType : "text",
                success : function(data) {
                    $(".order-list").html(data);
                }
            });
        }

        function copyOrder(policyId){
            layer.confirm('确定复制此订单？（注：可以依当前订单复制一份信息一样的“投保中”状态订单，在“投保中”列表第一条可以点击“继续投保”。）', {
                btn: ['确定','取消'] //按钮
            }, function(){
                layer.closeAll();
                if(policyId != ''){
                    var index = layer.load(0, {shade: [0.3,'#808080']});
                    $.ajax({
                        type : 'POST',
                        url : baseUrl + "/pc/order/copyOrder",
                        data : {
                            "order_id":policyId,
                        },
                        dataType : "json",
                        success : function(data) {
                            layer.close(index);
                            layer.msg(data.message);
                            if(data.statusCode == '200') {
                                getListForPage("orderForm","policysArea");
                            }
                        },
                        error: function(){
                            layer.close(index);
                        }
                    });
                }
            });
        }

        function deleteExportOrder(policyId,policyStatus){
			layer.confirm('确定删除此订单？', {
			  btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/pc/order/deleteExportOrder.json",
					data : {"order_id":policyId},
					dataType : "json",
					success : function(data) {
						layer.msg(data.message);
						if(data.status =="200"){
                            $.ajax({
                                type : 'POST',
                                url : baseUrl + "/pc/order/tabTotal",
                                data : {
                                    'policyStatus':policyStatus,
                                    'keyword':$("#keyword").val(),
                                    'starDate':$("#starDate").val(),
                                    'endDate':$("#endDate").val()
                                },
                                dataType : "text",
                                success : function(data) {
                                    $(".order-list").html(data);
                                    getListForPage("orderForm","policysArea");
                                }
                            });
						}
					},
					error: function(){
						layer.close(index);
					}
				});
			});
		}

		function openSetRemarks(policyId,policyStatus,customRemarks){
            var _html = '<div class="row">' +
				'<div class="col-sm-12 col-xs-12">' +
				'<p>备注</p>' +
				'<textarea name="remarks" id="remarks" class="text-w form-control" placeholder="请输入产品名字备注内容">'+customRemarks+'</textarea>' +
				'</div>' +
                '<div class="col-sm-12 col-xs-12" style="margin-top: 10px;">' +
					'<p>1、自定义备注内容可便于区分多张在线保单；</p>' +
					'<p>2、限制100个字符，默认显示3个字，鼠标悬浮显示全部内容，可点击修改。</p>' +
                '</div>' +
				'</div>';
            layer.confirm(_html,{btn: ['确定','取消'], title: "添加备注"
            }, function(){
                var remarks = $('#remarks').val();
                if(remarks == ''){
                    layer.msg("备注内容不能为空！", {icon: 2, time: 2000});
                    return;
                }
                var index = layer.load(0, {shade: [0.3,'#808080']});
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/order/addRemarksByOrder.json",
                    data : {"order_id":policyId,"remarks":remarks},
                    dataType : "json",
                    success : function(data) {
                        layer.close(index);
                        layer.msg(data.message);
                        if(data.status =="200"){
                            layer.closeAll();
                            // tabTotal(policyStatus);
                            getListForPage("orderForm","policysArea");
                        }
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            });

            $("#remarks").on("input propertychange", function() {
                var $this = $(this),
                    _val = $this.val();
                if (_val.length > 100) {
                    $this.val(_val.substring(0, 100));
                }
            });
		}

		function refreshTotal(policyStatus){
			var id="";
			if(policyStatus =="1"){
				id = "INSSUM";
			}else if(policyStatus =="4"){
				id = "NOPAYSUM";
			}
			
			var total = Number($("#"+id).html());
			var totalCount = total -1;
			var numPerPage = Number($('#numPerPage').val());
			var pageNum = Number($("#pageNum").val());
			if(totalCount%numPerPage ==0)
				pageNum = pageNum -1;
			
			$("#"+id).html(totalCount);
			$('#totalCount').val(totalCount);
			$('#pageNum').val(pageNum);
			loadDataAndPage();
			
			$("#callBackPager li").each(function(){
				$(this).removeClass('active');
				if ($(this).find('a').html() == pageNum) {
	                $(this).addClass('active');
				}
			});
			
			getListForPage("orderForm","policysArea");
		}