//cookie操作

//添加cookie，只设置值，不设置过期时间、域、目录
function addCookie(cookie_name, cookie_value){
	document.cookie = cookie_name + "=" + escape(cookie_value);
}

//添加cookie，设置值、过期时间，不设置域、目录
function addCookie1(cookie_name, cookie_value, expiresSecond){
	var date = new Date();
	var ms = expiresSecond * 1000;
	date.setTime(date.getTime() + ms);
	document.cookie = cookie_name + "=" + escape(cookie_value) + "; expires=" + date.toGMTString();
}

//添加cookie，设置值、过期时间、域、目录
function addCookie2(cookie_name, cookie_value, expiresSecond, domain, path){
	var date = new Date();
	var ms = expiresSecond * 1000;
	date.setTime(date.getTime() + ms);
	document.cookie = cookie_name + "=" + escape(cookie_value) + "; expires=" + date.toGMTString() + ";domain="+domain + ";path="+path;
}

//添加cookie，设置值、过期时间，不设置域
function addCookie3(cookie_name, cookie_value, expiresSecond){
	var date = new Date();
	var ms = expiresSecond * 1000;
	date.setTime(date.getTime() + ms);
	document.cookie = cookie_name + "=" + escape(cookie_value) + "; expires=" + date.toGMTString() + ";path=/BJCIB/";
}

//获取cookie
function getCookie(cookie_name){
	var cookie_value = "";
	var allcookies = document.cookie;
	var cookie_pos = allcookies.indexOf(cookie_name);
	if(cookie_pos != -1){
		cookie_pos += cookie_name.length + 1;
		var cookie_end = allcookies.indexOf(";", cookie_pos);
		if (cookie_end == -1){
			cookie_end = allcookies.length;
		}
		cookie_value = unescape(allcookies.substring(cookie_pos, cookie_end));
	}
	return cookie_value;
}

//删除cookie
function delCookie(cookie_name){
	var date = new Date();
	date.setTime(date.getTime() - 10000);
	document.cookie = cookie_name + "=a; expires=" + date.toGMTString();
}

