/**
 * 通用ajax封装提交
 * @param datas 数据
 * @param url 请求链接
 * @param callback 返回处理方法
 * @param isAsync 是否一步
 * @param openMsg 是否显示提示
 */
setParamDatas = function (datas,url,isAsync,openMsg,callback) {
    SaveForm({
        url: url,
        param: datas,
        async : isAsync,
        openMsg : openMsg,
        success: function(data) {
            callback(data)
        }
    });
}
SaveForm = function(options) {
    var defaults = {
        url : "",
        param : {},
        type : "post",
        dataType : "json",
        // contentType : 'application/json',
        async : true,
        timeout:60000,
        openMsg : true,
        success : null,
        close : true
    };
    var options = $.extend(defaults, options);
    dialogLoading(true,options.openMsg);
    /*var dts = '';
    if(Object.prototype.isPrototypeOf(options.param) && Object.keys(options.param).length != 0){
        dts = JSON.stringify(options.param);
    }*/
    window.setTimeout(function() {
        $.ajax({
            url : options.url,
            data : options.param,
            type : options.type,
            dataType : options.dataType,
            // contentType : options.contentType,
            async : options.async,
            success : function(data) {
                options.success(data);
                dialogClose(options.openMsg);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                dialogLoading(false, options.openMsg);
                dialogMsg(errorThrown, 'error', options.openMsg);
            },
            beforeSend : function() {
                dialogLoading(true, options.openMsg);
            },
            complete : function() {
                dialogLoading(false, options.openMsg);
            }
        });
    }, 500);
}
dialogMsg = function(msg, type, isOpen) {
    if(isOpen){
        var msgType = {
            success:1,
            error:2,
            warn:3,
            info:7
        };
        if(isNullOrEmpty(type)){
            type='info';
        }
        layer.msg(msg, {
            icon: msgType[type],
            time: 2000
        });
    }
}

dialogClose = function(isOpen) {
    //去掉top.
    if(isOpen){
        var index = layer.getFrameIndex(window.name); //先得到当前iframe层的索引
        layer.close(index); //再执行关闭
    }
}

dialogLoading = function(flag,isOpen) {
    if(isOpen){
        //去掉top.
        if(flag){
            layer.load(0, {
                shade: [0.3,'#808080'],
                time: 2000
            });
        }else{
            layer.closeAll('loading');
        }
    }
}
isNullOrEmpty = function (obj) {
    if ((typeof (obj) == "string" && obj == "") || obj == null || obj == undefined) {
        return true;
    } else {
        return false;
    }
}

isNotNullOrEmpty = function (obj) {
    if ((typeof (obj) == "string" && obj == "") || obj == null || obj == undefined) {
        return false;
    } else {
        return true;
    }
}

var topWindow;
var win_sign = 1;//0本站内嵌，1它站内嵌
function changeFrameSet(_type,_nav){
    for(topWindow=window;topWindow.parent!=null && topWindow.parent!=topWindow;topWindow=topWindow.parent){
        for(var i=0;i<topWindow.parent.frames.length;i++){
            var isIframe = true;
            try {
                topWindow.parent.frames[i].window.document;
            }catch (e) {
                isIframe = false;
            }
            if(_type == 0){//类型为0，重置iframe高度
                if(isIframe){
                    if(topWindow.parent.frames[i].window.document==topWindow.document){
                        var tName = topWindow.parent.frames[i].name;
                        if(tName != ''){
                            if(tName.indexOf('frame3d')!=-1){
                                win_sign = 0;
                                var hv = topWindow.document.body.offsetHeight+60;
                                if(hv<200){
                                    hv = 690;
                                }
                                try {
                                    parent.document.getElementById("frame3d").height=hv;
                                } catch (error) {
                                    console.log(error);
                                }
                            }
                        }
                    }
                }
			}else if(_type == 1){//类型为1，重置面包屑导航
                if(isIframe){
                    if(topWindow.parent.frames[i].window.document==topWindow.document){
                        var tName = topWindow.parent.frames[i].name;
                        if(tName != ''){
                            var bread_crumbs;
                            if(tName.indexOf('frame3d')!=-1){
                                win_sign = 0;
                                $("ol[class*='breadcrumb']").each(function(){
                                    $(this).html('');
                                });
                            }else{
                                $("#bread_crumbs").html(_nav);
                            }
                        }
                    }
                }else{
                    $("#bread_crumbs").html(_nav);
                }
            }

        }
    }
}

function laySomenType(ty,idx,msg,times){//ty:layer类型，如0打开遮盖，1消息提示，2关闭遮盖层；win_sign:当前0内嵌或1外嵌
    if(win_sign == 0){//本站内嵌
        if(ty==0){//打开遮盖
            return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        }else if(ty==1){//消息提示
            if(times == 0){
                layer.msg(msg);
            }else{
                layer.msg(msg, {time:times});
            }
        }else if(ty == 2){
            layer.close(idx);
        }
    }else{//它站内嵌
        if(ty==0){//打开遮盖
            return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        }else if(ty==1){//消息提示
            if(times == 0){
                layer.msg(msg);
            }else{
                layer.msg(msg, {time:times});
            }
        }else if(ty == 2){
            layer.close(idx);
        }
    }
    return null;
}

function passwordTest(obj) {
	var t = obj.value;
	var id = getResult(t);
	//定义对应的消息提示 
	var msg = new Array(4);
	msg[0] = "密码过短。";
	msg[1] = "密码强度差。";
	msg[2] = "密码强度良好。";
	msg[3] = "密码强度高。";
	var sty = new Array(4);
	sty[0] = -45;
	sty[1] = -30;
	sty[2] = -15;
	sty[3] = 0;
	var col = new Array(4);
	col[0] = "gray";
	col[1] = "#50AEDD";
	col[2] = "#FF8213";
	col[3] = "green";
	//设置显示效果 
	var bImg = "passwordLevel.gif" //一张显示用的图片 
	var sWidth = 250;
	var sHeight = 15;
	var Bobj = document.getElementById("nodetext");

	Bobj.style.fontSize = "12px";
	Bobj.style.color = col[id];
	Bobj.style.width = sWidth + "px";
	Bobj.style.height = sHeight + "px";
	Bobj.style.lineHeight = sHeight + "px";
	Bobj.style.background = "url(passwordLevel.gif) no-repeat left " + sty[id]
			+ "px";
	Bobj.style.textIndent = "20px";
	Bobj.innerHTML = "检测提示：" + msg[id];
}
//定义检测函数,返回0/1/2/3分别代表无效/差/一般/强 
function getResult(s) {
	if (s.length < 4) {
		return 0;
	}
	var ls = 0;
	if (s.match(/[a-z]/ig)) {
		ls++;
	}
	if (s.match(/[0-9]/ig)) {
		ls++;
	}
	if (s.match(/(.[^a-z0-9])/ig)) {
		ls++;
	}
	if (s.length < 6 && ls > 0) {
		ls--;
	}
	return ls
}
