$(function () {
    $("html").attr('id','cav_1');
    $("body").append('<canvas id="myCanvas" hidden></canvas>');
    var _tong;
})
/**
 * 投保过程截图上传保存操作轨迹
 * 注：后台可根据2个id是否有参数判断。前台同一页面必须存在orderId，如果没有必须有一个获取orderId的业务方法
 *      1.orderId不为空，sigId为空：正常保存
 *      2.orderId为空，sigId不为空：正常保存
 *      3.orderId不为空，sigId不为空：正常保存，查询出对应sigId记录设置orderId值
 *      最终存入库的记录都必须有归属的orderId
 * @param orderId 订单id
 * @param sigId 页面全局标识id
 * @param oType 页面操作类型描述
 */
function insOperation(orderId,sigId,oType) {
    if(orderId==''&&sigId==''){
        return ;
    }
    _tong = 0;
    html2canvas(document.querySelector("#cav_1"),{scale: 0.5}).then(function(canvas) {
        var img = new Image();
        var canvas1=document.getElementById("myCanvas");
        // 设置宽高
        canvas1.width=canvas.width;//注意：没有单位
        canvas1.height=canvas.height;//注意：没有单位
        var ctx=canvas1.getContext("2d");
        if(img.complete) {
            img.src = canvas.toDataURL(); //由于图片异步加载，一定要等img加载好，再设置src属性
            img.onload = function() {
                // 绘制图片
                ctx.drawImage(img,0,0);
                // 绘制水印
                ctx.font="20pt 宋体";  //水印文字添加
                ctx.fillStyle = "rgba(0,0,0,0.3)";
                ctx.rotate(-25 * Math.PI / 180);
                var _myData = new Date();
                for(var i = (canvas.height*0.5)*-1; i<canvas.width; i+=368+Math.floor(Math.random() * (399 - 100 + 1) + 100)) {
                    for(var j = 0; j<canvas.height*1.5; j+=400) {
                        ctx.fillText("   TIME："+_myData.toLocaleString(),i,j);
                        ctx.fillText("VERSION：V-INS-"+_myData.getTime()+"-E",i,j+30);
                    }
                }
                var dataurl = canvas1.toDataURL("image/png");//生成的格式
                var arr = dataurl.split(','),
                    mime = arr[0].match(/:(.*?);/)[1],
                    bstr = atob(arr[1]),
                    n = bstr.length,
                    u8arr = new Uint8Array(n);
                while (n--) {
                    u8arr[n] = bstr.charCodeAt(n);
                }
                var fileName = _myData.getTime()+".png";
                var file = new File([u8arr], fileName, {type: mime});
                file.lastModifiedDate =_myData;
                ajaxFormCanvasLoad(orderId,sigId,file,'insOperation/',fileName,oType);
                _tong=1;
            }
        }
    })
    $('#myCanvas').remove();
    $("body").append('<canvas id="myCanvas" hidden></canvas>');
}

function insOperation2(orderId,sigId,oType,ox,oy) {
    if(orderId==''&&sigId==''){
        return ;
    }
    //可视区域的高度
    var width =
        document.documentElement.clientWidth == 0
            ? document.body.clientWidth
            : document.documentElement.clientWidth;
    var height =
        document.documentElement.clientHeight == 0
            ? document.body.clientHeight
            : document.documentElement.clientHeight;
    var length = getPageScroll()[1];
    var ele = document.querySelector("#cav_1");
    // var encode = encodeURI(ele.innerHTML);
    // var _myData = new Date();
    // var fileName = _myData.getTime()+".html";
    // ajaxFormHtmlLoad(orderId,sigId,btoa(encode),'elementHtml/',fileName,oType,width,height,length);

    html2canvas(ele,{width: width, //DOM原始宽度
        height: height,
        y: length, //canvas开始的的Y坐标
        scrollY: length,// 滚动
        // tainttest: false,
        // allowTaint: true,
        // useCORS: true,
        scale: window.devicePixelRatio
    }).then(function(canvas) {
        var img = new Image();
        var canvas1=document.getElementById("myCanvas");
        // 设置宽高
        canvas1.width=canvas.width;//注意：没有单位
        canvas1.height=canvas.height;//注意：没有单位
        var ctx=canvas1.getContext("2d");
        if(img.complete) {
            img.src = canvas.toDataURL(); //由于图片异步加载，一定要等img加载好，再设置src属性
            img.onload = function() {
                // 绘制图片
                ctx.drawImage(img,0,0);
                // 绘制水印
                ctx.font="15pt 宋体";  //水印文字添加
                ctx.fillStyle = "rgba(255,0,0,0.5)";
                ctx.fillText("●",ox-7,oy+8);
                ctx.save();
                // 绘制水印
                ctx.font="20pt 宋体";  //水印文字添加
                ctx.fillStyle = "rgba(0,0,0,0.3)";
                ctx.rotate(-25 * Math.PI / 180);
                var _myData = new Date();
                for(var i = (canvas.height*0.5)*-1; i<canvas.width; i+=368+Math.floor(Math.random() * (399 - 100 + 1) + 100)) {
                    for(var j = 0; j<canvas.height*1.5; j+=400) {
                        ctx.fillText("   TIME："+_myData.toLocaleString(),i,j);
                        ctx.fillText("VERSION：V-INS-"+_myData.getTime()+"-E",i,j+30);
                    }
                }
                ctx.restore();
                var dataurl = canvas1.toDataURL("image/png");//生成的格式
                var arr = dataurl.split(','),
                    mime = arr[0].match(/:(.*?);/)[1],
                    bstr = atob(arr[1]),
                    n = bstr.length,
                    u8arr = new Uint8Array(n);
                while (n--) {
                    u8arr[n] = bstr.charCodeAt(n);
                }
                var fileName = _myData.getTime()+".png";
                var file = new File([u8arr], fileName, {type: mime});
                file.lastModifiedDate =_myData;
                ajaxFormCanvasLoad(orderId,sigId,file,'insOperation/',fileName,oType);
            }
        }

    })
    $('#myCanvas').remove();
    $("body").append('<canvas id="myCanvas" hidden></canvas>');
}

function getPageScroll() {
    var xScroll, yScroll;
    if (self.pageYOffset) {
        yScroll = self.pageYOffset;
        xScroll = self.pageXOffset;
    } else if (
        document.documentElement &&
        document.documentElement.scrollTop
    ) {
        // Explorer 6 Strict
        yScroll = document.documentElement.scrollTop;
        xScroll = document.documentElement.scrollLeft;
    } else if (document.body) {
        // all other Explorers
        yScroll = document.body.scrollTop;
        xScroll = document.body.scrollLeft;
    }
    var arrayPageScroll = new Array(xScroll, yScroll);
    return arrayPageScroll;
}

function ajaxFormCanvasLoad(orderId,sigId,file,directoryName,fileName,oType){
    // var name = "/"+directoryName+fileName+"."+fileType;
    var formData = new FormData();
    formData.append('file', file);
    formData.append('orderId', orderId);//用于截图跟当前投保记录关联（订单id）
    formData.append('sigId', sigId);//同页面如果初始没有订单id就生成一个页面全局的标识id
    formData.append('oType', oType);//截图类型（如：客户须知确认，投保提交，投保确认等）
    formData.append('fileName', fileName);
    formData.append('directoryName', directoryName);
    $.ajax({
        type: 'POST',
        url: '/file/ajaxFormCanvasLoad',
        dataType:"json",
        data: formData,
        processData: false,
        contentType: false,
        success: function(result){
        }
    });
}

function ajaxFormHtmlLoad(orderId,sigId,file,directoryName,fileName,oType,width,height,length){
    // var name = "/"+directoryName+fileName+"."+fileType;
    var formData = new FormData();
    formData.append('file', file);
    formData.append('orderId', orderId);//用于截图跟当前投保记录关联（订单id）
    formData.append('sigId', sigId);//同页面如果初始没有订单id就生成一个页面全局的标识id
    formData.append('oType', oType);//截图类型（如：客户须知确认，投保提交，投保确认等）
    formData.append('fileName', fileName);
    formData.append('directoryName', directoryName);
    //截图位置
    formData.append('width', width);
    formData.append('height', height);
    formData.append('length', length);
    $.ajax({
        type: 'POST',
        url: '/file/ajaxFormHtmlLoad',
        dataType:"json",
        data: formData,
        processData: false,
        contentType: false,
        success: function(result){
        }
    });
}