<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>佣金报表</title>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="float-e-margins">
                <div class="ibox-title">
                    <h5>搜索查询</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                        <a class="close-link">
                            <i class="fa fa-times"></i>
                        </a>
                    </div>
                </div>
                <div class="ibox-content search-query">
                    <form action="${ctxnes}/report/feeListData?companyId=${company.id}" method="post" id="searchForm">
                        <div class="col-sm-2">
                            <div class="form-group">
                                <select name="typeDate" class="form-control">
                                    <option value="1">成交时间</option>
                                    <option value="2">申请时间</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group" id="data_5">
                                <div class="input-daterange input-group">
                                    <input type="text" class="form-control"  id="begincreate_time" name="startDate"  placeholder="请选择日期..."/>
                                    <span class="input-group-addon">到</span>
                                    <input type="text" class="form-control"  id="endcreate_time" name="endDate"  placeholder="请选择日期..."/>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="control-label">状态</label>
                                <div class="input-group">
                                    <select name="advanceStatus" class="form-control" >
                                        <option value="">全部</option>
                                        <c:forEach items="${fns:getDictList('advance_status')}" var="pay">
                                                <option value="${pay.value}">${pay.label}</option>
                                        </c:forEach>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label class="control-label">关键字</label>
                                <div class="input-group">
                                    <input type="text" class="form-control " name="likeValue" placeholder="订单编号/产品名称/项目名称/客户名称">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-primary" onclick="doSumbit()">搜索</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>佣金列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <label>获得总佣金：${vo.numCommission}  已结算佣金：${vo.alreadyCommission}   未结算佣金：${vo.availableCommission}</label>
                                    <div id="toolbar" class="btn-group m-t-sm">
                                          <button type="button" class="btn btn-default" title="申请结算" onclick="member_start()">
                                              <i class="glyphicon glyphicon-plus">申请结算</i>
                                          </button>
                                          <button type="button" class="btn btn-default" title="绑定银行卡" onclick="openDiv()">
                                              <i class="glyphicon glyphicon-plus">绑定银行卡</i>
                                          </button>
                                            <button type="button" class="btn btn-default" title="绑定银行卡" onclick="refreshdiv()">
                                                <i class="glyphicon glyphicon-refresh">刷新数据</i>
                                            </button>
                                    </div>
                                    <table id="table"
                                           <%--data-show-refresh="true"--%>
                                           data-toggle="table"
                                           data-search="true"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="insResellerAdvance.id"
                                           data-url="${ctxnes}/report/feeListData?companyId=${company.id}"
                                           data-query-params="queryParams"
                                           data-side-pagination="server"
                                           data-field="records"
                                           data-sort-order="desc"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-field="id" data-checkbox="true" data-field="insResellerAdvance.id" data-formatter = "stateFormatter">选择</th>
                                            <th data-halign="center" data-align="center" <%--data-sortable="true"--%> data-field="insOrderFormRest.tradeSerialNumber">订单编号</th>
                                            <th data-halign="center" data-align="center" <%--data-sortable="true"--%> data-field="insProduct.insuranceName">产品名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insOrderFormRest.name">项目名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insOrderFormRest.contractor">客户名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insOrderFormRest.dealDate">成交时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insOrderFormRest.createDate">申请时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insOrderFormRest.amount" data-formatter="setAmount">订单金额</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insResellerAdvance.ratio" data-formatter="setRatio">佣金比例</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insResellerAdvance.brokerage" >可得佣金</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="insResellerAdvance.disposeStatus" data-formatter="setStatusClass">状态</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="hidden" id="bank">
    <div class="add-member-content fadeInRight" style="width: auto">
            <form id="bankForm" action="${ctxnes}/report/saveCompanyBank" method="post" onsubmit="return validateCallback(this)">
            <div class="col-md-12">
                <div class="form-group">
                    <label class="col-sm-2 control-label">开户行:</label>
                    <div class="col-sm-4">
                        <input type="text" name="bankName" class="form-control" value="${company.bankName}">
                    </div>
                    <label class="col-sm-2 control-label">户主姓名:</label>
                    <div class="col-sm-4">
                        <input type="text" name="bankAccountName" class="form-control" value="${company.bankAccountName}">
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label class="col-sm-2 control-label">开户行所在城市:</label>
                    <div class="col-sm-10">
                        <div class="col-sm-6">
                            <select class="form-control" name="bankProvince" id="bankProvince" value="${company.province}" onchange="onbankProvinceChang(this.options[this.options.selectedIndex].value)">
                                <option value="">请选择省</option>
                            </select>
                        </div>
                        <div class="col-sm-6">
                            <select class="form-control" name="bankCity" id="bankCityId" value="${company.city}">
                                <option value="">请选择市</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label class="col-sm-2 control-label">银行卡号:</label>
                    <div class="col-sm-6">
                        <input type="text" id="bankAccount" name="bankAccount" class="form-control" value="${company.bankAccount}">
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label class="col-sm-2 control-label">银行预留电话:</label>
                    <div class="col-sm-6">
                        <input type="text" name="bankPhone" class="form-control" value="${company.bankPhone}">
                    </div>
                </div>
            </div>
                <div class="form-group">
                    <div class="col-sm-4 col-sm-offset-4 add-submit">
                        <input type="hidden" class="form-control" name="id" id="id" value="${company.id}">
                        <button class="btn btn-primary sysusersubmit" type="button"  onclick="toAjaxSubmit2(this)">保存</button>
                    </div>
                </div>
            </form>
        </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        // 日期插件
        $(document).ready(function () {
            $('#data_5 .input-daterange').datepicker({
                keyboardNavigation: false,
                forceParse: false,
                format: "yyyy-MM-dd"
            });
            initBankProvince();
        });
        //刷新
        function refreshdiv() {
            location.reload();
        }

        function initBankProvince(){
            //初始化省级下拉
            $.ajax({
                type: 'POST',
                url: "${ctx}/sysregion/province",
                dataType: 'json',
                success: function (data) {
                    var obj = document.getElementById('bankProvince');
                    for (var o in data) {
                        obj.options.add(new Option(data[o].province, data[o].id));
                    }
                    var bankProvince = '${company.bankProvince}';
                    if(bankProvince != ''){
                        $("#bankProvince option[value="+bankProvince+"]").attr("selected", true).trigger("change");
                    }
                },
                error: function (xhr) {
                    layer.msg('error');
                }
            });
           /* $("#bankCityCopy").on("change",function () {
                console.log("被选中的值"+this.options[this.selectedIndex].value); //得到被选中的值
                $.ajax({
                    type: 'POST',
                    url: "${ctx}/sysregion/province/" + this.options[this.selectedIndex].value,
                    dataType: 'json',
                    success: function (data) {
                        var obj = document.getElementById('bankCityId');
                        obj.options.length = 0;
                        obj.options.add(new Option("请选择市", ""));
                        for (var o in data) {
                            obj.options.add(new Option(data[o].citytype, data[o].id)); //这个兼容IE与firefox
                        }
                        var bankCity =  '${company.bankCity}';
                        if(bankCity != ''){
                            $("#bankCityId option[value="+bankCity+"]").attr("selected", true).trigger("change");
                        }
                    },
                    error: function (xhr) {
                        layer.msg('error');
                    }
                });
            });*/
        }
        //onchang
        function onbankProvinceChang(obj) {
            $.ajax({
                type: 'POST',
                url: "${ctx}/sysregion/province/" + obj,
                dataType: 'json',
                success: function (data) {
                    var id = 'bankCityCopy';
                    var obj = document.getElementById(id);
                    if(obj=='' || obj==null){
                        id = 'bankCityId'
                        obj = document.getElementById(id);
                    }
                    obj.options.length = 0;
                    obj.options.add(new Option("请选择市", ""));
                    for (var o in data) {
                        obj.options.add(new Option(data[o].citytype, data[o].id)); //这个兼容IE与firefox
                    }
                    var bankCity =  '${company.bankCity}';
                    if(bankCity != ''){
                        $("#"+id+" option[value="+bankCity+"]").attr("selected", true).trigger("change");
                    }
                },
                error: function (xhr) {
                    layer.msg('error');
                }
            });
        }
        function toAjaxSubmit2(obj){
            var index0 = layer.load(0, {shade: false});
            $.ajax({
                type: "POST",
                async: false,
                contentType: "application/x-www-form-urlencoded;charset=UTF-8",
                url: $(obj.closest('form')).attr("action"),
                data:$(obj.closest('form')).serializeObject(),
                dataType: "json",
                success: function(result){
                    if (result.success == true) {
                        layer.msg(result.message, {
                            shade : 0.3,
                            time : 1000
                        }, function() {
                            location.reload();
                        });
                    } else {
                        layer.msg(result.message, {
                            icon : 2,
                            time : 1000
                        });
                    }
                    layer.close(index0);
                    return false;
                },
                error: function(){
                    layer.alert('请求错误');
                }
            });
        }

        function openDiv() {
            layer.open({
                type: 1,
                area: ['650px', '420px'],
                shade: 0.2,
                scrollbar: false,//屏蔽游览器滚动条
                fix: false, //不固定
                title: '银行卡信息',
                content: $('#bank').html().replace('bankCityId','bankCityCopy'),
            });
        }

        function doSumbit() {
            var obj = $("#searchForm").serializeObject();
            obj.status = '';
            $("#table").bootstrapTable('refresh', {
                url: $("#searchForm").attr("action"),
                query: $("#searchForm").serializeObject()
            });
        }

        /*获取选中行对象*/
        function getContent(){
            var index = $("#table").find("tr.danger").data("index");
            return $("#table").bootstrapTable('getData')[index];
        }

        function setRatio(val) {
            return val+"%"

        }
        //格式化显示
        function setStatusClass(val) {
            var value="";
            $.ajax({
                type : "post",
                url : "${ctx}/dict/getDictLabel",
                data : {value:val,type:"advance_status"},
                async : false,
                success : function(data){
                    value = data;
                }
            });
            return value;
        }
        function setAmount(val) {
            return toDecimal(val);
        }

        //设置只有未提现的才可以申请提现
        function stateFormatter(value, row, index) {
            if (row.insResellerAdvance.disposeStatus != '1') {
                return {
                    disabled: true
                };
            }
            return value;
        }
        /*申请结算*/
        function member_start() {
            var ids =  $.map($('#table').bootstrapTable('getSelections'),function(row){
                return row.insResellerAdvance.id;
            });
            if($('#bankAccount').val()==''){
                layer.msg("请先绑定银行卡号", {icon: 2});
                return;
            }
            if(ids.length==0){
                layer.alert("请选择要提现的数据", {icon: 2});
                return;
            }
            layer.confirm('确认申请吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    data: {'ids': ids},
                    dataType: 'json',
                    type: 'post',
                    url: '${ctxnes}/report/withdrawalApply',
                    success: function (result) {
                        if (result.success == true) {
                            layer.msg(result.message, {icon: 6, time: 1000});
                            window.parent.location.reload();
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
    </script>
</bcxinFooter>
</body>
</html>
