<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
  <head>
    <title>分配产品列表</title>
   	<link rel="stylesheet" href="${ctxsta}/common/bootstrap-table-master/bootstrap-table.min.css" />
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" />
    <link href="${ctxsta}/admin/product/css/bootstrap.min.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/font-awesome.min.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/common.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/establish.css" rel="stylesheet">
    <link rel="stylesheet" href="${ctxsta}/admin/product/css/style.min.css"/>
    <!--[if lt IE 9]>
    <script src="${ctxsta}/admin/product/js/html5shiv.min.js"></script>
    <script src="${ctxsta}/admin/product/js/respond.min.js"></script>
    <![endif]-->
  </head>
  
  <body class="gray-bg">
	<div class="container content ">
    <div class="nav-head">
        <div class="step step1">
            <ul>
                <li class="current">
                    <strong>选择需分配的产品</strong>
                </li>
                <li>
                    <strong>选择一级分销商</strong>
                </li>
                <li>
                    <strong>设置佣金</strong>
                </li>
                <li>
                    <strong>完成</strong>
                </li>
            </ul>
        </div>
    </div>
    <div class="create">
        <form id="Form1" class="form-horizontal" action="${ctx}/ins/product/saveNextCompany" method="POST">
            <div class="row search">
                <div class="col-xs-1 keyword">
                    <span>关键字</span>
                </div>
                <div class="col-xs-3">
                    <input type="text" name="keyword" id="keyword" value="${keyword}" class="form-control" placeholder="产品名称/供应商名称/产品id"/>
                </div>
                <div class="col-xs-2">
                    <button type="button"  onclick="searchKeyword()" class="btn btn-search">搜索</button>
                </div>
            </div>

            
	            <table class="table table-bordered"  >
	                <thead>
	                <tr>
	                    <td class="check"><input type="checkbox"  id="chk_all"  /></td>
	                    <td>ID</td>
	                    <td>产品名称</td>
	                    <td>产品类型</td>
	                    <td>价格</td>
	                    <td>供应商</td>
	                </thead>
	                <tbody>
	               			<c:forEach items="${plst}" var="product">
						             <tr>
					                    <td class="check"><input type="checkbox" name="productName" value="${product.id}" onclick="changeNum()"/></td>
					                    <td>${product.id}</td>
					                    <td>${product.insuranceName}</td>
					                    <td>${fns:getDictLabel (product.productType,"product_type","")}</td>
					                    <td></td>
					                    <td>${product.supplier.companyName}</td>
					                </tr>
	                      </c:forEach>
	                </tbody>
	            </table>

            <div class="row choice">
                <div class="col-xs-6">
                    <p>已选择 <span id="checkNum">0</span> 件产品</p>
                </div>
            </div>
            <div class="row">
                <div class="row finish">
                    <div class="col-sm-9 col-sm-offset-2">
                        <a class="btn btn-long btn-lightgreen" onclick="tijiaoForm()">下一步</a>
                        <a onclick="hideWidow()" class="btn btn-long btn-lightgreen">取消分配</a>
                    </div>
                </div>

            </div>

        </form>
        
    </div>
</div>
    <bcxinFooter>
        <link rel="stylesheet" href="${ctxsta}/common/icheck/flat/green.css" />
        <script src="${ctxsta}/common/icheck/icheck.min.js"></script>
    <!-- 自定义js -->
    <script type="text/javascript">

        $(document).ready(function() {
            $('input').iCheck({
                checkboxClass: 'icheckbox_flat-green',
                radioClass: 'iradio_flat-green'
            });
        });

        $(document).ready(function () {
            $('#chk_all').on('ifChecked ifUnchecked', function(event) {
                if (event.type == 'ifChecked') {
                    $("input[name='productName']").iCheck('check');
                } else {
                    $("input[name='productName']").iCheck('uncheck');
                }
                changeNum();
            });
            $("input[name='productName']").on('ifChanged', function(event){
                changeNum();
            });
        })
//            $("#chk_all").click(function(){
//                $("[name=productName]:checkbox").attr("checked",this.checked);
//            });
            function  hideWidow() {
                layer_close();
            }

            function  searchKeyword(){
                var  keyword= $("#keyword").val();
                if(keyword!=""){
                    location.href="${ctx}/ins/product/findProductKeyword?keyword="+keyword;
                }else{
                    layer.msg("关键字不能为空！！");
                }

            }
            function  tijiaoForm(){

                var checks = document.getElementsByName("productName");
                var n = 0;
                for(i=0;i<checks.length;i++){
                    if(checks[i].checked)
                        n++;
                }
                if(n==0){
                    layer.msg('至少需要选中一个');
                }else{
                    $('#Form1').submit();
                }

    			//document.getElementById("Form1").submit();    
    		}
    		function  changeNum(){
    			var boxArray = document.getElementsByName('productName');
    			 var total = 0;
    			for(var i=0;i<boxArray.length;i++){
	    			if(boxArray[i].checked){
	    				total++;
	    			}
    			}
    		    $("#checkNum").html(total); 
    		    // alert("选中"+boxArray.length);
    		
    		}
	
    </script>
    </bcxinFooter>

  </body>
</html>
