<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>提现申请列表</title>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>提现申请列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <table id="table"
                                           <%--data-show-refresh="true"--%>
                                           data-toggle="table"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-search="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="stargazers_count"
                                           data-query-params="queryParams"
                                           data-query-params-type="limit"
                                           data-sort-order="desc"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="true">分销商名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">分销等级</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">联系方式</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">未提佣金</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">申请提现金额</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">状态</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">申请时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">备注</th>
                                            <th data-halign="center" data-align="center">操作</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <c:forEach items="${withDrawCashList}" var="list">
                                            <tr>
                                                <td>${list.distributorName}</td>
                                                <td>${fns:getDictLabel(list.distributorLevel,"distributor_level","-")}</td>
                                                <td>${list.contactWay}</td>
                                                <td>${list.unBrokerage}</td>
                                                <td>${list.brokerage}</td>
                                                <td>${fns:getDictLabel(list.advanceStatus,"advance_status","-")}</td>
                                                <td><fmt:formatDate type="both" dateStyle="medium" timeStyle="medium" value="${list.applyTime}"/></td>
                                                <td><a title="${list.remarks}">${fns:abbr(list.remarks,20)}</a></td>
                                                <td class="td-manage">
                                                    <a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="var id ='${list.id}'; member_show('查看提现详情','${ctx}/withdraw/cash/getWithDrawCashDetail/'+id,'','','900',null)" title="查看">
                                                        <i class="glyphicon glyphicon-zoom-in"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        </c:forEach>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        // 日期插件
        $(document).ready(function () {
            $('#data_5 .input-daterange').datepicker({
                keyboardNavigation: false,
                forceParse: false,
                autoclose: true,
                format: 'yyyy/MM/dd',
            });
            //拖动面板
            $(".sortable-list").sortable({
                connectWith: ".connectList"
            }).disableSelection();
        })
    </script>
</bcxinFooter>
</body>
</html>
