<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>订单列表</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>订单列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content" id="order_list">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input  class="easyui-textbox" name="keyword" data-options="prompt:'订单号/保单号/产品名称/投保人'" placeholder="" style="width:275px;" />
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        状态:
                                                        <select  class="easyui-combobox" data-options="panelWidth:120,panelHeight:198,editable:false" name="order_status" style="width:120px;">
                                                            <option value="">全部</option>
                                                            <option value="1">投保中</option>
                                                            <option value="2">待核保</option>
                                                            <option value="3">已核保</option>
                                                            <option value="4">待支付</option>
                                                            <option value="5">待承保</option>
                                                            <option value="16">承保待支付</option>
                                                            <option value="15">已拒保</option>
                                                            <%--<option value="6">已购买</option>--%>
                                                            <option value="6">已承保</option>
                                                            <option value="12">已过期</option>
                                                            <option value="13">已废弃</option>
                                                        </select>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        下单时间: 从 <input class="easyui-datebox" data-options="editable:false" name="start_time" id="start_time" style="width:125px;">
                                                        至 <input class="easyui-datebox" data-options="editable:false" name="end_time" id="end_time" style="width:125px;">
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryBtn" type="button" class="btn  btn-primary btn-sm" >
                                                            <i class="glyphicon glyphicon-search"></i> 搜索</button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryForm" type="button" class="btn btn-primary btn-sm " >
                                                            <i class="glyphicon glyphicon-minus"></i> 清空</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <div id="toolbar" class="btn-group m-t-sm">
                                        <shiro:hasPermission name="orderForm:list:syncOrder:edit">
                                            <button type="button" class="btn btn-default" style="margin-right: 5px;" title="订单同步" onclick="orderSync()">
                                                <i class="glyphicon glyphicon-sort">订单同步</i>
                                            </button>
                                        </shiro:hasPermission>
                                        <button id="d1Btn" type="button" class="btn btn-primary" title="导出所有的在保保单到excel" onclick="downAllPolicy();">
                                            <i class="glyphicon glyphicon-download-alt"></i><span id="d1BtnText"> 导出在保保单</span>
                                        </button>
                                    </div>
                                    <table id="defaultTable"
                                           data-toggle="table"
                                    <%--data-show-refresh="true"--%>
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="start_time"
                                           data-url="${ctx}/ins/policy/orderList_table"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="desc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="trade_serial_number">订单编号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="external_reference">保单号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="product_name" >产品名称</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="type_name">产品分类</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="gross_premium">订单金额</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="policy_status" data-formatter="formatPolicyStatus">订单状态</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="applicant_name">投保人</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="start_time">下单时间 </th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="dataSources" data-formatter="formatDataSources">数据来源</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="tool" data-formatter="formatOperationFn">操作 </th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />" type="text/javascript"></script>
    <script type="text/javascript">
        var _c = 1;
        $(document).ready(function () {
            //这个设置日期只是给操作人员看的，实际上是通过 function myQueryParams(params) 方法中的日期初始设置生效的
            $("#start_time").datebox("setValue", laydate.now(-90));
            $("#end_time").datebox("setValue", laydate.now(+1));
            $("#queryBtn").unbind('click').click(function(){  $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});   });  //查询按钮
            $("#clearQueryForm").unbind('click').click(function(){    $("#queryForm").form("clear");    });   //清空查询列表
        });

        function formatPolicyStatus(value,row,index){
            var policy_status  = row.policy_status;
            var result = '';
            if(policy_status == '1'){
                result = '投保中';
            }else if(policy_status == '2'){
                result = '待核保';
            }else if(policy_status == '3'){
                result = '已核保';
            }else if(policy_status == '4'){
                result = '待支付';
            }else if(policy_status == '5'){
                result = '待承保';
            }else if(policy_status == '16'){
                result = '承保待支付';
            }else if(policy_status == '15'){
                result = '已拒保';
            }else if(policy_status == '6'){
                result = '已承保';
            }else if(policy_status == '12'){
                result = '已过期';
            }else if(policy_status == '13'){
                result = '已废弃';
            }
            return result;
        }

        /*导出所有在保保单*/
        function downAllPolicy(){
            g_timer(8,"d1Btn","d1BtnText"," 导出在保保单");
            var index = layer.confirm('是否继续在保保单导出操作？',{btn: ['确定','取消'] //按钮
            }, function(){
                location.href='${ctx}/ins/policy/down_all_policy';
                layer.close(layer.index);
            });
        }

        function formatDataSources(value,row,index){
            var web_type  = row.web_type;
            var result = '';
            if(web_type == 'BLB'){
                result = 'BLB';
            }else if(web_type.indexOf('SAAS')>-1){
                result = 'SAAS';
            }else if(web_type.indexOf('PSS')>-1){
                result = 'PSS';
            }
            return result;
        }

        function formatOperationFn(value,row,index){
            var product_code = row.product_code, policy_status = row.policy_status,oid = row.oid,exNo = row.external_reference;
            var result = '';
            <shiro:hasPermission name="orderForm:list:orderDetail:view">
            result = result + '<a class="remove m-l-sm text-warning" href="javascript:void(0)" onclick="member_urls('+1+',\''+oid+'\');" title="订单详细信息">'
            result = result + '<i class="glyphicon glyphicon-zoom-in"></i>'
            result = result + '</a>'
            </shiro:hasPermission>
            <shiro:hasPermission name="orderForm:list:underwriting:view">
            if(policy_status == '2' && product_code == 'BZX-SSBQ'){ //诉讼保全
                result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+2+',\''+oid+'\')" title="核保">'
                result = result + '<i class="glyphicon glyphicon-eye-open"></i>'
                result = result + '</a>'
            }else if(policy_status == '2' && product_code == 'BZX-GCLY'){  //工程履约
                result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+3+',\''+oid+'\')" title="核保">'
                result = result + '<i class="glyphicon glyphicon-eye-open"></i>'
                result = result + '</a>'
            }else{
                if(policy_status == '2' && product_code != 'XYX-XWCK'){
                    result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+4+',\''+oid+'\')" title="核保">'
                    result = result + '<i class="glyphicon glyphicon-eye-open"></i>'
                    result = result + '</a>'
                }
                if(policy_status == '4' && product_code != 'XYX-DQCK'){
                    result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="copy_policy(\''+oid+'\')" title="复制">'
                    result = result + '<i class="glyphicon glyphicon-copy"></i>'
                    result = result + '</a>'
                }
            }
            </shiro:hasPermission>
            <shiro:hasPermission name="orderForm:list:underwrite:view">
            if(policy_status == '5' && product_code == 'BZX-SSBQ'){
                result = result + '<a class="edit m-l-sm text-danger" href="javascript:void(0)" onclick="member_urls('+5+',\''+oid+'\')" title="承保">'
                result = result + '<i class="glyphicon glyphicon-log-in"></i>'
                result = result + '</a>'
            }else if(policy_status == '5' && product_code == 'BZX-GCLY'){
                result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+6+',\''+oid+'\')" title="承保">'
                result = result + '<i class="glyphicon glyphicon-log-in"></i>'
                result = result + '</a>'
            }else{
                if(policy_status == '5' && product_code != 'XYX-XWCK'){
                    result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+7+',\''+oid+'\')" title="承保">'
                    result = result + '<i class="glyphicon glyphicon-log-in"></i>'
                    result = result + '</a>'
                }
            }
            </shiro:hasPermission>
            <shiro:hasPermission name="orderForm:list:payment:view">
            if((product_code == 'XYX-DQCK' || product_code == 'BZX-SSBQ' || product_code == 'BZX-GCLY' || product_code.indexOf('GZZRX-PAC')>=0 || product_code.indexOf('TYX-PAC')>=0 || product_code.indexOf('GZZRX-CA')>=0 || product_code.indexOf('TYX-CA')>=0 ) && (policy_status == '4' || policy_status == '16' || policy_status == '6')  && product_code != 'XYX-XWCK'){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_urls('+8+',\''+oid+'\')" href="javascript:void(0)" title="支付详情">'
                result = result + '<i class="glyphicon glyphicon-list-alt"></i>'
                result = result + '</a>'
            }
            </shiro:hasPermission>
            <shiro:hasPermission name="orderForm:list:payment:view">
            if((product_code.indexOf('GZZRX')>=0 || product_code.indexOf('TYX')>=0) && policy_status == '3'){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_urls('+8+',\''+oid+'\')" href="javascript:void(0)" title="支付详情">'
                result = result + '<i class="glyphicon glyphicon-list-alt"></i>'
                result = result + '</a>'
            }
            if((policy_status == '4')||(product_code.indexOf('GZZRX')>=0 || product_code.indexOf('TYX')>=0) && (policy_status == '6' || policy_status == '16')){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_surrender(\''+exNo+'\',\''+oid+'\')" href="javascript:void(0)" title="废弃">'
                result = result + '<i class="glyphicon glyphicon-trash"></i>'
                result = result + '</a>'
            }
            if((product_code.indexOf('GZZRX')>=0 || product_code.indexOf('TYX')>=0) && policy_status == '6'){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_update_link(\''+oid+'\')" href="javascript:void(0)" title="修改联系人">'
                result = result + '<i class="glyphicon glyphicon-edit"></i>'
                result = result + '</a>'
            }
            </shiro:hasPermission>
            if((product_code.indexOf('GZZRX')>=0 || product_code.indexOf('TYX')>=0 || product_code.indexOf('GYX')>=0) && policy_status == '6' ){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_urls('+9+',\''+oid+'\')" href="javascript:void(0)" title="在保人员">'
                result = result + '<i class="glyphicon glyphicon-th-list"></i>'
                result = result + '</a>'
            }
            return result;
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            //只初始的时候生效一次
            if(_c==1){
                obj.start_time = laydate.now(-90);
                obj.end_time = laydate.now(+1);
                _c=0;
            }
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }

        function member_preSure(oid,baseUrl){
            window.location = baseUrl + "/ins/policy/initOrderAudit/" + oid;
        }

        /*订单-同步支撑操作*/
        function orderSync(){
            layer.confirm('确认将未成功同步到支撑的订单重新同步操作吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}'+'/ins/policy/orderSync',
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        /*订单-删除*/
        function member_del(obj,id){
            layer.confirm('确认要删除吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}'+'/ins/policy/orderDelete',
                    data:{'order_id':id},
                    success:function(result){
                        if(result.success==true){
                            $('#defaultTable').bootstrapTable('refresh');
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        /*订单-修改保单联系人*/
        function member_update_link(id){
            var str = "<div>" +
                "<p style='padding-bottom: 5px;'>姓名：<input class='form-control' type='text' id='name' /></p>" +
                "<p style='padding-bottom: 5px;'>手机：<input class='form-control' type='text' id='tel' /></p>" +
                "<p style='padding-bottom: 5px;'>邮箱：<input class='form-control' type='text' id='email' /></p>" +
                "</div>";
            layer.confirm(str,{btn: ['修改','取消'], title: "保单联系人修改"}, function(){
                var name = $("#name").val();
                if (name == null || name == undefined) {
                    name = '';
                }
                var tel = $("#tel").val();
                if (tel == null || tel == undefined) {
                    layer.msg('请输入手机', {icon: 2});
                }
                var email = $("#email").val();
                if (email == null || email == undefined) {
                    layer.msg('请输入邮箱', {icon: 2});
                }
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}'+'/ins/policy/updateInsRolePolicyLink',
                    data:{'oid':id,'name':name,'tel':tel,'email':email},
                    success:function(result){
                        if(result.success==true){
//                            $('#defaultTable').bootstrapTable('refresh');
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        /*订单-退保*/
        function member_surrender(exNo,id){
            var str = "<div>" +
                "<p style='padding-bottom: 5px;'>保单号："+exNo+"</p>" +
                "<p style='padding-bottom: 5px;'>生效日期：<input class='form-control' type='text' id='inception_date' placeholder='yyyy-MM-dd' /></p>" +
                "<p style='padding-bottom: 5px;'>保费：<input class='form-control' type='text' id='premium' /></p>" +
                "</div>";
            layer.confirm(str,{btn: ['退保','取消'], title: "保单退保操作"}, function(){
                var inception_date = $("#inception_date").val();
                // if (inception_date == null || inception_date == undefined) {
                //     layer.msg('请输入生效日期', {icon: 2});
                // }
                var premium = $("#premium").val();
                // if (premium == null || premium == undefined) {
                //     layer.msg('请输入保费', {icon: 2});
                // }
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}'+'/ins/policy/surrender',
                    data:{'oid':id,'inception_date':inception_date,'premium':premium},
                    success:function(result){
                        if(result.success==true){
                            $('#defaultTable').bootstrapTable('refresh');
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        /*订单-复制*/
        function copy_policy(id){
            layer.confirm('确认要复制该订单吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctx}'+'/ins/policy/copyPolicy/'+id,
                    success:function(result){
                        if(result.success==true){
                            $('#defaultTable').bootstrapTable('refresh');
                            layer.alert(result.msg, {icon: 1});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function member_urls(sign,_id,rr){
            if(sign == '1'){
                member_show('订单详细信息','${ctx}/ins/policy/getOrderDetatil/'+_id,'','',1000,null);
            }else if(sign == '2'){
                member_show('订单核保','${ctx}/ins/policy/initOrderAuditLitigation/'+_id+'/1','','',1000,null);
            }else if(sign == '3'){
                member_show('订单核保','${ctx}/ins/policy/initOrderAuditPG/'+_id+'/1','','',1000,null);
            }else if(sign == '4'){
                member_show('订单核保','${ctx}/ins/policy/initOrderAudit/'+_id,'','',1000,null);
            }else if(sign == '5'){
                member_show('订单承保','${ctx}/ins/policy/initOrderAuditLitigation/'+_id+'/0','','',1000,null);
            }else if(sign == '6'){
                member_show('订单承保','${ctx}/ins/policy/initOrderAuditPG/'+_id+'/0','','',1000,null);
            }else if(sign == '7'){
                member_show('订单承保','${ctx}/ins/policy/initOrderUnderwriting/'+_id,'','',1000,null);
            }else if(sign == '8'){
                member_show('支付详情','${ctx}/ins/policy/initTransactionDetail/'+_id,'','',1000,null);
            }else if(sign == '9'){
                member_show('在保人员列表','${ctx}/ins/policy/underWarrantyList/'+_id,'','',1000,null);
            }
        }
    </script>
</bcxinFooter>
</body>
</html>
