<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>订单列表</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>
<style>

    .div1 {
        position: relative;
        /*left: 90px;*/
    }
    .div2 {
        width: 100px;
        height: 36px;
        background: #2178fc;
        color: #fff;
        text-align: center;
        line-height: 36px;
    }
    .upload_file {
        width: 100px;/*因为file-input在部分浏览器中会自带一个输入框，需要双击才可以点击上传,放大后将其定位到div外面就好啦*/
        height: 36px;
        position: absolute;
        left: 0px;
        top: 0;
        z-index:1;
        -moz-opacity: 0;
        -ms-opacity: 0;
        -webkit-opacity: 0;
        opacity: 0;  /*css属性——opcity不透明度，取值0-1*/
        filter: alpha(opacity=0); /*兼容IE8及以下--filter属性是IE特有的，它还有很多其它滤镜效果，而filter: alpha(opacity=0); 兼容IE8及以下的IE浏览器(如果你的电脑IE是8以下的版本，使用某些效果是可能会有一个允许ActiveX的提示,注意点一下就ok啦)*/
        cursor: pointer;
    }
</style>
<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>订单列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content" id="order_list">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input  class="easyui-textbox" name="keyword" data-options="prompt:'订单号/保单号/产品名称/投保人'" placeholder="" style="width:275px;" />
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        状态:
                                                        <select  class="easyui-combobox" data-options="panelWidth:120,panelHeight:198,editable:false" name="order_status" style="width:120px;">
                                                            <option value="">全部</option>
                                                            <option value="1">投保中</option>
                                                            <option value="2">待核保</option>
                                                            <option value="3">已核保</option>
                                                            <option value="4">待支付</option>
                                                            <option value="5">待承保</option>
                                                            <option value="16">承保待支付</option>
                                                            <option value="15">已拒保</option>
                                                            <%--<option value="6">已购买</option>--%>
                                                            <option value="6">已承保</option>
                                                            <option value="12">已过期</option>
                                                            <option value="13">已废弃</option>
                                                        </select>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        下单时间: 从 <input class="easyui-datebox" data-options="editable:false" name="start_time" id="start_time" style="width:125px;">
                                                        至 <input class="easyui-datebox" data-options="editable:false" name="end_time" id="end_time" style="width:125px;">
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryBtn" type="button" class="btn  btn-primary btn-sm" >
                                                            <i class="glyphicon glyphicon-search"></i> 搜索</button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryForm" type="button" class="btn btn-primary btn-sm " >
                                                            <i class="glyphicon glyphicon-minus"></i> 清空</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <div id="toolbar" class="btn-group m-t-sm">
                                        <c:if test="${sup_id eq 'sup_admin'}">
                                            <button type="button" class="btn btn-default btn-sm" style="margin-right: 5px;" title="订单同步" onclick="orderSync()">
                                                <i class="glyphicon glyphicon-sort">订单同步</i>
                                            </button>
                                            <button id="d1Btn" type="button" class="btn btn-primary btn-sm" title="导出所有的在保保单到excel" onclick="downAllPolicy();">
                                                <i class="glyphicon glyphicon-download-alt"></i><span id="d1BtnText"> 导出在保保单</span>
                                            </button>
                                            <button id="d4Btn" type="button" class="btn btn-warning btn-sm" title="导入保单业务员名单"
                                                    onclick="toLeadBP();" style="margin-left: 10px;">
                                                <i class="glyphicon glyphicon-upload"></i><span id="d4BtnText"> 导入保单业务员名单</span>
                                            </button>
                                        </c:if>
                                    </div>
                                    <table id="defaultTable"
                                           data-toggle="table"
                                    <%--data-show-refresh="true"--%>
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="start_time"
                                           data-url="${ctxapi}/myPolicy/orderList_table/${sup_id}"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="desc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="trade_serial_number">订单编号</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="external_reference">保单号</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="product_name" >产品名称</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="type_name">产品分类</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="gross_premium">订单金额</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="policy_status" data-formatter="formatPolicyStatus">订单状态</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="applicant_name">投保人</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="start_time">下单时间 </th>
                                            <th data-halign="center" data-align="center" data-visible="false" data-sortable="true" data-field="insurance_name">保险公司名称 </th>
                                            <th data-halign="center" data-align="center" data-visible="false" data-sortable="true" data-field="recommend_code">推荐人 </th>
                                            <th data-halign="center" data-align="center" data-visible="false" data-sortable="true" data-field="inception_date">起保日期 </th>
                                            <th data-halign="center" data-align="center" data-visible="false" data-sortable="true" data-field="pay_time">支付时间 </th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="bpName">业务员 </th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="dataSources" data-formatter="formatDataSources">数据来源</th>
                                            <th data-halign="center" data-align="center" data-visible="true" data-sortable="true" data-field="tool" data-formatter="formatOperationFn">操作 </th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />" type="text/javascript"></script>
    <script type="text/javascript">
        var _c = 1;
        $(document).ready(function () {
            //这个设置日期只是给操作人员看的，实际上是通过 function myQueryParams(params) 方法中的日期初始设置生效的
            $("#start_time").datebox("setValue", laydate.now(-90));
            $("#end_time").datebox("setValue", laydate.now(+1));
            $("#queryBtn").unbind('click').click(function(){  $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});   });  //查询按钮
            $("#clearQueryForm").unbind('click').click(function(){    $("#queryForm").form("clear");    });   //清空查询列表
        });

        function formatPolicyStatus(value,row,index){
            var policy_status  = row.policy_status;
            var result = '';
            if(policy_status == '1'){
                result = '投保中';
            }else if(policy_status == '2'){
                result = '待核保';
            }else if(policy_status == '3'){
                result = '已核保';
            }else if(policy_status == '4'){
                result = '待支付';
            }else if(policy_status == '5'){
                result = '待承保';
            }else if(policy_status == '16'){
                result = '承保待支付';
            }else if(policy_status == '15'){
                result = '已拒保';
            }else if(policy_status == '6'){
                result = '已承保';
            }else if(policy_status == '12'){
                result = '已过期';
            }else if(policy_status == '13'){
                result = '已废弃';
            }
            return result;
        }

        /*导出所有在保保单*/
        function downAllPolicy(){
            g_timer(8,"d1Btn","d1BtnText"," 导出在保保单");
            var index = layer.confirm('是否继续在保保单导出操作？',{btn: ['确定','取消'] //按钮
            }, function(){
                location.href='${ctxapi}/myPolicy/down_all_policy';
                layer.close(layer.index);
            });
        }

        function toLeadBP(){
            g_timer(8,"d4Btn","d4BtnText"," 导入保单业务员名单");
            var str = "<div style='padding: 20px 20px;'><form id='uploadForm'><div class='div1'><div class='div2'>导入业务员</div>" +
                "<input type='file' class='upload_file' id='xfile' name='xfile' onchange=\"uploadBP('uploadForm');\">" +
                "<div style=\"\n" +
                "    position: absolute;\n" +
                "    display: block;\n" +
                "    left: 120px;\n" +
                "    top: 10px;\n" +
                "\"><a href='/resources/files/保单业务员导入范本.xls'>模板下载</a></div>" +
                "<p style='padding-top: 5px;'>注：请点击“模板下载”，按模板要求整理数据，完成后点击“导入业务员”按钮进行名单导入。</p>" +
                "</div></form></div>";
            var index = layer.open({
                type: 1,
                title: "导入保单业务员名单",
                area: ['350px', '200px'], //宽高
                shadeClose: false,
                content: str
            });
        }

        function uploadBP(_form){
            var formData = new FormData(document.forms.namedItem(_form));
            $.ajax({
                type: 'POST',
                url:'${ctxapi}/myPolicy/uploadBP',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(result) {
                    if(result.success) {
                        layer.msg("上传成功");
                        layer.closeAll();
                    }else {
                        layer.msg(result.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                }
            });
        }

        function formatDataSources(value,row,index){
            var web_type  = row.web_type;
            var result = '';
            if(web_type == 'BLB'){
                result = 'BLB';
            }else if(web_type.indexOf('SAAS')>-1){
                result = 'SAAS';
            }else if(web_type.indexOf('PSS')>-1){
                result = 'PSS';
            }
            return result;
        }

        function formatOperationFn(value,row,index){
            var product_code = row.product_code, policy_status = row.policy_status,oid = row.oid;
            var result = '';
            result = result + '<a class="remove m-l-sm text-warning" href="javascript:void(0)" onclick="member_urls('+1+',\''+oid+'\');" title="订单详细信息">'
            result = result + '<i class="glyphicon glyphicon-zoom-in"></i>'
            result = result + '</a>'
            if(policy_status == '2' && product_code == 'BZX-SSBQ'){ //诉讼保全
                result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+2+',\''+oid+'\')" title="核保">'
                result = result + '<i class="glyphicon glyphicon-eye-open"></i>'
                result = result + '</a>'
            }else if(policy_status == '2' && product_code == 'BZX-GCLY'){  //工程履约
                result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+3+',\''+oid+'\')" title="核保">'
                result = result + '<i class="glyphicon glyphicon-eye-open"></i>'
                result = result + '</a>'
            }else{
                if(policy_status == '2' && product_code != 'XYX-XWCK'){
                    result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+4+',\''+oid+'\')" title="核保">'
                    result = result + '<i class="glyphicon glyphicon-eye-open"></i>'
                    result = result + '</a>'
                }
                if(policy_status == '4' && product_code != 'XYX-DQCK'){
                    result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="copy_policy(\''+oid+'\')" title="复制">'
                    result = result + '<i class="glyphicon glyphicon-copy"></i>'
                    result = result + '</a>'
                }
            }
            if(policy_status == '5' && product_code == 'BZX-SSBQ'){
                result = result + '<a class="edit m-l-sm text-danger" href="javascript:void(0)" onclick="member_urls('+5+',\''+oid+'\')" title="承保">'
                result = result + '<i class="glyphicon glyphicon-log-in"></i>'
                result = result + '</a>'
            }else if(policy_status == '5' && product_code == 'BZX-GCLY'){
                result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+6+',\''+oid+'\')" title="承保">'
                result = result + '<i class="glyphicon glyphicon-log-in"></i>'
                result = result + '</a>'
            }else{
                if(policy_status == '5' && product_code != 'XYX-XWCK'){
                    result = result + '<a class="edit m-l-sm text-primary" href="javascript:void(0)" onclick="member_urls('+7+',\''+oid+'\')" title="承保">'
                    result = result + '<i class="glyphicon glyphicon-log-in"></i>'
                    result = result + '</a>'
                }
            }
            if((product_code == 'XYX-DQCK' || product_code == 'BZX-SSBQ' || product_code == 'BZX-GCLY' || product_code.indexOf('GZZRX-PAC')>=0 || product_code.indexOf('TYX-PAC')>=0 || product_code.indexOf('GZZRX-CA')>=0 || product_code.indexOf('TYX-CA')>=0 ) && (policy_status == '4' || policy_status == '16' || policy_status == '6')  && product_code != 'XYX-XWCK'){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_urls('+8+',\''+oid+'\')" href="javascript:void(0)" title="支付详情">'
                result = result + '<i class="glyphicon glyphicon-list-alt"></i>'
                result = result + '</a>'
            }
            if((product_code.indexOf('GZZRX')>=0 || product_code.indexOf('TYX')>=0) && policy_status == '3'){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_urls('+8+',\''+oid+'\')" href="javascript:void(0)" title="支付详情">'
                result = result + '<i class="glyphicon glyphicon-list-alt"></i>'
                result = result + '</a>'
            }
            if((product_code.indexOf('GZZRX')>=0 || product_code.indexOf('TYX')>=0 || product_code.indexOf('GYX')>=0) && policy_status == '6' ){
                result = result + '<a class="edit m-l-sm text-primary" onclick="member_urls('+9+',\''+oid+'\')" href="javascript:void(0)" title="在保人员">'
                result = result + '<i class="glyphicon glyphicon-th-list"></i>'
                result = result + '</a>'
            }
            return result;
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            //只初始的时候生效一次
            if(_c==1){
                obj.start_time = laydate.now(-90);
                obj.end_time = laydate.now(+1);
                _c=0;
            }
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }

        function member_preSure(oid,baseUrl){
            window.location = baseUrl + "/myPolicy/initOrderAudit/" + oid;
        }

        /*订单-同步支撑操作*/
        function orderSync(){
            layer.confirm('确认将未成功同步到支撑的订单重新同步操作吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}'+'/myPolicy/orderSync',
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        /*订单-删除*/
        function member_del(obj,id){
            layer.confirm('确认要删除吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}'+'/myPolicy/orderDelete',
                    data:{'order_id':id},
                    success:function(result){
                        if(result.success==true){
                            $('#defaultTable').bootstrapTable('refresh');
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        /*订单-复制*/
        function copy_policy(id){
            layer.confirm('确认要复制该订单吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}'+'/myPolicy/copyPolicy/'+id,
                    success:function(result){
                        if(result.success==true){
                            $('#defaultTable').bootstrapTable('refresh');
                            layer.alert(result.msg, {icon: 1});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function member_urls(sign,_id,rr){
            if(sign == '1'){
                member_show('订单详细信息','${ctxapi}/myPolicy/getOrderDetatil/'+_id+'?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '2'){
                member_show('订单核保','${ctxapi}/myPolicy/initOrderAuditLitigation/'+_id+'/1?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '3'){
                member_show('订单核保','${ctxapi}/myPolicy/initOrderAuditPG/'+_id+'/1?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '4'){
                member_show('订单核保','${ctxapi}/myPolicy/initOrderAudit/'+_id+'?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '5'){
                member_show('订单承保','${ctxapi}/myPolicy/initOrderAuditLitigation/'+_id+'/0?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '6'){
                member_show('订单承保','${ctxapi}/myPolicy/initOrderAuditPG/'+_id+'/0?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '7'){
                member_show('订单承保','${ctxapi}/myPolicy/initOrderUnderwriting/'+_id+'?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '8'){
                member_show('支付详情','${ctxapi}/myPolicy/initTransactionDetail/'+_id+'?sup_id=${sup_id}','','',1000,null);
            }else if(sign == '9'){
                member_show('在保人员列表','${ctxapi}/myPolicy/underWarrantyList/${sup_id}/'+_id,'','',1000,null);
            }
        }
    </script>
</bcxinFooter>
</body>
</html>
