<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>信息统计</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
    <style>
        .ibox-content{
            background-color: #fff !important;
        }
    </style>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight" style="background-color: #F5F5F5;">

    <div class="row">
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>订单基础数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;">
                        <select id="year" class="form-control" onchange="o1($(this).val())">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="chartmain" style="height: 400px">
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>产品关联订单数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;width: 185px;">
                        <select id="y1" class="form-control" onchange="setM('m1',$(this).val())" style="width: 90px;float: left;margin-right: 5px;">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                        <select id="m1" class="form-control" onchange="o2($('#y1').val()+'-'+$('#m1').val())" style="width: 90px;">
                            <c:forEach items="${tms}" var="m">
                                <option value="${m}" <c:if test="${m eq tm}"> selected</c:if>>${m}月</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="prochart" style="height: 400px">
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>产品关联订单保费统计数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;width: 185px;">
                        <select id="y2" class="form-control" onchange="setM('m2',$(this).val())" style="width: 90px;float: left;margin-right: 5px;">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                        <select id="m2" class="form-control" onchange="o3($('#y2').val()+'-'+$('#m2').val())" style="width: 90px;">
                            <c:forEach items="${tms}" var="m">
                                <option value="${m}" <c:if test="${m eq tm}"> selected</c:if>>${m}月</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="amtchart" style="height: 400px">
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>订单累计销售额数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;">
                        <select id="y3" class="form-control" onchange="o4($(this).val())">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="allamtchart" style="height: 400px">
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
            });

        });
        function planFn(value, row, index){
            return row.plan_star_time + '~' + row.plan_end_time;
        }
        function informTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '系统升级';
            }else if('1' == value){
                it = '功能或产品推广';
            }
            return it;
        }
        function executeTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '每次';
            }else if('1' == value){
                it = '单次';
            }else if('1' == value){
                it = '暂停';
            }
            return it;
        }

        function rownumFn(value, row, index){
            var opt = $('#defaultTable').bootstrapTable('getOptions');
            if(opt.pageSize=="All") return index +1;
            return opt.pageSize * (opt.pageNumber - 1) + index + 1;
        }

        function formatOperationFn(index, row) {
            var str = "";
            //查看然后编辑按钮
            <shiro:hasPermission name="myinf:win:upd">
                var onClick = "layer_show('修改公告-"+row.city_name+"','${ctx}/myinf/win/upd?com_inform_id=${p.com_inform_id}',980,null);";
                str += '<a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="'+onClick+'" title="查看" > <i class="glyphicon glyphicon-edit"></i></a>';
            </shiro:hasPermission>
            <shiro:hasPermission name="myinf:win:del">
                var onClick2= "member_del(this,'"+row.com_inform_id+"')";
                str += '<a class="remove m-l-sm text-primary" href="javascript:void(0)" onclick="'+onClick2+'" title="删除" > <i class="glyphicon glyphicon-remove"></i></a>';
            </shiro:hasPermission>
                return str;
        }
        /*删除公告*/
        function member_del(obj, id) {
            layer.confirm('确认要删除该公告信息吗？', {  btn: ['确定', '取消'] }, function () {
                g_ajax('${ctx}/myinf/del',{com_inform_id:id}, function(json){
                    comm_back(json);
                });
            });
        }
        function comm_back(json){
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }

        function setM(id,y){
            var year=(new Date()).getFullYear();
            var min_m = 1;
            var max_m = 12;
            if(Number(y) == year){
                max_m = (new Date()).getMonth()+1;
            }
            $("#" + id).empty();
            for(var i=min_m;i<=max_m;i++){
                $("#" + id).append("<option value='"+i+"'>"+i+"月</option>");
            }
        }

        function o1(y){
            g_ajax('${ctx}/mysta/com-order',{year:y}, function(json){
                if(json.success == true){
                    orderchart(json);
                }
            });
        }
        function o2(ym){
            g_ajax('${ctx}/mysta/pro-order',{ym:ym}, function(json){
                if(json.success == true){
                    prochart(json);
                }
            });
        }
        function o3(ym){
            g_ajax('${ctx}/mysta/pro-order-amout',{ym:ym}, function(json){
                if(json.success == true){
                    amtchart(json);
                }
            });
        }
        function o4(y){
            g_ajax('${ctx}/mysta/all-amt',{year:y}, function(json){
                if(json.success == true){
                    allAmtChart(json);
                }
            });
        }
        $(function(){
            var date = new Date();
            var year = date.getFullYear();
            var month = date.getMonth() + 1;
            var strDate = date.getDate();
            if (month >= 1 && month <= 9) {
                month = "0" + month;
            }
            o1(year+'');
            setTimeout(function(){o2(year+'-'+month);},100);
            setTimeout(function(){o3(year+'-'+month);},200);
            setTimeout(function(){o4(year+'');},300);
        });

        function allAmtChart(json){
            data = json.data.pls;
            var dateList = data.map(function (item) {
                return item[0];
            });
            var valueList = data.map(function (item) {
                return item[1];
            });

            option = {
                visualMap: [{
                    show: false,
                    type: 'continuous',
                    seriesIndex: 0,
                    min: 0,
                    max: json.data.max
                }],


                title: [{
                    left: 'center',
                    text: '统计每月销售金额、当月累计销售总额',
                    subtext: '年度销售总额：'+json.data.amounts
                }],
                tooltip: {
                    trigger: 'axis'
                },
                xAxis: [{
                    data: dateList
                }],
                yAxis: [{
                    splitLine: {show: false}
                }],
                series: [{
                    type: 'line',
                    showSymbol: false,
                    data: valueList
                }]
            };
            //初始化echarts实例
            var allAmtChart = echarts.init(document.getElementById('allamtchart'));
            //使用制定的配置项和数据显示图表
            allAmtChart.setOption(option);
        }

        function amtchart(json){
            option = {
                title : {
                    text: '月产品保费成交比例',
                    subtext: '展示关于当月已承保产品订单对应保费统计的饼状图(总保费：'+json.data.amounts+')',
                    x:'center'
                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    data: json.data.names
                },
                series : [
                    {
                        name: '月保费统计数据',
                        type: 'pie',
                        radius : '55%',
                        center: ['50%', '60%'],
                        data:json.data.list,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            }
                        }
                    }
                ]
            };
            //初始化echarts实例
            var prochart = echarts.init(document.getElementById('amtchart'));
            //使用制定的配置项和数据显示图表
            prochart.setOption(option);
        }

        function prochart(json){
            option = {
                title : {
                    text: '月产品成交比例',
                    subtext: '展示关于当月已承保订单对应产品的饼状图',
                    x:'center'
                },
                tooltip : {
                    trigger: 'item',
                    formatter: "{a} <br/>{b} : {c} ({d}%)"
                },
                legend: {
                    orient: 'vertical',
                    left: 'left',
                    data: json.data.names
                },
                series : [
                    {
                        name: '产品承保数据',
                        type: 'pie',
                        radius : '55%',
                        center: ['50%', '60%'],
                        data:json.data.list,
                        itemStyle: {
                            emphasis: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            }
                        }
                    }
                ]
            };
            //初始化echarts实例
            var prochart = echarts.init(document.getElementById('prochart'));
            //使用制定的配置项和数据显示图表
            prochart.setOption(option);
        }

        function orderchart(json){
            m_option = json.data.yms;
            var colors = ['#5793f3', '#d14a61', '#675bba'];

            option = {
                color: colors,

                tooltip: {
                    trigger: 'axis',
                    axisPointer: {
                        type: 'cross'
                    }
                },
                grid: {
                    right: '20%'
                },
                toolbox: {
                    feature: {
                        dataView: {show: true, readOnly: false},
                        restore: {show: true},
                        saveAsImage: {show: true}
                    }
                },
                legend: {
                    data:['下单数','成交数','成交率']
                },
                xAxis: [
                    {
                        type: 'category',
                        axisTick: {
                            alignWithLabel: true
                        },
                        data: m_option
                    }
                ],
                yAxis: [
                    {
                        type: 'value',
                        name: '下单数',
                        min: 0,
                        max: json.data.max,
                        position: 'right',
                        axisLine: {
                            lineStyle: {
                                color: colors[0]
                            }
                        },
                        axisLabel: {
                            formatter: '{value}'
                        }
                    },
                    {
                        type: 'value',
                        name: '成交数',
                        min: 0,
                        max: json.data.max,
                        position: 'right',
                        offset: 80,
                        axisLine: {
                            lineStyle: {
                                color: colors[1]
                            }
                        },
                        axisLabel: {
                            formatter: '{value}'
                        }
                    },
                    {
                        type: 'value',
                        name: '成交率',
                        min: 0,
                        max: 100,
                        position: 'left',
                        axisLine: {
                            lineStyle: {
                                color: colors[2]
                            }
                        },
                        axisLabel: {
                            formatter: '{value} %'
                        }
                    }
                ],
                series: [
                    {
                        name:'下单数',
                        type:'bar',
                        data:json.data.xds
                    },
                    {
                        name:'成交数',
                        type:'bar',
                        yAxisIndex: 1,
                        data:json.data.cjs
                    },
                    {
                        name:'成交率',
                        type:'line',
                        yAxisIndex: 2,
                        data:json.data.bls
                    }
                ]
            };


            //初始化echarts实例
            var chartmain = echarts.init(document.getElementById('chartmain'));
            //使用制定的配置项和数据显示图表
            chartmain.setOption(option);
        }

    </script>
</bcxinFooter>
</body>
</html>
