<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>保全详情</title>
    <%@include file="/WEB-INF/include/head.jsp" %>
    <style>
        .bid-context table {
            width: 100%;

        }

        .bid-context table thead tr {
            background: #eee;
        }
        .buttonDiv
        {
            font-size:12px;
            text-align:center;
            padding:30px;
            vertical-align:middle ;
            line-height:22px;
            margin: 0 auto;

        }
        .fileinput-button input{
            position:absolute;
            right: 0px;
            top:0px;
            opacity: 0;
            -ms-filter: 'alpha(opacity=0)';
            font-size: 200px;
        }
        .bid-context table tr {
            line-height: 40px;
        }

        .bid-context table tr td {
            text-align: center;
            border: 1px solid #ddd;
        }
        .div1 {
            position: relative;
            left: 90px;
        }
        .div2 {
            width: 100px;
            height: 36px;
            background: #2178fc;
            color: #fff;
            text-align: center;
            line-height: 36px;
        }

        .upload_file {
            width: 200px;/*因为file-input在部分浏览器中会自带一个输入框，需要双击才可以点击上传,放大后将其定位到div外面就好啦*/
            height: 36px;
            position: absolute;
            left: 0px;
            top: 0;
            z-index:1;
            -moz-opacity: 0;
            -ms-opacity: 0;
            -webkit-opacity: 0;
            opacity: 0;  /*css属性——opcity不透明度，取值0-1*/
            filter: alpha(opacity=0); /*兼容IE8及以下--filter属性是IE特有的，它还有很多其它滤镜效果，而filter: alpha(opacity=0); 兼容IE8及以下的IE浏览器(如果你的电脑IE是8以下的版本，使用某些效果是可能会有一个允许ActiveX的提示,注意点一下就ok啦)*/
            cursor: pointer;
        }
    </style>
</head>

<body>
<!-- 基础信息 start -->
<div class="container bid">
    <div class="content">
        <h3>基础信息</h3>
        <div class="row bid-context">
            <div class="col-sm-12">
                <ul class="bid-ul">
                    <li class="no-bor">保单号</li>
                    <li class="no-bor" title="${preservationRecordVo.external_reference}">${preservationRecordVo.external_reference}</li>
                    <li class="no-bor">暂批改单号</li>
                    <li class="no-bor">${preservationRecordVo.revise_serial_number}</li>
                    <li class="no-bor">保险公司</li>
                    <li class="no-bor">${preservationRecordVo.company_name}</li>
                    <li class="no-bor">保险期限</li>
                    <li class="no-bor"> ${preservationRecordVo.planned_start_date}至${preservationRecordVo.planned_end_date}</li>
                    <li class="no-bor">保全类型</li>
                    <li class="no-bor" title="${preservationRecordVo.revise_type}">${fns:getDictLabel (preservationRecordVo.revise_type,"revise_type","")}</li>
                    <li class="no-bor">批改状态</li>
                    <li class="no-bor">${fns:getDictLabel (preservationRecordVo.revise_status,"revise_status","")}</li>
                    <li class="no-bor">投保人</li>
                    <li class="wd80 no-bor">
                        ${preservationRecordVo.app_role_name}
                    </li>

                </ul>

            </div>
        </div>
    </div>
</div>

<div class="hr-line-dashed"></div>
<!-- 基础信息 end -->
<!-- 人员信息 start -->

<div class="container bid">
    <div class="content">
        <h3>人员信息</h3>
        <div class="col-sm-12">

            <table id="defaultTable"
                   data-toggle="table"
                   data-show-refresh="true"
                   data-search="false"
            <%--data-show-toggle="true"--%>
                   data-show-export="true"
            <%--data-show-columns="true"--%>
                   data-striped="true"
                   data-pagination="true"
                   data-sort-name="status"
                   data-height="500"
                   data-url="${ctxapi}/myApply/perserverDetail/${preservationRecordVo.oid}/${preservationRecordVo.revise_status}"
                   data-method="post"
                   data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                   data-side-pagination="server"
                   data-page-list="[10, 25, 50, 100, ALL]"
                   data-query-params="myQueryParams"
                   data-sort-order="desc"
                   load-success.bs.table="onLoadSuccessFn"
                   data-toolbar="#toolbar">
                <thead>

                <tr>

                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="name">姓名
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="id_type"data-formatter="formatIDTypeFn" >证件类型
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="id_card"  >证件号码
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="tel"   >手机号
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="career" data-formatter="formatCareerFn">工种
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="scheme">方案
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="sex" data-formatter="formatSexFn">性别
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="birthday">出生日期
                    </th>
                    <th data-halign="center" data-align="center" data-field="status"
                        data-formatter="formatOperationFn"   >操作
                    </th>

                </tr>

                </thead>
            </table>

        </div>
    </div>
</div>
<form id="declinature" class="form-horizontal" action="${ctxapi}/myApply/applyAuditFail2" method="POST">
    <input type="hidden" name="status"id="status" />
    <input type="hidden" name="remark" id="remark"/>
    <input type="hidden" name="detail_id" id="detail_id" />
    <%--<input type="hidden" name="sup_id" value="${sup_id}">--%>
</form>
<div class="hr-line-dashed"></div>
<div class="container bid">
    <div class="content">
        <h3>审核处理</h3>
        <div class="row bid-context">
            <div class="col-sm-12">
                <ul class="bid-ul">
                    <li class="no-bor">生效时间</li>
                    <li class="no-bor">
                        <div class="input-daterange input-group" style="align-items: center">
                            <input class="easyui-datebox" data-options="editable:false" name="start_time"
                                   style="width:125px;" value="${preservationRecordVo.inception_date}" id="preserverTime" >


                        </div>
                    </li>
                    <li class="no-bor">批单号</li>
                    <li class="no-bor">
                            <input class="easyui-textbox" name="revise_serial_num_ins" value="${preservationRecordVo.revise_serial_num_ins}" id="reviseSerialNumIns" >
                    </li>

                    <li class="no-bor">批改单<a  class="easyui-linkbutton" plain="true" id="showPicture"
                                                onclick="loadCanvas('${preservationRecordVo.revise_path}')" iconCls="icon-search">查看</a></li>
                    <li class="no-bor" >
                        <c:if test="${preservationRecordVo.revise_status eq '2'}"><%--状态为待审核的时候才能上传--%>
                            <form id="uploadForm" >
                                <div class="div1">

                                    <div class="div2">上传批改单</div>
                                    <input type="file" id="upload_file" class="upload_file" name="upload_file"  onchange="uploadFileDetail('uploadForm');">
                                    <input name="preserverAddress"  id="preserverAddress" type="hidden" value="${preservationRecordVo.revise_path}">
                                </div>
                            </form>
                        </c:if>
                    </li>

                    <li class="no-bor">保全费用</li>
                    <li class="no-bor"><input value="${preservationRecordVo.total_premium}"  class="easyui-numberbox" data-options="precision:2" name="preserverCost" id="preserverCost"
                                             />元</li>
                </ul>

            </div>
        </div>
    </div>
</div>

<div class="hr-line-dashed"></div>
<!-- 操作记录  start -->
<div class="ibox-title">
    <h5>操作记录</h5>
</div>
<div class="ibox-content">
    <table class="table table-bordered">
        <thead>
        <tr>
            <th>操作时间</th>
            <th>操作人员</th>
            <th>操作事项</th>
            <th>备注</th>
        </tr>
        </thead>
        <tbody>
        <c:forEach items="${logList}" var="list">
            <tr>
                <td><fmt:formatDate value="${list.createTime}" pattern="yyyy/MM/dd HH:mm:ss" /></td>
                <td>${not empty list.company_id ? list.company_id : list.createBy.id}</td>
                <td>${list.title}</td>
                <td>${not empty list.company_id ? 'BLB' : 'YWZC'}</td>
            </tr>
        </c:forEach>
        </tbody>
    </table>
</div>
<!-- 操作记录  end -->

<div class="buttonDiv" style="align: center">
    <c:if test="${apprSign != 1}">
        <button id="checkSucccess" type="button" class="btn  btn-primary btn-sm" onclick="checkSucccess()"  >审核通过 </button>
    </c:if>
    <button id="checkReturn" type="button" class="btn  btn-primary btn-sm" onclick="checkReturn()" style="background-color: grey" >退出 </button>
    <c:if test="${apprSign != 1}">
        <button id="checkFail" type="button" class="btn  btn-primary btn-sm"  onclick="checkFail()"  style="background-color: red" > 审核不通过</button>
    </c:if>
</div>


<bcxinFooter>
    <script src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function () {
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function () {
                $("#queryForm").form("clear");
            });
            var resvise_status=${preservationRecordVo.revise_status};

            if (resvise_status!=2){
                $("#checkSucccess").hide();
                $("#checkFail").hide();
                $("#upload_file").attr("disabled", "disabled");

                $("#preserverTime").datebox({
                    disabled:true
                })
                $('#preserverCost').numberbox({
                    disabled:true
                });


            }else {
                updataButtonSync();
            }
        });

        function refresh() {
            updataButtonSync();
            $('#defaultTable').bootstrapTable('refresh');

        }
        /*  function formatIDFn(value, row){
         var id_card="//"+row.id_card;
         return id_card;
         }

         function formatTelFn(value, row){
         var tel="'"+row.tel;
         return tel;
         }*/
        function formatIDTypeFn(value, row) {
            if (row.id_type ==5) return "<span style='color:darkgray'>回乡证<span>";
            if (row.id_type ==4) return "<span style='color:darkgray'>台胞证<span>";
            if (row.id_type == 3) return "<span style='color:darkgray'>护照<span>";
            if (row.id_type == 0) return "<span style='color:darkgray'>身份证<span>";

            return row.id_type;
        }

        function formatCareerFn(value, row) {
            <%--${resultSet.career eq '1' ? '内勤人员' : resultSet.career eq '2' ? '保安人员' : resultSet.career eq '3' ? '武装押运人员' : '-'}--%>
            if (row.career == "1") return "内勤人员";
            if (row.career == "2") return "保安人员";
            if (row.career == "3") return "武装押运人员";
            if (row.career == "4") return "保洁人员";
            else return "其他";

            return "";
        }
        function formatSexFn(value, row) {

            if (row.sex == 1) return "男";
            if (row.sex == 2) return "女";
            else return "其他";

            return "";
        }
        function loadCanvas(_imgPath){
            if(_imgPath==""||_imgPath==null){
                layer.msg("没有找到图片或文件地址，请核实或者上传");
            }else{
                if(!checkImgExists(_imgPath)){
                    var path = '${ctx_defaul}'+_imgPath;
                    window.open(path);
                }else{
                    layer.open({
                        type: 1,
                        title: "处理单",
                        closeBtn: 1,
                        area: '516px',
                        skin: 'layui-layer-black',//没有背景色
                        shadeClose: true,
                        content: "<img src='${ctx_defaul}"+_imgPath+"' width='100%'/>"
                        ,yes: function(index, layero) {

                            $("#upload_file").trigger('click');
                            layer.closeAll();
                        }
                    });
                }
            }
        }

        function checkImgExists(imgurl) {
            //判断是否是图片 - strFilter必须是小写列举
            var strFilter=".jpeg|.gif|.jpg|.png|.bmp|.pic|"
            if(imgurl.indexOf(".")>-1){
                var p = imgurl.lastIndexOf(".");
                var strPostfix=imgurl.substring(p,imgurl.length) + '|';
                strPostfix = strPostfix.toLowerCase();
                if(strFilter.indexOf(strPostfix)>-1){
                    return true;
                }
            }
            return false;
        }

        function uploadFileDetail(_form){
            var formData = new FormData(document.forms.namedItem(_form));

//            if (!"".equals(formData)){
            $.ajax({
                type: 'POST',
                url:'${ctxapi}/myApply/uploadFile/${preservationRecordVo.oid}/1',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(result) {
                    if(result.success) {
                        $("#showPicture").attr('onClick','loadCanvas(\''+result.msg+'\')');
                        $("#preserverAddress").val(result.msg);
                        layer.msg("上传成功", {time:1000 });
                    }else {
                        layer.msg(result.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                },

            });
//            }

        }
        /*提交按钮-同步操作*/
        function updataButtonSync(){
            /*   layer.confirm('确认将未成功同步到支撑的订单重新同步操作吗？',{btn: ['确定','取消'] //按钮*/
            g_ajax('${ctxapi}/myApply/perserverUpdataButton/${preservationRecordVo.oid}',{}, function(result){

                if(result){
                    $("#checkSucccess").hide();
                    $("#checkFail").show();
                }else{
                    $("#checkSucccess").show();
                    $("#checkFail").hide();
                }
            });

        }
        function checkReturn(){
            parent.closeLayerOpen();
        }
        function checkSucccess(){
            var total_premium=$("#preserverCost").val();
            var inception_date=$("#preserverTime").val();
            var revise_serial_num_ins=$("#reviseSerialNumIns").val();
            var revise_path=$("#preserverAddress").val();
            g_ajax('${ctxapi}/myApply/updataReviseStatus',{record_id:'${preservationRecordVo.oid}',revise_path:revise_path ,sup_id:'${sup_id}',total_premium: total_premium,revise_status:'4',inception_date:inception_date,revise_serial_num_ins:revise_serial_num_ins}, function(result){

                if(result.success){
                    $("#checkSucccess").hide();
                    layer.msg('完成审核中', {
                        icon: 16
                        ,shade: 0.01,
                        time:500000
                    });


                    g_ajax('${ctxapi}/myApply/saveResultSet/${preservationRecordVo.oid}/${preservationRecordVo.revise_type}',{}, function(result){

                        if(result.success){
                            parent.refresh();
                            parent.closeLayerOpen();

                        }else{
                            layer.msg(result.msg);
                        }
                    });

                }else{
                    layer.msg(result.msg);
                }
            });
        }
        function checkFail(){

            g_ajax('${ctxapi}/myApply/updataReviseStatus',{record_id:'${preservationRecordVo.oid}',revise_path: '',sup_id:'${sup_id}',total_premium: '',revise_status:'3'}, function(result){

                if(result.success){
                    $("#checkFail").hide();
                    parent.refresh();
                    parent.closeLayerOpen();
                }else{

                }
            });
        }


        function formatOperationFn(value, row) {
            var str = "";
            var apprSign=${apprSign};
            if(apprSign==1){
                return str;
            }
            var resvise_status=${preservationRecordVo.revise_status};
            if(resvise_status!=2){
                /*已审核的不能修改*/
                str += '<a class="like m-l-sm text-info" href="javascript:void(0)"  title="不能修改" > <i class="" >- -</i></a>';

            }else {
                if (row.status == 1) {


                    var onClick2 = "member_add('0','" + row.ins_preservation_detail_id + "');";
                    str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="' + onClick2 + '" title="通过" > <i class="like m-l-sm text-info" >取消</i></a>';

                } else if (row.status == 0) {

                    var onClick2 = "member_remove('1','" + row.ins_preservation_detail_id + "');";
                    str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="' + onClick2 + '" title="未通过" > <i class="like m-l-sm text-info">未通过</i></a>';

                }
            }
            return str;
        }

        /*审核不通过+理由*/
        function  member_remove(status, id){
            $("#status").val(status);
            $("#detail_id").val(id);
            layer.prompt({title: '审核不通过的理由', formType: 2  ,maxlength: 50}, function(text, index){
                $("#remark").val(text);
                layer.close(index);
                var index0 = layer.load(0, {shade: false});
                $('#declinature').ajaxSubmit(function(result) {
                    if (result.success == true) {
                        window.parent.layer.msg(result.msg, {
                            shade : 0.3,
                            time : 1000
                        }, function() {
                            updataButtonSync();
                            $('#defaultTable').bootstrapTable('refresh');//刷新成员表格
                        });
                    } else {
                        window.parent.layer.msg(result.msg, {
                            icon : 2,
                            time : 1000
                        });
                    }

                    return false;
                });
            });
        }

        /*审核通过*/
        function member_add(status, id) {
            $("#status").val(status);
            $("#detail_id").val(id);
            $("#remark").val();
            layer.confirm('取消后该被保险人变更为通过，是否取消该被保险人的“未通过”状态？',{btn: ['确定','取消'] }, function () {
                $('#declinature').ajaxSubmit(function(result) {
                    if (result.success == true) {
                        window.parent.layer.msg("取消成功", {
                            shade : 0.3,
                            time : 1000
                        }, function() {
                            updataButtonSync();
                            $('#defaultTable').bootstrapTable('refresh');//刷新成员表格

                        });
                    } else {
                        window.parent.layer.msg(result.msg, {
                            icon : 2,
                            time : 1000
                        });
                    }

                    return false;
                });
                layer.closeAll();
            });


        }

        function comm_back(json) {
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            console.log("参数是：" + params)
            var obj = g_sobj($("#queryForm").form());
            for (var i in obj) {
                if (obj[i] == "") eval("delete obj." + i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
