package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.*;
import com.bcxin.ins.core.service.*;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.spring.util.UploadFileUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.util.toolbox.WebUtil;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 类名称：SysUserController   
* 类描述：系统管理员控制器   
* 创建人:liujinju
* @version
 */
@Controller
@RequestMapping("${systemPath}/sysuser")
public class SysUserController extends BaseController {

	/** 系统管理员列表 */
	private static final String SYSTEM_USER_LIST = getViewPath("admin/system/system_user_list");
	/** 用户个人资料 */
	private static final String SYSTEM_USER_MESSAGE = getViewPath("admin/system/system_user_message");
	/** 用户登录日志 */
	private static final String USER_LOGIN_LOG = getViewPath("admin/system/system_user_login_log");
	/** 管理员分类查看 */
	private static final String SYSTEM_USER_ROLE = getViewPath("admin/system/system_user_role");
	/** 创建或者修改用户界面 */
	private static final String SYSTEM_USER_ADDUSER = getViewPath("admin/system/system_user_add");
	/** 系统管理员信息界面 */
	private static final String SYSTEM_USER_INFO = getViewPath("admin/system/system_user_info");
	/** 系统管理员头像界面 */
	private static final String SYSTEM_USER_AVATAR = getViewPath("admin/system/system_user_avatar");

	@Autowired
	private SysUserService sysUserService;
	@Autowired
	private MySysUserService mySysUserService;
	@Autowired
	private SysUserLoginLogService sysUserLoginLogService;
	@Autowired
	private SysRoleService sysRoleService;
	@Autowired
	private SysUserRoleService sysUserRoleService;
	@Autowired
	private SystemService systemService;


/*	@InitBinder("systemUser")
	public void initBinderSystemUser(WebDataBinder binder) {
		binder.setFieldDefaultPrefix("systemUser.");
	}

	@InitBinder("queryUser")
	public void initQueryUser(WebDataBinder dinder) {
		dinder.setFieldDefaultPrefix("queryUser.");
	}
*/	
	/**
	 * 用户列表
	 * @param request
	 * @return
	 */
	@RequiresPermissions("sysuser:list:view")
	@RequestMapping(value = "/list")
	public String list(Model model, @ModelAttribute("queryUser") QueryUser queryUser, HttpServletRequest request, Map<String,Object> params) {
		//int sysUserNumber = sysUserService.selectAllSysUserNumber();
		//model.addAttribute("sysUserNumber", sysUserNumber);// 用户总数量
		//List<SysUser> sysUsers = sysUserService.selectAllSysUser(queryUser);
		//model.addAttribute("sysUsers", sysUsers);// 用户列表
		//List<SysRole> sysRoles = sysRoleService.selectRoleAndNumber();
		//model.addAttribute("sysRoles", sysRoles);// 权限列表

		return SYSTEM_USER_LIST;
	}
	
	/**
	 * GET 个人资料
	 * @param
	 * @return
	 */
	@RequiresPermissions("sysuser:list:view")
	@RequestMapping(value = "/list/{userId}/detail")
	public String detail(Model model, @PathVariable Long userId){
		SysUser user = sysUserService.selectById(userId);
		model.addAttribute("user", user);//用户信息
		List<SysUserRole> sysUserRoles = sysUserRoleService.selectRoleListByAccountId(userId);
		StringBuffer userRole = new StringBuffer();
		for(SysUserRole sysUserRole : sysUserRoles){
			userRole.append(sysUserRole.getRoleName());
			userRole.append("&nbsp");
		}
		model.addAttribute("userRole",userRole);//用户权限
		return SYSTEM_USER_MESSAGE;
	}
	
	/**
	 * Get 用户登录日志
	 * @param accountId
	 * @return
	 */
	@RequiresPermissions("sysuser:list:view")
	@RequestMapping(value = "/list/{accountId}/log")
	public String userLog(Model model, @PathVariable Long accountId){
		List<SysUserLoginLog> sysUserLoginLogList = sysUserLoginLogService.selectUserLoginLog(accountId);
		model.addAttribute("userLoginLogList", sysUserLoginLogList);
		return USER_LOGIN_LOG;
	}



	/**
	 * POST 新增用户
	 * @param
	 * @return
	 */
	//@RequiresPermissions("sysuser:list:user:add")
	@RequestMapping(value = "/list/user/add")
	@ResponseBody
	public AjaxResult userAdd(MySysUser sysUser , HttpServletRequest req, HttpServletResponse resp) {
		if(!mySysUserService.insert(sysUser)) {
			return new AjaxResult(false,"保存失败");
		}
		return new AjaxResult(true,"保存成功");
	}

	/**
	 * POST 启用/禁止用户
	 * @param
	 * @return
	 */
	@RequiresPermissions("sysuser:list:edit")
	@RequestMapping(value = "/list/audit", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult audit() {
		Long accountId = Long.parseLong(getParameter("accountId"));
		Integer status = Integer.valueOf(getParameter("status"));
		sysUserService.updateUserStatus(accountId, status);
		return success(true);
	}
	
	/**
	 * DELETE 删除用户
	 * @return
	 */
	@RequiresPermissions("sysuser:list:delete")
	@RequestMapping(value = "/list/{accountId}/delete", method = RequestMethod.DELETE)
	@ResponseBody
	public AjaxResult delete(@PathVariable Long accountId) {
		sysUserService.deleteSysUser(accountId);
		return success(true);
	}
	
	/**
	 * GET 角色分类下管理员列表
	 * @param roleId
	 * @return
	 */
	@RequiresPermissions("sysuser:list:view")
	@RequestMapping(value = "/list/{roleId}/role", method = RequestMethod.GET)
	public String listrole(Model model, @PathVariable Long roleId) {
		List<SysUser> sysUsers = sysUserService.selectSysUserByRoleId(roleId);
		model.addAttribute("sysUsers", sysUsers);
		return SYSTEM_USER_ROLE;
	}
	
	/**
	 * 修改用户页面
	 * @return
	 */
	@RequiresPermissions("sysuser:list:edit")
	@RequestMapping(value = "/list/{accountId}/edit")
	public String edit(Model model, @PathVariable Long accountId){
		Map<String,Object> m = sysUserService.selectByUserID(accountId);
		//SysUser sysUser = sysUserService.selectById(accountId);
		model.addAttribute("sysUser", m);//
		List<SysRole> sysRoles = sysRoleService.selectRoleList();
		model.addAttribute("sysRoles", sysRoles);//所有角色
		List<SysUserRole> sysRoleList = sysUserRoleService.selectRoleListByAccountId(accountId);
		model.addAttribute("sysRoleList", sysRoleList);//分配角色
		//修改bug，添加一个字段用于页面判断是否展示权限列表
		model.addAttribute("showPower","showPower");
		model.addAttribute("mark","edit");
		return SYSTEM_USER_ADDUSER;
	}
	
	/**
	 * GET 创建用户页面
	 * @return
	 */
	@RequiresPermissions("sysuser:list:add")
	@RequestMapping(value = "/list/add")
	public String add(Model model) {
		String companyId = this.getParameter("companyId");
		List<SysRole> sysRoles = sysRoleService.selectRoleList();
		model.addAttribute("sysRoles", sysRoles);
		if(StrUtil.isNotBlank(companyId)) {
			model.addAttribute("sysUser",  new SysUser(new SysCompany(Long.parseLong(companyId))));
		}else {
			model.addAttribute("sysUser",  new SysUser(new SysCompany(0L)));
		}
		//添加一个标识，用于页面判断是否展示权限列表
		model.addAttribute("showPower","showPower");
		model.addAttribute("mark","add");
		return SYSTEM_USER_ADDUSER;
	}


	/**
	 * POST 创建或修改用户
	 * @return
	 */
	@RequiresPermissions({"sysuser:list:add","sysuser:list:edit"})
	@RequestMapping(value = "/list/save", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult update(@ModelAttribute("sysUser") SysUser sysUser){
		String[] roleIds = getParameterValues("roleId");
		if(!WebUtil.isEmail(sysUser.getEmail())){
			return fail(false, "请输入正确的电子邮箱");
		}
		if(!WebUtil.isTelephone(sysUser.getTelephone())){
			return fail(false, "请输入正确的手机号码");
		}
		if(sysUser.getId() == null){
			return insertUserByIdIsNull(sysUser, roleIds);
		}else{
			return updateUserByIdIsNotNull(sysUser, roleIds);

		}
	}

	/**
	 * <b> 用户Id不为空时修改用户信息 </b>
	 * @author ZXF
	 * @create 2020/09/14 0014 17:07
	 * @version
	 * @注意事项 </b>
	 */
	private AjaxResult updateUserByIdIsNotNull(@ModelAttribute("sysUser") SysUser sysUser, String[] roleIds) {
		//修改时对邮箱的控制 -- liumd
		String newEmail = sysUser.getEmail();
		if(StringUtils.isNotBlank(newEmail)&&checkEmailIsSet(sysUser, newEmail)){
			return fail(false, "该邮箱已被使用");
		}
		//更新用户及角色记录
		sysUserService.updateUserInfoBySystem(sysUser, roleIds);
		return success(true, "用户信息修改成功!");
	}

	/**
	 * <b> 校验有效是否被使用 </b>
	 * @author ZXF
	 * @create 2020/09/14 0014 17:15
	 * @version
	 * @注意事项 </b>
	 */
	private boolean checkEmailIsSet(SysUser sysUser, String newEmail) {
		Map<String, Object> map = Maps.newHashMap();
		map.put("id", sysUser.getId());
		List<SysUser> li = sysUserService.selectByMap(map);
		if(li == null || li.size() != 1){
			return false;
		}
		String oldEmail = li.get(0).getEmail();
		if(oldEmail==null||oldEmail.equals(newEmail)){
			return false;
		}
		Map<String, Object> map2 = Maps.newHashMap();
		map2.put("email", newEmail);
		List<SysUser> li2 = sysUserService.selectByMap(map2);
		if(li2 != null && li2.size() > 0){
			return true;
		}
		return false;
	}

	/**
	 * <b> 用户id不存在时创建 </b>
	 * @author ZXF
	 * @create 2020/09/14 0014 17:06
	 * @version
	 * @注意事项 </b>
	 */
	private AjaxResult insertUserByIdIsNull(@ModelAttribute("sysUser") SysUser sysUser, String[] roleIds) {
		if(sysUserService.checkLoginName(sysUser.getLoginName())){
            return fail(false, "该用户名已被使用");
        }
		//新增时对邮箱的控制 -- liumd
		if(StringUtils.isNotBlank(sysUser.getEmail())){
            Map<String, Object> map = Maps.newHashMap();
            map.put("email", sysUser.getEmail());
            List<SysUser> li = sysUserService.selectByMap(map);
            if(li != null && li.size() > 0){
                return fail(false, "该邮箱已被使用");
            }
        }
		//创建用户及插入角色记录
		sysUserService.insertSysUser(sysUser, roleIds);
		return success(true, "用户创建成功!");
	}

	/**
	 * GET 管理员个人信息界面
	 * @param
	 * @return
	 */
	@RequiresPermissions("user")
	@RequestMapping(value = "/info", method = RequestMethod.GET)
	public String view(Model model) {
		SysUser sysUser = SysUserUtils.getUser();
		if (sysUser != null) {
			model.addAttribute("sysUser", sysUser);// 用户信息

			List<SysUserLoginLog> sysUserLoginLogList = sysUserLoginLogService.selectUserLoginLog(sysUser.getId());
			model.addAttribute("sysUserLoginLogList", sysUserLoginLogList);// 用户日志

			List<SysUserRole> sysUserRoles = sysUserRoleService.selectRoleListByAccountId(sysUser.getId());
			StringBuffer userRole = new StringBuffer();
			for (SysUserRole sysUserRole : sysUserRoles) {
				userRole.append(sysUserRole.getRoleName());
				userRole.append("&nbsp");
			}
			model.addAttribute("userRole", userRole);// 用户权限
		}
		return SYSTEM_USER_INFO;
	}
	
	
	/**
	 * POST 更新管理员信息
	 * @param
	 * @return
	 */
	@RequiresPermissions("user")
	@RequestMapping(value = "/info/edit")
	@ResponseBody
	public AjaxResult edit(@ModelAttribute("sysUser") SysUser sysUser){
		if (sysUser != null) {
			sysUserService.updateUserInfo(sysUser);
			return success(true,"修改成功");
		}else{
			return fail(false, "系统错误");
		}
	}
	
	/**
	 * 修改密码
	 * @param request
	 * @param
	 * @return
	 */
	@RequiresPermissions("user")
	@RequestMapping(value = "/info/edit/psw", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult editPwd(HttpServletRequest request){
		SysUser sysUser = SysUserUtils.getUser();
		if (sysUser != null) {
			// 原密码
			String nowPassword = request.getParameter("nowPassword") == null ? ""
					: request.getParameter("nowPassword");
			// 新密码
			String newPassword = request.getParameter("newPassword") == null ? ""
					: request.getParameter("newPassword");
			// 确认密码
			String confirmPwd = request.getParameter("confirmPwd") == null ? ""
					: request.getParameter("confirmPwd");
			if(!systemService.validatePassword(nowPassword,sysUser.getLoginPassword())){
				return fail(false, "原密码不正确!");
			}
			if(!WebUtil.isPassword(newPassword)){
				return fail(false, "密码长度8~16位，其中数字，字母和符号至少包含两种!");
			}
			if(!newPassword.equals(confirmPwd)){
				return fail(false, "两次输入的新密码不一致!");
			}
			sysUserService.updateUserPws(sysUser.getId(), newPassword);
			return success(true, "修改成功!");
		}else{
			return fail(false, "您未登录或者登录已超时,请先登录!");
		}
	}
	/**
	 * 重置密码
	 * @param accountId
	 * @return
	 */
	@RequiresPermissions("sysuser:list:repwd")
	@RequestMapping(value = "/list/{accountId}/repwd")
	@ResponseBody
	public AjaxResult rePwd(@PathVariable Long accountId) {
		if (accountId != null) {
			sysUserService.updateUserPws(accountId, GlobalConstants.getConfig("defaultPassWord"));
			return success(true, "密码重置成功!");
		}else{
			return fail(false, "修改失败");
		}
	}
	
	/**
	 * 设置头像页面
	 */
	@RequestMapping(value = "/upload", method = RequestMethod.GET)
	public String setAvatar() {
		return SYSTEM_USER_AVATAR;
	}
    @RequestMapping(value = "/upload",method = RequestMethod.POST, produces="application/json;charset=utf-8")  
	@ResponseBody
	public Map<String, Object> uploadHeadPortrait(MultipartFile avatar_file,String avatar_src,String avatar_data, HttpServletRequest request){
		Map<String, Object> json = new HashMap<String, Object>();
		if (avatar_file.isEmpty()) {
			json = this.setJson(false, "不支持的文件类型，仅支持图片!", null);
			return  json;
		}
		try{
			//判断文件的MIMEtype
			String type = avatar_file.getContentType();
			if(type == null || !type.toLowerCase().startsWith("image/")){
				json = this.setJson(false, "不支持的文件类型，仅支持图片!", null);
				return  json;
			}
			//头像存放文件
			String dir = "icon";
			Map<String, Object> returnMap = UploadFileUtils.Upload(request,avatar_file,avatar_data,dir);
			//返回的布尔型参数的值为true，如果字符串参数不为null，是相等的，忽略大小写字符串“true”。
			if (Boolean.parseBoolean(returnMap.get("flag").toString()) == true) {
				SysUser sysUser = SysUserUtils.getUser();
				if (sysUser == null) {
					return this.setJson(false, "上传失败!你没有登录，请重新登录");
				}
				sysUser.setPicImg(returnMap.get("savaPath").toString());
				sysUserService.insertOrUpdate(sysUser);
				json = this.setJson(true, "上传成功!", returnMap.get("savaPath").toString());
				return json;
			}
		}catch(Exception e){
			logger.error("ImageUploadController.uploadHeadPortrait", e);
			json = this.setJson(false, "上传失败，出现异常："+e.getMessage(), null);
			return json;
		}
    	json = this.setJson(false, "不支持的文件类型，仅支持图片!", null);
    	return  json;
	}

}