package com.bcxin.ins.models.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysMenu;
import com.bcxin.ins.core.service.SysMenuService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
* 类名称：SysRoleController   
* 类描述：菜单控制器  
* 创建人：liujinju
* @version
 */
@Controller
@RequestMapping("${systemPath}/sysmenu")
public class SysMenuController extends BaseController {

	/** 系统菜单列表 */
	private static final String SYSTEM_MENU_LIST = getViewPath("/admin/system/system_menu_list");
	private static final String SYSTEM_MENU_ADD = getViewPath("/admin/system/system_menu_add");
	@Autowired
	private SysMenuService sysMenuService;
	
	/**
	 * 进入菜单管理页面
	 */
	@RequiresPermissions("sysuser:menu:view")
	@RequestMapping("/list")
	public String showMenuList(Model model){
		//查询所有的菜单
		List<SysMenu> menuList = sysMenuService.findList();
		model.addAttribute("menuList", menuList);
		return SYSTEM_MENU_LIST;
	}
	
	/**
	* @Description: 添加菜单 
	* @param model
	* @return
	* @throws 
	*/
	@RequiresPermissions("sysuser:menu:add")
	@RequestMapping(value = "/list/add", method = RequestMethod.GET)
	public String add(Model model) {
		List<SysMenu> menuList = sysMenuService.selectSysMenu();//查询所有的菜单
		model.addAttribute("menuList", menuList);//所有菜单
		return SYSTEM_MENU_ADD;
	}
	
	/**
	* @Description: 编辑菜单 
	* @param model
	* @param
	* @return
	* @throws 
	*/
	@RequiresPermissions("sysuser:menu:edit")
	@RequestMapping(value = "/list/{menuId}/edit")
	public String edit(Model model, @PathVariable Long menuId){
		SysMenu sysMenu = sysMenuService.selectById(menuId);
		model.addAttribute("sysMenu", sysMenu);//菜单信息
		List<SysMenu> menuList = sysMenuService.selectSysMenu();//查询所有的菜单
		model.addAttribute("menuList", menuList);//所有菜单
		return SYSTEM_MENU_ADD;
	}
	
	/**
	 * 创建或修改菜单
	 * @param sysMenu
	 * @return
	 */
	@RequiresPermissions({"sysuser:menu:add","sysuser:menu:edit"})
	@RequestMapping(value = "/list/save", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult update(SysMenu sysMenu){
		if(sysMenu.getId() == null){
			Map<String,Object> columnMap = new HashMap<String,Object>();
			columnMap.put("MENU_NAME", sysMenu.getMenuName());
			columnMap.put("PARENT_ID", sysMenu.getParent().getId());
			List<SysMenu> list =sysMenuService.selectByMap(columnMap);
			if(list.size()>0){
				return fail(false, "该菜单名已被使用");
			}
		}
		sysMenuService.save(sysMenu);//插入菜单
		return success(true, "操作成功!");
	}
	
	/**
	 * 删除菜单功能
	 */
	@RequiresPermissions("sysuser:menu:delete")
	@RequestMapping("/list/{id}/delete")
	@ResponseBody
	public AjaxResult deleteFunction(@PathVariable("id") Long id){
		sysMenuService.deleteById(id);
		return this.success(true, "删除成功");
	}
	/**
	 * POST 启用/禁止
	 * @param request
	 * @return
	 */
	@RequiresPermissions("sysuser:menu:edit")
	@RequestMapping(value = "/list/audit", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult audit() {
		Long menuId = Long.parseLong(getParameter("menuId"));
		Integer status = Integer.valueOf(getParameter("status"));
		SysMenu sysMenu = new SysMenu();
		sysMenu.setId(menuId);
		sysMenu.setStatus(status);
		sysMenuService.updateById(sysMenu);
		return success(true);
	}
}
