package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.util.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.OutputStream;


/**
 * 图片处理
 * @author playboy
 *
 */
@Controller
@RequestMapping("${systemPath}/img")
public class SysImgController extends BaseController {
	
	@Value("${user.file}")
	private String userFile;
	
	
	/**
	 * 图片展示
	 * @param fileName
	 */
	@RequestMapping("/getImg")
	public void getImg(String fileName,HttpServletRequest request,HttpServletResponse response){
		 try {
		        byte data[] = FileUtils.getFileContent(userFile+File.separator+fileName);
		        response.setContentType("image/jpg"); //设置返回的文件类型
		        OutputStream os = response.getOutputStream();      
		        os.write(data);      
		        os.flush();  
		        os.close();  
		   } catch (Exception e) {
		        e.printStackTrace();
		   }
	}
}
