package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.product_core.ProPrimaryRuleXWCK;
import com.bcxin.ins.models.pro.service.MyProService;
import com.bcxin.ins.models.pro.service.ProExpCustomsCompaniesService;
import com.bcxin.ins.models.pro.service.ProPrimaryRuleXWCKService;
import com.bcxin.ins.models.pro.service.ProResponsibilityService;
import com.bcxin.ins.util.ConstProp;
import com.bcxin.ins.util.RegionUtils;
import com.google.common.collect.Maps;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 产品
 * @version
 */
@Controller
@RequestMapping("${systemPath}/mypro")
public class ProController extends BaseController {

	/**产品列表*/
	private static final String PRO_LIST = getViewPath("admin/pro/pro_list");
	/**产品分类列表*/
	private static final String PRO_CATEGORY_LIST = getViewPath("admin/pro/pro_category_list");
	/**产品保障责任列表*/
	private static final String PRO_SR_LIST = getViewPath("admin/pro/pro_security_responsibility_list");
	/**详情、新增、修改产品保障责任页面*/
	private static final String PRO_SR_ADD = getViewPath("admin/pro/pro_security_responsibility_add");
	/**小微企业信用险的区域规则配置列表*/
	private static final String PRO_RXWCK_LIST = getViewPath("admin/pro/pro_security_rule_xwck_list");
	/**详情、新增、修改小微企业信用险的区域规则配置页面*/
	private static final String PRO_RXWCK_ADD = getViewPath("admin/pro/pro_security_rule_xwck_add");
	/**出口300万美元以下企业名单列表*/
	private static final String PRO_ECC_LIST = getViewPath("admin/pro/pro_exp_customs_companies_list");
	/**详情、新增、修改出口300万美元以下企业名单页面*/
	private static final String PRO_ECC_ADD = getViewPath("admin/pro/pro_exp_customs_companies_add");
	/**产品公共详情*/
	private static final String PRO_DETAIL_PUBLIC = getViewPath("admin/pro/pro_detail_public");
	/**信用险详情*/
	private static final String PRO_DETAIL_CREDIT = getViewPath("admin/pro/pro_detail_credit");
	/**责任险详情*/
	private static final String PRO_DETAIL_RESPONSIBILITY = getViewPath("admin/pro/pro_detail_responsibility");
	/**保证险详情*/
	private static final String PRO_DETAIL_ENSURE = getViewPath("admin/pro/pro_detail_ensure");
	/**人身险详情*/
	private static final String PRO_DETAIL_PERSON = getViewPath("admin/pro/pro_detail_person");

	/** 没有service的control会时效！！！*/
	@Autowired
	private MyProService proS;
	@Autowired
	private ProResponsibilityService proRS;
	@Autowired
	private ProPrimaryRuleXWCKService proRXWCK;
	@Autowired
	private ProExpCustomsCompaniesService proECC;

	/**产品详情*/
	//@RequiresPermissions("mysysuser:win/list)
	@RequestMapping(value = "/win/detail/pro")
	public String winDetailPro(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return redirectTo("/api/mypro/win/dml");
	}

	/**产品列表*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return PRO_LIST;
	}

	/**产品保障责任列表*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/sr/list")
	public String winSRList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("p",params);
		return PRO_SR_LIST;
	}

	/**详情、新增、修改产品保障责任页面*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/sr/add")
	public String winSRAdd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("mark","add");
		model.addAttribute("p",params);
		return PRO_SR_ADD;
	}
	/**详情、新增、修改产品保障责任页面*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/sr/upd")
	public String winSRUpd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		Map<String,Object> m = Maps.newHashMap();
		m.put("pro_responsibility_id",params.get("pro_responsibility_id"));
		model.addAttribute("mark","upd");
		model.addAttribute("p",params);
		model.addAttribute("row",proRS.selectByMap(m).get(0));
		return PRO_SR_ADD;
	}

	/**出口300万美元以下企业名单列表*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/ecc/list")
	public String winECCList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("p",params);
		return PRO_ECC_LIST;
	}

	/**详情、新增、修改产品出口300万美元以下企业名单页面*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/ecc/add")
	public String winECCAdd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("mark","add");
		model.addAttribute("p",params);
		return PRO_ECC_ADD;
	}
	/**详情、新增、修改产品出口300万美元以下企业名单页面*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/ecc/upd")
	public String winECCUpd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		Map<String,Object> m = Maps.newHashMap();
		m.put("pro_exp_customs_companies_id",params.get("pro_exp_customs_companies_id"));
		model.addAttribute("mark","upd");
		model.addAttribute("p",params);
		model.addAttribute("row",proECC.selectByMap(m).get(0));
		return PRO_ECC_ADD;
	}

	/**小微企业信用险的区域规则配置列表*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/rXWCK/list")
	public String winRXWCKList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("p",params);
		return PRO_RXWCK_LIST;
	}

	/**详情、新增、修改小微企业信用险的区域规则配置页面*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/rXWCK/add")
	public String winRXWCKAdd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("mark","add");
		model.addAttribute("p",params);
		model.addAttribute("provinceList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE,ConstProp.BLANK_CHAR));
		return PRO_RXWCK_ADD;
	}
	/**详情、新增、修改小微企业信用险的区域规则配置页面*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/rXWCK/upd")
	public String winRXWCKUpd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		Map<String,Object> m = Maps.newHashMap();
		m.put("pro_primary_rule_xwck_id",params.get("pro_primary_rule_xwck_id"));
		model.addAttribute("mark","upd");
		model.addAttribute("p",params);
		ProPrimaryRuleXWCK row = proRXWCK.selectByMap(m).get(0);
		model.addAttribute("row",row);
		model.addAttribute("provinceList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE,ConstProp.BLANK_CHAR));
		model.addAttribute("bankCityList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO,row.getProvince_code()));

		return PRO_RXWCK_ADD;
	}

	@RequestMapping("/win/findCity")
	@ResponseBody
	public List<ComRegion> findDistrictByParentCode(String codeLevel, String parentCode) {
		List<ComRegion> list = RegionUtils.findDistrictByParentCode(codeLevel, parentCode);
		return list;
	}

	/**产品分类*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/category/list")
	public String winCategoryList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return PRO_CATEGORY_LIST;
	}

	/**产品列表分页*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		PageResult pr = proS.query(params);
		CTLUtil.out(pr,resp); return null;
	}

	/**保障责任新增*/
	@RequiresPermissions("mypro:sr:add")
	@RequestMapping(value = "/sr/add" , method = RequestMethod.POST)
	public @ResponseBody Object srAdd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.srAdd(p);
	}
	/**保障责任修改*/
	@RequiresPermissions("mypro:sr:upd")
	@RequestMapping(value = "/sr/upd" , method = RequestMethod.POST)
	public @ResponseBody Object srUpd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.srUpd(p);
	}

	/**保障责任删除*/
	@RequiresPermissions("mypro:sr:del")
	@RequestMapping(value = "/sr/del" , method = RequestMethod.POST)
	public @ResponseBody Object srDel(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.srDel(p);
	}

	/**产品保障责任列表分页*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/querySR" , method = RequestMethod.POST)
	public @ResponseBody Object querySR(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(proS.querySR(params),resp); return null;
	}

	/**出口300万美元以下企业名单批量新增*/
	@RequiresPermissions("mypro:ecc:add")
	@RequestMapping(value = "/ecc/file" , method = RequestMethod.POST)
	public @ResponseBody Object eccFile(@RequestParam(value = "excelFile") MultipartFile mFile , HttpServletRequest req, HttpServletResponse resp) {
//		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.eCCFile(mFile);
	}
	/**出口300万美元以下企业名单新增*/
	@RequiresPermissions("mypro:ecc:add")
	@RequestMapping(value = "/ecc/add" , method = RequestMethod.POST)
	public @ResponseBody Object eccAdd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.eCCAdd(p);
	}
	/**出口300万美元以下企业名单修改*/
	@RequiresPermissions("mypro:ecc:upd")
	@RequestMapping(value = "/ecc/upd" , method = RequestMethod.POST)
	public @ResponseBody Object eccUpd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.eCCUpd(p);
	}

	/**出口300万美元以下企业名单删除*/
	@RequiresPermissions("mypro:ecc:del")
	@RequestMapping(value = "/ecc/del" , method = RequestMethod.POST)
	public @ResponseBody Object eccDel(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.eCCDel(p);
	}

	/**出口300万美元以下企业名单清空数据*/
	@RequiresPermissions("mypro:ecc:batch_del")
	@RequestMapping(value = "/ecc/batch_del" , method = RequestMethod.POST)
	public @ResponseBody Object eccBatchDel(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.eCCBatchDel(p);
	}

	/**出口300万美元以下企业名单列表分页*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/queryECC" , method = RequestMethod.POST)
	public @ResponseBody Object queryECC(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(proS.queryECC(params),resp); return null;
	}

	/**小微企业信用险的区域规则配置新增*/
	@RequiresPermissions("mypro:rXWCK:add")
	@RequestMapping(value = "/rXWCK/add" , method = RequestMethod.POST)
	public @ResponseBody Object rXWCKAdd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.rXWCKAdd(p);
	}
	/**小微企业信用险的区域规则配置修改*/
	@RequiresPermissions("mypro:rXWCK:upd")
	@RequestMapping(value = "/rXWCK/upd" , method = RequestMethod.POST)
	public @ResponseBody Object rXWCKUpd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.rXWCKUpd(p);
	}

	/**小微企业信用险的区域规则配置删除*/
	@RequiresPermissions("mypro:rXWCK:del")
	@RequestMapping(value = "/rXWCK/del" , method = RequestMethod.POST)
	public @ResponseBody Object rXWCKDel(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.rXWCKDel(p);
	}

	/**小微企业信用险的区域规则配置列表分页*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/queryRXWCK" , method = RequestMethod.POST)
	public @ResponseBody Object queryRXWCK(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(proS.queryRXWCK(params),resp); return null;
	}

	/**产品分类分页*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/queryCategory" , method = RequestMethod.POST)
	public @ResponseBody Object queryCategory(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(proS.queryCategory(params),resp); return null;
	}

	/** 产品信息手动同步*/
	@RequiresPermissions("mypro:pro:sync")
	@RequestMapping(value = "/pro/sync")
	public @ResponseBody Object proSync(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.proSync(p);
	}

	/** 产品分类手动同步*/
	@RequiresPermissions("mypro:category:sync")
	@RequestMapping(value = "/catetory/sync")
	public @ResponseBody Object categorySync(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return proS.categorySync(p);
	}

	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/pro/addSource", method = RequestMethod.POST)
	@ResponseBody
	public R addSource(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
		Map<Object, Object> p = CTLUtil.init(request, params);
		return proS.addSource(p,request);
	}

}