package com.bcxin.ins.models.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.*;
import com.bcxin.ins.core.util.CTLUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 保险公司
 * @version
 */
@Controller
@RequestMapping("${systemPath}/myinscompany")
public class MySysInsCompanyController extends BaseController {

	/** 列表 */
	private static final String LIST = getViewPath("admin/inscompany/inscompany_list");
	/**  企业用户新增和修改 */
	private static final String DETAIL = getViewPath("admin/inscompany/inscompany_detail");

	@Autowired
	private MySysInsCompanyService insS;

	/**列表*/
	@RequiresPermissions("myinscompany:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return LIST;
	}

	/**详情*/
	@RequiresPermissions("myinscompany:win:list")
	@RequestMapping(value = "/win/detail")
	public String winPersonUpd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		model.addAttribute("row",insS.selectDetailByID(params));
		return DETAIL;
	}

	/**分页查询保险公司*/
	@RequiresPermissions("myinscompany:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(insS.query(params),resp); return null;
	}

	/**分页查询某个保险公司对应的产品列表*/
	@RequiresPermissions("myinscompany:win:list")
	@RequestMapping(value = "/queryPro" , method = RequestMethod.POST)
	public @ResponseBody Object queryPro(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(insS.queryPro(params),resp); return null;
	}

	/**手动同步*/
	@RequiresPermissions("myinscompany:sync")
	@RequestMapping(value = "/sync")
	public @ResponseBody Object sync(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return insS.sync(p);
	}

}