package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.models.statistics.service.StatisticsService;
import com.google.common.collect.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 统计业务
 * @version
 */
@Controller
@RequestMapping("${systemPath}/mysta")
public class MyStatisticsController extends BaseController {

	private static final String STA_UINIT = getViewPath("admin/mysta/statistics_uinit");
	private static final String STA_PINIT = getViewPath("admin/mysta/statistics_pinit");
	private static final String STA_OINIT = getViewPath("admin/mysta/statistics_oinit");


	@Autowired
	private StatisticsService staM;

	/**统计页*/
	@RequiresPermissions("mysta:win:uinit")
	@RequestMapping(value = "/win/u-init")
	public String winUInit(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("p",params);
		model.addAttribute("ys",getY());//有效年
		model.addAttribute("ty",thisY());//当前年
		model.addAttribute("tms",getM());//当前年月列表
		model.addAttribute("tm",thisM());//当前月
		return STA_UINIT;
	}
	@RequiresPermissions("mysta:win:pinit")
	@RequestMapping(value = "/win/p-init")
	public String winPInit(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("p",params);
		model.addAttribute("ys",getY());
		model.addAttribute("ty",thisY());
		model.addAttribute("tms",getM());//当前年月列表
		model.addAttribute("tm",thisM());//当前月
		return STA_PINIT;
	}
	@RequiresPermissions("mysta:win:oinit")
	@RequestMapping(value = "/win/o-init")
	public String winOInit(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("p",params);
		model.addAttribute("ys",getY());
		model.addAttribute("ty",thisY());
		model.addAttribute("tms",getM());//当前年月列表
		model.addAttribute("tm",thisM());//当前月
		return STA_OINIT;
	}

	/**统计用户信息，产品访问评率，下单率，成交率*/
	@RequiresPermissions("mysta:win:uinit")
	@RequestMapping(value = "/user" , method = RequestMethod.POST)
	public @ResponseBody Object user(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.user(params),resp); return null;
	}

	/**统计月用户注册，区分平台*/
	@RequiresPermissions("mysta:win:uinit")
	@RequestMapping(value = "/user-reg" , method = RequestMethod.POST)
	public @ResponseBody Object user_reg(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.user_reg(params),resp); return null;
	}

	/**统计产品访问数相关信息，同类型产品订单占比*/
	@RequiresPermissions("mysta:win:pinit")
	@RequestMapping(value = "/req-pro" , method = RequestMethod.POST)
	public @ResponseBody Object req_pro(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.pro_req(params),resp); return null;
	}

	/**统计产品年销售数，及销售金额*/
	@RequiresPermissions("mysta:win:pinit")
	@RequestMapping(value = "/amt-pro" , method = RequestMethod.POST)
	public @ResponseBody Object amt_pro(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.amt_pro(params),resp); return null;
	}

	/**统计订单基础信息*/
	@RequiresPermissions("mysta:win:oinit")
	@RequestMapping(value = "/com-order" , method = RequestMethod.POST)
	public @ResponseBody Object com_order(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.com_order(params),resp); return null;
	}

	/**根据月份查询产品关联订单承保数据统计*/
	@RequiresPermissions("mysta:win:oinit")
	@RequestMapping(value = "/pro-order" , method = RequestMethod.POST)
	public @ResponseBody Object pro_order(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.pro_order(params),resp); return null;
	}

	/**根据月份查询产品关联订单承保总保费数据统计*/
	@RequiresPermissions("mysta:win:oinit")
	@RequestMapping(value = "/pro-order-amout" , method = RequestMethod.POST)
	public @ResponseBody Object pro_order_amout(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.pro_order_amout(params),resp); return null;
	}

	/**统计每月销售金额、当月累计销售总额*/
	@RequiresPermissions("mysta:win:oinit")
	@RequestMapping(value = "/all-amt" , method = RequestMethod.POST)
	public @ResponseBody Object all_amt(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.all_amt(params),resp); return null;
	}

	/**统计订单区域分布信息*/
	@RequiresPermissions("mysta:win:oinit")
	@RequestMapping(value = "/addr-order" , method = RequestMethod.POST)
	public @ResponseBody Object addr_order(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(staM.user(params),resp); return null;
	}

	public static void main(String[] args) {
		System.out.println(thisM());
	}

	private static List<String> getY(){
		int min_y = 2017;
		int max_y = 1900+(new Date()).getYear();
		List<String> list = Lists.newArrayList();
		for(int i=min_y; i<=max_y; i++){
			list.add(String.valueOf(i));
		}
		return list;
	}
	private static String thisY(){
		return String.valueOf(1900+(new Date()).getYear());
	}

	private static String thisM(){
		return String.valueOf((new Date()).getMonth()+1);
	}

	private static List<String> getM(){
		int min_m = 1;
		int max_m = (new Date()).getMonth()+1;
		List<String> list = Lists.newArrayList();
		for(int i=min_m; i<=max_m; i++){
			list.add(String.valueOf(i));
		}
		return list;
	}
}