package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.entity.common.ComInform;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.product_core.ProPrimaryRuleXWCK;
import com.bcxin.ins.models.inf.service.InformService;
import com.bcxin.ins.models.pro.service.MyProService;
import com.bcxin.ins.models.pro.service.ProExpCustomsCompaniesService;
import com.bcxin.ins.models.pro.service.ProPrimaryRuleXWCKService;
import com.bcxin.ins.models.pro.service.ProResponsibilityService;
import com.bcxin.ins.util.ConstProp;
import com.bcxin.ins.util.RegionUtils;
import com.google.common.collect.Maps;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 公告
 * @version
 */
@Controller
@RequestMapping("${systemPath}/myinf")
public class MyInfController extends BaseController {

	/**公告列表*/
	private static final String INF_LIST = getViewPath("admin/inf/inf_list");
	/**详情、新增、修改公告页面*/
	private static final String INF_ADD = getViewPath("admin/inf/inf_add");


	@Autowired
	private InformService infS;

	/**公告信息列表*/
	@RequiresPermissions("myinf:win:list")
	@RequestMapping(value = "/win/list")
	public String winRXWCKList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("p",params);
		return INF_LIST;
	}

	/**详情、新增、修改公告信息页面*/
	@RequiresPermissions("mypro:win:list")
	@RequestMapping(value = "/win/add")
	public String winRXWCKAdd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("mark","add");
		model.addAttribute("p",params);
		return INF_ADD;
	}
	/**详情、新增、修改公告信息页面*/
	@RequiresPermissions("myinf:win:list")
	@RequestMapping(value = "/win/upd")
	public String winUpd(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		Map<String,Object> m = Maps.newHashMap();
		m.put("com_inform_id",params.get("com_inform_id"));
		model.addAttribute("mark","upd");
		model.addAttribute("p",params);
		ComInform row = infS.selectByMap(m).get(0);
		model.addAttribute("row",row);

		return INF_ADD;
	}

	/**公告信息新增*/
	@RequiresPermissions("myinf:win:add")
	@RequestMapping(value = "/add" , method = RequestMethod.POST)
	public @ResponseBody Object add(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return infS.add(p);
	}
	/**公告信息修改*/
	@RequiresPermissions("myinf:win:upd")
	@RequestMapping(value = "/upd" , method = RequestMethod.POST)
	public @ResponseBody Object upd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return infS.upd(p);
	}

	/**公告信息删除*/
	@RequiresPermissions("myinf:win:del")
	@RequestMapping(value = "/del" , method = RequestMethod.POST)
	public @ResponseBody Object del(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return infS.del(p);
	}

	/**公告信息列表分页*/
	@RequiresPermissions("myinf:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(infS.query(params),resp); return null;
	}

}