package com.bcxin.ins.models.pub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.SysLogSms;
import com.bcxin.ins.core.service.SysLogSmsService;
import com.bcxin.ins.models.pub.service.ADModelSendService;
import com.bcxin.ins.util.MD5Util;
import com.bcxin.ins.util.http.HuaWeiSmsContent;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.util.http.SMSUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.SmsModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;


/**
 * 手机短信发送
 *
 */
@Service
public class ADModelSendServiceImpl implements ADModelSendService {

    @Autowired
    private SysLogSmsService sss;

    @Override
    public boolean sendModleMessage(String type, String content, String mobile) {
        String url="http://msg.bcxin.com.cn:9165/sms/sendMessage";
        String  key ="bcxinABCXIN$1012 "; //key
        //PSS  -pss   百宝盾 - ars    百联宝 blb
        String requestId=System.currentTimeMillis()+"";// 开始时间
        JSONObject json= new JSONObject();
        boolean flag = false;
        json.put("type",type);
        json.put("content",content);//内容
        json.put("mobile",mobile);//手机号码
        json.put("requestId",requestId);
        json.put("token", MD5Util.string2MD5(requestId+type+key));//秘钥
        try {
            String ret = RequestUtil.initHttp().doPost(url, json.toString(), ConstProp.CT_JSON, ConstProp.ENCODE_UTF8);
            JSONObject  retJson =JSONObject.parseObject(ret);
            if(retJson.get("status").equals(ConstProp.CODE_SUCCESS)){
                flag = true;
            }
        }catch (Exception ex){

        }
        saveSms(content,mobile,flag);//插入手机日志
        return flag;
    }

    /**
     * <b> 新版华为短信发送 </b>
     * @author ZXF
     * @create 2020/02/24 0024 10:11
     * @version
     * @注意事项 </b>
     */
    @Override
    public void sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
        SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);
        saveSms(SmsModel.getContent(huaWeiSmsContent.getSmsCode(),huaWeiSmsContent.getParams()),huaWeiSmsContent.getMobile(),true);
    }

    /**
     * <b> 发送短信的相关信息记录入日志 </b>
     * @author ZXF
     * @create 2018/09/12 0012 18:28
     * @version
     * @注意事项 </b>
     */
    private void saveSms(String content, String mobile,boolean flag){
        SysLogSms sls = new SysLogSms();
        sls.setContent(content);
        sls.setCreate_time(new Date());
        sls.setPhone(mobile);
        sls.setSuccess(flag?0:1);
        sss.insert(sls);
    }
}