package com.bcxin.ins.models.product.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.models.product.entity.InsProductLog;
import com.bcxin.ins.models.product.service.InsProductLogService;
import com.bcxin.ins.vo.DwzPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;


@Controller
@RequestMapping("${systemPath}/ins/product/log")
public class InsProductLogController extends BaseController {

	/** PG1.2 审核列表 */
	private static final String PRODUCT_EXAMINE_LIST = getViewPath("admin/product/product_examine_list");

	@Autowired
	private InsProductLogService  insProductLogService;

	@RequestMapping("/list")
	public String list(ModelMap model, DwzPage page, InsProductLog  log) {
		List<InsProductLog> plist= insProductLogService.findProductLogList(log);
		model.addAttribute("plist", plist);
		return PRODUCT_EXAMINE_LIST;
	}
}
