package com.bcxin.ins.models.product.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsProductVo;
import com.google.common.collect.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;
import java.util.Map;

@Controller
@SessionAttributes("productVo")
@RequestMapping("${systemPath}/ins/product")
public class InsProductController extends BaseController {

	/** PG1.1 商品列表 */
	private static final String PRODUCT_LIST = getViewPath("admin/product/product_list");

	/** PG1.1.5 批量分配商品 */
	private static final String PRODUCT_CHANGE_LIST = getViewPath("admin/product/product_change_list");

	/** 分销商列表 */
	private static final String PRODUCT_COMPANY_LIST = getViewPath("admin/product/product_company_list");

	/** PG1.1.6 佣金设置 */
	private static final String PRODUCT_FEE_DATA = getViewPath("admin/product/product_fee_data");

	/** 产品详情 */
	private static final String PRODUCT_DETATIL = getViewPath("admin/product/product_list");

	/**选择产品列表 单个*/
	private static final String PRODUCT_FEE_LIST_ONE = getViewPath("admin/product/product_change_list_one");

	/**设置佣金单个*/
	private static final String PRODUCT_FEE_DATA_ONE = getViewPath("admin/product/product_fee_data_one");

	/**分销商产品分配列表*/
	private static final String PRODUCT_COMPANY_LIST_ONE = getViewPath("admin/product/product_company_list_one");

	@Autowired
	private InsProductService insProductService;

	@Autowired
	private SysCompanyService 	sysCompanyService;
	/**
	 * <b>产品类表 </b>
	 *
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午5:05:39
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("product:list:view")
	@RequestMapping("/list")
	public String list(ModelMap model,DwzPage page) {
		ProPrimary insProduct = new ProPrimary();
		String type = this.getParameter("type");
		List<ProPrimary> plst= insProductService.findProductList(insProduct);
		model.addAttribute("plst", plst);
		return PRODUCT_LIST;
	}

	/**
	 * <b>分配产品列表 </b>
	 * @param model
	 * @param page
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午8:52:34
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("product:list:change")
	@RequestMapping("/changeList")
	public String changeList(ModelMap model,DwzPage page) {
		List<ProPrimary> plst= insProductService.findProductList(new ProPrimary());//这里需要查询出正常审核的产品
		model.addAttribute("plst", plst);
		return PRODUCT_CHANGE_LIST;
	}
	/**
	 * <b>组装 产品穿过来的值</b>
	 *
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月10日 上午10:21:49
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("product:list:change")
	@RequestMapping("/saveNextCompany")
	public ModelAndView saveNextCompany(ModelMap model){
		InsProductVo productVo= new  InsProductVo();
		String[] pids = getRequest().getParameterValues("productName");
		//设置产品
		if(pids.length>0){
			List<ProPrimary> plist= insProductService.fillProductList(pids);
			productVo.setPlist(plist);
			model.put("productVo", productVo);
		}else{
			return new ModelAndView("redirect:changeList");
		}
		return new ModelAndView("redirect:companylist");
	}

	/**
	 * <b>分销商列表 </b>
	 * @param model
	 * @param page
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午8:47:32
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("product:list:change")
	@RequestMapping("/companylist")
	public String companylist(ModelMap model,DwzPage page) {
		List<SysCompany> slist=sysCompanyService.getDistributorListByLevel("1");//查询1级分销商
		model.put("slist", slist);
		return PRODUCT_COMPANY_LIST;
	}

	/**
	 * <b>组装 分销商传过来的值 </b>
	 *
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月10日 下午1:41:08
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("product:list:change")
	@RequestMapping("/saveNextFeeData")
	public ModelAndView saveNextFeeData(ModelMap model){
		InsProductVo    productVo= (InsProductVo) model.get("productVo");
		String[] cids = getRequest().getParameterValues("companyName");
		//设置分销商 列表
		if(cids.length>0){
			List<SysCompany> slist= insProductService.fillCompanyList(cids);
			productVo.setSlist(slist);
			model.put("productVo", productVo);
		}else{
			return new ModelAndView("redirect:changeList");
		}
		return new ModelAndView("redirect:fillFeeData");
	}

	/**
	 * <b>分销商列表 </b> 
	 * 
	 * @param model
	 * @param
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午8:47:32
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("product:list:change")
	@RequestMapping("/fillFeeData")
	public String fillFeeData(ModelMap model) {
		InsProductVo    productVo= (InsProductVo) model.get("productVo");
		if(productVo==null){
			return "redirect:changeList";
		}
		List<ProPrimary> plst= productVo.getPlist();
		model.addAttribute("plst", plst);
		model.addAttribute("slist", productVo.getSlist());
		return PRODUCT_FEE_DATA;
	}

	/**
	 * <b>保存佣金 </b> 
	 * 
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月10日 下午3:22:05
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("product:list:change")
	@RequestMapping(value = "/saveCompanyBrokerage",method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult saveCompanyBrokerage(ModelMap model) {
		InsProductVo    productVo= (InsProductVo) model.get("productVo");
		if(productVo==null){
			return fail(true, "请重新获取产品！！！");
		}

//		boolean flag=insProductCompanyFeeService.fillCompanyBrokerage(getRequest(),productVo);
		return success(true, "保存佣金列表成功!");
	}

	/**
	 * 模糊搜搜
	 * 根据关键字查询产品列表
	 * @param model
	 * @param keyword
	 * @return
	 */
	@RequestMapping("/findProductKeyword")
	public String findProductKeyword(ModelMap model,String keyword) {
		List<ProPrimary> plst= insProductService.findProductList(keyword);//这里需要查询出正常审核的产品
		model.addAttribute("plst", plst);
		model.addAttribute("keyword",keyword);
		return PRODUCT_CHANGE_LIST;
	}
	/**
	 * <b>获取产品详情 </b>
	 *
	 * @param oid
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午5:06:37
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/getProduct/{oid}")
	public String getProduct(@PathVariable Long oid,ModelMap model) {
		return PRODUCT_DETATIL;
	}

	/**
	 * 模糊搜搜
	 * 根据关键字查询产品列表  单个设置页面
	 * @param model
	 * @param keyword
	 * @return
	 */
	@RequiresPermissions(value = {"product:list:productList:one"})
	@RequestMapping("/findProductKeywordOne")
	public String findProductKeywordOne(ModelMap model,String keyword) {
		List<ProPrimary> plst= insProductService.findProductList(keyword);//这里需要查询出正常审核的产品
		model.addAttribute("plst", plst);
		model.addAttribute("keyword",keyword);
		model.addAttribute("companyId", this.getParameter("companyId"));
		return PRODUCT_FEE_LIST_ONE;
	}

	/**
	 * 分配商品查询页面及资源方
	 * @return
	 */
	@RequiresPermissions(value = {"product:list:productList:one"})
	@RequestMapping(value = "/list/companyToProductList")
	public String companyToProductList(Model model){
		String companyId = this.getParameter("companyId");
		String level = this.getParameter("level");
		String parentId = this.getParameter("parentId");
		if (StrUtil.isNotBlank(companyId)){
//			List<Map<String,Object>> list = insProductCompanyFeeService.findDistributorProductList(Long.parseLong(companyId));
//			model.addAttribute("list",list);
			model.addAttribute("companyId",companyId);
			model.addAttribute("level",level);
			model.addAttribute("parentId",parentId);
		}
		return PRODUCT_COMPANY_LIST_ONE;
	}

	/**
	 * 打开选择产品表页面   单个设置
	 * @param model
	 * @return
	 */
	@RequiresPermissions(value = {"product:list:productList:one"})
	@RequestMapping(value = "/list/openProductList")
	public String openProductList(Model model){
		String companyId = this.getParameter("companyId");
		String productIds = this.getParameter("productIds");
		if(StrUtil.isNotBlank(companyId)){
			model.addAttribute("companyId", companyId);
		}
		if(StrUtil.isNotBlank(companyId)){
			model.addAttribute("productIds", productIds);
		}
		//获取分销商等级,下级分销商
		String level = this.getParameter("level");
		String parentId = this.getParameter("parentId");
		List<ProPrimary> plst = Lists.newArrayList();
		if(SysCompany.DISTRIBUTIONLEVEL_TWO.equals(level)||SysCompany.DISTRIBUTIONLEVEL_THREE.equals(level)){
//			if(StrUtil.isNotBlank(parentId)) {
//				plst = insProductCompanyFeeService.findProductOrCompanyList(Long.parseLong(parentId));
//			}
		}else{
			plst = insProductService.findProductList(new ProPrimary());
		}
		model.addAttribute("plst", plst);
		model.addAttribute("level",level);
		model.addAttribute("parentId",parentId);
		return  PRODUCT_FEE_LIST_ONE;
	}

	/**
	 * 设置佣金 单个设置
	 * @param model
	 * @return
	 */
	@RequiresPermissions(value = {"product:list:productList:one"})
	@RequestMapping(value = "/list/openProductSetFeeOne")
	public String openProductSetFee(Model model){
		String companyId = this.getParameter("companyId");
		String productIds = this.getParameter("productIds");
		if(StrUtil.isNotBlank(companyId)){
			model.addAttribute("companyId", companyId);
			model.addAttribute("company", sysCompanyService.get(StrUtil.toLong(companyId)));
		}
		if(StrUtil.isNotBlank(productIds)){
			List<ProPrimary> plst = insProductService.findByIdsArray(StrUtil.StrArr2LongArras(productIds.split(",")),companyId);
			model.addAttribute("plst", plst);
			model.addAttribute("productIds", productIds);
		}
		return PRODUCT_FEE_DATA_ONE;
	}
	/**
	 * <b>保存佣金 </b>
	 *
	 * @param insProductCompanyFee
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月10日 下午3:22:05
	 * @注意事项 </b>
	 * <b>
	 */
//	@RequiresPermissions("product:list:change")
//	@RequestMapping(value = "/saveCompanyBrokerageOne",method = RequestMethod.POST)
//	@ResponseBody
//	public AjaxResult saveCompanyBrokerageOne(InsProductCompanyFee insProductCompanyFee) {
//		List<InsProductCompanyFee> list = insProductCompanyFee.getList();
//		if(list!=null && list.size()>0) {
//			boolean flag = insProductCompanyFeeService.insertOrUpdateFee(insProductCompanyFee.getList());
//			if (flag)
//				return success(true, "保存佣金列表成功!");
//		}
//		return fail(false, "保存失败,请联系管理员!");
//	}


	/**
	 * POST 启用/禁止
	 * @return
	 */
	@RequestMapping(value = "/list/audit", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult audit() {
		Long pId = Long.parseLong(getParameter("accountId"));
		Integer status = Integer.valueOf(getParameter("status"));
		ProPrimary product =new ProPrimary();
		product.setPro_primary_id(pId);
		product.setStatus(status);
		insProductService.updateById(product);
		return success(true);
	}

	@RequiresPermissions("product:list:delete:configure")
	@RequestMapping(value = "/list/{accountId}/delete", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult delete(@PathVariable Long accountId) {
//		insProductCompanyFeeService.deleteById(accountId);
		return success(true);
	}
}
