package com.bcxin.ins.models.product.service.impl;

import com.bcxin.ins.core.dao.SysCompanyDao;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.product_core.ProPrimaryExpire;
import com.bcxin.ins.models.product.dao.InsProductDao;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.models.product.service.InsProductggService;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.InsProductVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


/**
 * 保险产品实现
 * @author playboy
 *
 */
@Service
@Transactional
public class InsProductServiceImpl extends ServiceImpl<InsProductDao, ProPrimary> implements InsProductService {


	@Autowired
	private InsProductDao  dao;
	@Autowired
	private SysCompanyDao  sysCompanyDao;
	@Autowired
	private InsProductggService insProductggService;
	@Autowired
	private SysCompanyService sysCompanyService;
	@Override
	public List<ProPrimary> findProductList(ProPrimary insProduct) {
//		this.dataScopeFilter(insProduct," t.supplier_id");
		return dao.findProductList(insProduct);
	}

	@Override
	public List<ProPrimary> findProductList(String keyword) {
		return dao.selectInsProductListByCondition(keyword);
	}

	@Override
	public ProPrimary findProductByCode(String code){
		return dao.getInsProductgByCode(code);
	}

	@Override
	public List<ProPrimary> fillProductList(String[] pids) {

		List<ProPrimary>  plist= new ArrayList<ProPrimary>();
		for (String pid : pids) {
			ProPrimary  product=  dao.getProduct(Long.parseLong(pid));
			plist.add(product);
		}
		return plist;
	}

	@Override
	public List<SysCompany> fillCompanyList(String[] cids) {
		List<SysCompany>  slist= new ArrayList<SysCompany>();
		for (String cid : cids) {
			SysCompany  sysCompany= sysCompanyDao.selectById(Long.parseLong(cid));
			slist.add(sysCompany);
		}
//		List<SysCompany> slist=new ArrayList<SysCompany>();
//		SysCompany  company1= new SysCompany();
//		company1.setId(12525l);
//		company1.setCreateTime(new Date());
//		company1.setCompanyName("特殊机构");
//		company1.setStatus(1);
//		slist.add(company1);
//		SysCompany  company2= new SysCompany();
//		company2.setId(1254l);
//		company2.setCreateTime(new Date());
//		company2.setCompanyName("军机处");
//		company2.setStatus(1);
//		slist.add(company2);
	
		return slist;
	}

	/**
	 *查询产品属性 根据产品id（主） 和类型 去关联哪一张表
	 * @param pid
	 * @return
	 */
	@Override
	public InsProductVo getProductAttrListByPid(Long pid, String type) {
		return dao.getProductAttrListByPid(pid,type);

	}

	@Override
	public ProPrimary getProduct(Long pid) {
		return dao.getProduct(pid);
	}

	/**
	 * <b>根据产品id获取产品信息设置到OrderFormVo</b>
	 *
	 * @param vo
	 * @param insProduct_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月10日 下午2:46:50
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToProductIDToGetInsProductSetUpOrderFormVo(OrderFormVo vo, Long insProduct_id){
		ProPrimary insProduct = dao.getProduct(insProduct_id);
		if(insProduct != null){
			ProPrimaryExpire insProductgg = insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
			if(insProductgg != null){
				vo.setFees_for(insProductgg.getFees_for());
				vo.setPay_methods(insProductgg.getPay_methods());
			}
			vo.setProduct_name(insProduct.getInsurance_name());
			vo.setProduct_code(insProduct.getProduct_code());
			if(insProduct.getSupplier_id() != null){
				SysCompany sysCompany = sysCompanyService.selectById(insProduct.getSupplier().getSys_ins_company_id());
				if(sysCompany != null){
					vo.setInsurance_name(sysCompany.getCompanyName());
				}
			}
		}
	}

	/**
	 * <b>根据产品id获取产品信息设置到AdviceNoteVo</b>
	 *
	 * @param vo
	 * @param insProduct_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月10日 下午2:46:50
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToProductIDToGetInsProductSetUpAdviceNoteVo(AdviceNoteVo vo, Long insProduct_id){
		ProPrimary insProduct = dao.getProduct(insProduct_id);
		if(insProduct != null){
			ProPrimaryExpire insProductgg = insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
			if(insProductgg != null){
				vo.setPay_methods(insProductgg.getPay_methods());
			}
			vo.setProduct_name(insProduct.getInsurance_name());
			vo.setProduct_type(insProduct.getProduct_type());
			if(insProduct.getSupplier() != null){
				SysCompany sysCompany = sysCompanyService.selectById(insProduct.getSupplier().getSys_ins_company_id());
				if(sysCompany != null){
					vo.setCompany_ename(sysCompany.getCompanyEName());
					vo.setCompany_name(sysCompany.getCompanyName());
					vo.setShort_name(sysCompany.getShortName());
					vo.setRegistered_address(sysCompany.getRegisteredAddress());
					vo.setBank_name(sysCompany.getBankName());
					vo.setBank_account(sysCompany.getBankAccount());
					vo.setBank_account_name(sysCompany.getBankAccountName());
				}
			}
		}
	}

	/**
	 * <b>查询所有产品 </b>
	 *
	 * @return
	 * @author ZXF
	 * @date 2017年1月10日 下午2:45:30
	 * @注意事项 </b>
	 * <b>
	 */
	public List<ProductVo> selectProductVoList(ProPrimary insProduct){
		List<ProductVo> voList = new ArrayList<ProductVo>();
		List<ProPrimary> productList = dao.findProductList(insProduct);
		for(ProPrimary ip : productList){
			voList.add(willInsProductSetUpProductVo(ip));
		}
		return voList;
	}

	/**
	 * <b>根据产品子表id查询并封装到ProductVo </b>
	 *
	 * @param insProductID
	 * @return
	 * @author ZXF
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID){
		ProPrimary ip = dao.getProduct(insProductID);
		if(ip != null){
			return willInsProductSetUpProductVo(ip);
		}
		return null;
	}

	/**
	 * <b>将产品信息匹配到ProductVo辅助类 </b>
	 *
	 * @param ip
	 * @return
	 * @author ZXF
	 * @date 2017年1月10日 下午2:46:50
	 * @注意事项 </b>
	 * <b>
	 */
	public ProductVo willInsProductSetUpProductVo(ProPrimary ip){
		ProductVo vo = new ProductVo();
		vo.setOid(String.valueOf(ip.getPro_primary_id()));
		vo.setProduct_name(ip.getInsurance_name());
//		vo.setProductDescribe(ip.getIntro());
		vo.setProduct_code(ip.getProduct_code());
		if(ip.getSupplier() != null){
			SysCompany sysCompany = sysCompanyService.selectById(ip.getSupplier().getSys_ins_company_id());
			if(sysCompany != null){
				vo.setInsurance_name(sysCompany.getCompanyName());//保险公司名称
			}
		}
		return vo;
	}

	@Override
	public List<ProPrimary> findByIdsList(List<Long> ids) {
		return dao.findByIdsList(ids);
	}

	@Override
	public List<ProPrimary> findByIdsArray(Long[] ids,String companyId){
		SysCompany sysCompany = sysCompanyService.get(StrUtil.toLong(companyId));
		List<ProPrimary> list = Lists.newArrayList();
		if(sysCompany.getCompanyType().equals(SysCompany.COMPANY_TYPE_CHANNEL)){
			list = dao.findByIdsArray(ids);
		}else if(sysCompany.getCompanyType().equals(SysCompany.COMPANY_TYPE_DISTRIBUTOR)){
			if(SysCompany.DISTRIBUTIONLEVEL_TWO.equals(sysCompany.getDistributionLevel())||SysCompany.DISTRIBUTIONLEVEL_THREE.equals(sysCompany.getDistributionLevel())) {
				list = dao.findByIdsArrayDistributor(ids, StrUtil.obj2Str(sysCompany.getParent().getId()));
			}else {
				list = dao.findByIdsArrayDistributor(ids, null);
			}
		}
		return list;
	}
}
