package com.bcxin.ins.models.product.dao;


import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsProductVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 产品主表DAO
 * @author playboy
 *
 */
@MyBatisDao
public interface InsProductDao extends BaseMapper<ProPrimary> {

	List<ProPrimary> findProductList(ProPrimary insProduct);

	/**
	 * <b>根据关键字查询所有产品 </b>
	 * @param keywords 关键字
	 * @return
	 * @author ZXF
	 * @date 2017年1月10日 下午5:09:14
	 * @注意事项 </b>
	 * <b>
	 */
	public List<ProPrimary> selectInsProductListByCondition(@Param("keywords") String keywords);

	public ProPrimary getInsProductgByCode(@Param("code") String code);

	/**
	 * 根据产品和类别查询对应的关联列表
	 * @param pid
	 * @param type
	 * @return
	 */
	InsProductVo getProductAttrListByPid(Long pid, String type);

	/**
	 * 查询详细的产品
	 * @param pid
	 * @return
	 */
	ProPrimary getProduct(Long pid);

	/**
	 * 根据产品ID查询产品list
	 */
	List<ProPrimary> findByIdsList(List<Long> ids);

	/**
	 *根据产品ID查询
	 * @param ids
	 * @return
	 */
	List<ProPrimary> findByIdsArray(@Param("ids") Long[] ids);

	List<ProPrimary> findByIdsArrayDistributor(@Param("ids") Long[] ids,@Param("companyId") String companyId);

}
