package com.bcxin.ins.models.pro.service;

import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.mybatisplus.service.IService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
* 类名称：sysUserService   
* 类描述：sysUser 表业务逻辑层接口   
* 创建人：liujinju
* @version
 */
public interface MyProService  extends IService<ProPrimary>  {
    /**产品列表分页查询*/
    PageResult query(Map<Object, Object> p);
    /**产品分类分页查询*/
    PageResult queryCategory(Map<Object, Object> p);
    /**小微企业信用险的区域规则配置列表查询，传入产品ID*/
    PageResult queryRXWCK(Map<Object, Object> p);
    /**新增区域规则配置*/
    R rXWCKAdd(Map<Object, Object> p);
    /**修改区域规则配置*/
    R rXWCKUpd(Map<Object, Object> p);
    /**删除区域规则配置*/
    R rXWCKDel(Map<Object, Object> p);
    /**出口300万美元以下企业名单列表查询*/
    PageResult queryECC(Map<Object, Object> p);
    /**批量新增出口300万美元以下企业名单*/
    R eCCFile(MultipartFile mFile);
    /**新增出口300万美元以下企业名单*/
    R eCCAdd(Map<Object, Object> p);
    /**修改出口300万美元以下企业名单*/
    R eCCUpd(Map<Object, Object> p);
    /**删除出口300万美元以下企业名单*/
    R eCCDel(Map<Object, Object> p);
    /**删除出口300万美元以下企业名单*/
    R eCCBatchDel(Map<Object, Object> p);
    /**某个产品的保障责任列表查询，传入产品ID*/
    PageResult querySR(Map<Object, Object> p);
    /**新增保障责任*/
    R srAdd(Map<Object, Object> p);
    /**修改保障责任*/
    R srUpd(Map<Object, Object> p);
    /**删除保障责任*/
    R srDel(Map<Object, Object> p);
    /** 产品表手动同步 */
    R proSync(Map<Object, Object> p);
    /** 产品分类表手动同步 */
    R categorySync(Map<Object, Object> p);

    //产品保存
    /*新增*/
    R addPro(Map<Object, Object> p, CommonsMultipartFile[] files);
    /*修改*/
    R updPro(Map<Object, Object> p, CommonsMultipartFile[] files);

    List<Map<Object,Object>> queryProByID(Map<Object, Object> p);

    /**
     * 递归获得父节点
     * @param p
     * @return
     */
    Map<Object,Object>  queryTopParent(Map<Object, Object> p);

    R addSource(Map<Object, Object> p, HttpServletRequest request);
}