package com.bcxin.ins.models.order.policy.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.product_core.ProPrimaryExpire;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.models.order.policy.service.*;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.models.product.service.InsProductggService;
import com.bcxin.ins.util.OrderSupportUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.util.enums.OfficeType;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.poi.excel.ExcelUtil;
import com.xiaoleilu.hutool.poi.excel.ExcelWriter;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * <b>后台模块订单处理 </b>
 *
 * @author liyongqiang
 * @date 2017年1月11日 下午5:32:56
 * @注意事项 </b> <b>
 */
@Controller
@RequestMapping(value = "${systemPath}/ins/policy")
public class PolicyManagerActionController extends BaseController {

	@Autowired
	private InsuranceOperationService insuranceOperationService;
	@Autowired
	private InsInsuranceSlipService insInsuranceSlipService ;
	@Autowired
	private InsUnderwriteService insUnderwriteService;
	@Autowired
	private InsProductggService insProductggService;
	@Autowired
	private InsProductService insProductService;
	@Autowired
	private InsOrderFormDetailsVoService insOrderFormDetailsVoService;
	@Autowired
	private InsProductResponsibilityService insProductResponsibilityService;
	@Autowired
	private ComDeployConfigService comDeployConfigService;
	@Autowired
	private PreseverApplyService preseverApplyService;

	/** PG2.1.2 订单详情-小微企业 */
	private static final String ORDER_MIRO_DETATIL = getViewPath("admin/order/order_miro_detatil");

	/** PG2.1 订单列表 */
	private static final String ORDER_LIST = getViewPath("admin/order/order_manager_list");

	/** 保单在保人员列表 */
	private static final String UNDER_WARRANTY_LIST = getViewPath("admin/order/under_warranty_list");

	/** PG2.2 诉讼订单列表 */
	private static final String LAWSUIT_LIST = getViewPath("admin/order/lawsuit_manager_list");

	/** 后台管理登录页面 */
	private static final String ADMIN_LOGIN = getViewPath("admin/login/admin_login");

	/** PG2.1.2 订单详情-企业 */
	private static final String ORDER_DETATIL = getViewPath("admin/order/order_detatil");

	/** PG2.1.2 订单详情-投标 */
	private static final String ORDER_BUILD_DETATIL = getViewPath("admin/order/order_build_detatil");

	/** PG2.1.2 订单详情-履约 */
	private static final String ORDER_LY_DETATIL = getViewPath("admin/order/order_ly_detatil");

	/** PG2.1.2 订单详情-诉讼 */
	private static final String ORDER_SS_DETATIL = getViewPath("admin/order/order_ss_detatil");

	/** PG2.1.2 订单详情-团意险 */
	private static final String ORDER_GMR_DETATIL = getViewPath("admin/order/order_gmr_detatil");

	/** PG2.0.6 订单详情-雇主责任险 */
	private static final String ORDER_GZZRX_DETATIL = getViewPath("admin/order/order_gzzrx_detatil");

	/** PG2.1.2 订单详情-个意险 */
	private static final String ORDER_GYX_DETATIL = getViewPath("admin/order/order_gyx_detatil");

	/** PG2.1.2 订单详情-诉讼 */
	private static final String ORDER_GZX_DETATIL = getViewPath("admin/order/order_afr_detatil");

	/** PG2.1.2 订单详情-诉讼 */
	private static final String ORDER_LOTE_DETATIL = getViewPath("admin/order/order_lote_detatil");

	/** PG2.1.4 承保 */
	private static final String ORDER_UNDERWRITING = getViewPath("admin/order/order_underwriting");

	/** PG2.1.3 核保 */
	private static final String ORDER_ACCEPT_INSURANCE = getViewPath("admin/order/order_accept_insurance");
	/** PG2.1.3 核保 */
	private static final String TRANSACTION_DETATIL = getViewPath("admin/order/transaction_detatil");

	/** PG2.1.3 核保诉讼 */
	private static final String ORDER_ACCEPT_INSURANCE_LITIGATION = getViewPath("admin/order/order_accept_insurance_litigation");
	/** PG2.1.3 承保 */
	private static final String ORDER_UNDERWRITING_LITIGATION = getViewPath("admin/order/order_underwriting_litigation");

	/** PG2.1.3 核保履约 */
	private static final String ORDER_ACCEPT_INSURANCE_PG = getViewPath("admin/order/order_accept_insurance_pg");
	/** PG2.1.3 承保 */
	private static final String ORDER_UNDERWRITING_PG = getViewPath("admin/order/order_underwriting_pg");

    /** PG2.1 PSS订单列表 */
    private static final String PSS_ORDER_LIST = getViewPath("admin/order/pss_order_manager_list");
    private static final String PSS_ORDER_MANAGER = getViewPath("admin/order/pss_order_manager");

	/** PG2.1 ars订单列表 */
	private static final String ARS_ORDER_LIST = getViewPath("admin/order/ars_order_manager_list");
	private static final String ARS_ORDER_MANAGER = getViewPath("admin/order/ars_order_manager");


	public static void main(String[] args) {

	}

	@RequestMapping("/orderList_table")
	public @ResponseBody Object orderList_table(HttpServletRequest request, HttpServletResponse resp, @RequestParam Map<Object, Object> params) throws UnsupportedEncodingException {
		Map<Object,Object> p = CTLUtil.init(request,params);
		CTLUtil.out(insInsuranceSlipService.findInsOrderFormByKeyword(p),resp);
		return null;
	}


	/**
	 * <b>订单列表 </b>
	 *
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月12日 上午9:10:54
	 * @注意事项 </b> <b>
	 */
	@RequiresPermissions("orderForm:list:view")
	@RequestMapping("/findOrderList")
	public String findOrderList() {
		return ORDER_LIST;
	}

	@RequiresPermissions("orderForm:list:syncOrder:edit")
	@RequestMapping(value = "/orderSync", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult orderSync(HttpServletRequest request){
		return insuranceOperationService.orderUnSyncDispose();
	}

	/**
	 * <b>获取诉讼订单列表 (作废)</b>
	 *
	 * @return
	 * @author liumd
	 * @date 2017年1月12日 上午9:10:54
	 * @注意事项 </b> <b>
	 */
	@RequestMapping("/getLawsuitList")
	public String getLawsuitList(ModelMap model) {
		SysUser user= SysUserUtils.getUser();
		if(user==null){
			return  ADMIN_LOGIN;
		}
		List<OrderFormVo> volist=insInsuranceSlipService.getLawsuitList();
		model.addAttribute("olist", volist);
		return LAWSUIT_LIST;
	}

	/**
	 * <b> 导出所有在保保单信息 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 10:27
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/down_all_policy")
	public void downAllPolicy(HttpServletRequest req, HttpServletResponse resp) {
		insInsuranceSlipService.downAllPolicy(resp);
	}

	/**
	 * <b> 导出订单的人员清单为xsl </b>
	 * @author ZXF
	 * @create 2019/07/31 0031 17:24
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/exportPersonXsl/{oid}")
	public void exportPersonXsl(@PathVariable Long oid){
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		if(orderVo != null){
			List<Map<String,String>> list = null;
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.TYX.equals(orderVo.getProduct_code().split(ConstProp.MINUS)[ConstProp.INT_NUMBER_ZERO])){
				list = insuranceOperationService.findPersonByTYX(oid);
			}else if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.GZZRX.equals(orderVo.getProduct_code().split(ConstProp.MINUS)[ConstProp.INT_NUMBER_ZERO])){
				list = insuranceOperationService.findPersonByGZZRX(oid);
			}
			if(list != null){
				//将获取到的数据导出成xsl
				String path = downloadXLSTemp(getResponse(), list, null);
				getRequest().getSession().setAttribute("tempPath",path);
			}
		}
	}

	@RequestMapping("/downLoadPath/{tradeSerialNumber}")
	public void downLoadPath(@PathVariable Long tradeSerialNumber){
		Object path = getRequest().getSession().getAttribute("tempPath");
		if(path != null){
			downloadXLSPublic(getResponse(), "（订单："+tradeSerialNumber+"）人员清单",String.valueOf(path));
		}
	}

	private String downloadXLSTemp(HttpServletResponse response, List<Map<String, String>> list,
								   Map<String, String> headers) {
		ServletOutputStream out = null;
		File dir = Files.createTempDir();
		String path = dir.getPath() + "/" + System.currentTimeMillis() + ".xls";
		try {
			out = response.getOutputStream();

			File file = new File(path);
			// 通过工具类创建writer，默认创建xls格式
			ExcelWriter writer = ExcelUtil.getWriter(file);
			if (headers != null) {
				writer.setHeaderAlias(headers);
			}
			// 一次性写出内容，使用默认样式
			writer.write(list);
			// out为OutputStream，需要写出到的目标流
			writer.flush(out);
			writer.close();
		}catch (Exception e){
			e.printStackTrace();
		}finally {
			try {
				out.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return path;
	}

	private void downloadXLSPublic(HttpServletResponse response, String rename, String path) {
		ServletOutputStream out = null;
		BufferedInputStream in = null;
		try {
			out = response.getOutputStream();
			File file = new File(path);
			//response为HttpServletResponse对象
			response.setHeader("content-type", "application/octet-stream");
			response.setContentType("application/octet-stream");
			response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(rename + ".xls", "utf-8"));
			in = FileUtil.getInputStream(file);
			IoUtil.copy(in, out, IoUtil.DEFAULT_BUFFER_SIZE);
		}catch (Exception e){
			e.printStackTrace();
		}finally {
			try {
				in.close();
				out.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * <b>获取各种类型 的订单 详情</b>
	 *
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月12日 上午9:13:16
	 * @注意事项 </b> <b>
	 */
	@RequiresPermissions("orderForm:list:orderDetail:view")
	@RequestMapping("/getOrderDetatil/{oid}")
	public String getOrderList(@PathVariable Long oid, ModelMap model) throws InvocationTargetException, IntrospectionException, IllegalAccessException, NoSuchFieldException {
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		if(orderVo == null){
			return null;
		}
		InsInsuranceSlip order = insInsuranceSlipService.selectById(oid);
		if(order == null||StringUtils.isEmpty(orderVo.getProduct_code())){
			return null;
		}
		if (ConstProp.BZX_YG_GCTB.equals(orderVo.getProduct_code())){
			Map<String, String> map = comDeployConfigService.getAllConfig();
			String web_url = String.valueOf(map.get("WEB_URL"));
			String url = web_url + "/insurance/build/policy/downloadInsurancePolicy/" + orderVo.getOid();
			String returnURl = RequestUtil.sendGet(url, "");
			if (StringUtils.isNotEmpty(returnURl)) {
				JSONObject joData = (JSONObject) JSONObject.parse(returnURl);
				orderVo.setInsure_path(String.valueOf(joData.get("forwardUrl")));
			}
		}
		model.addAttribute("underwriteVo",insuranceOperationService.getUnderwriteByOrder(order));
		model.addAttribute("transactionList",order.getInsTransaction());
		model.addAttribute("orderVo",orderVo);
		if(ConstProp.XYX_DQCK.equals(orderVo.getProduct_code())){//企业短期
			CommonExportVo_1 vo1 = insuranceOperationService.getCommonExportVo_1ByOrderID(oid);
			CommonExportVo_2 vo2 = insuranceOperationService.getCommonExportVo_2ByOrderID(oid);
			CommonExportVo_3 vo3 = insuranceOperationService.getCommonExportVo_3ByOrderID(oid);
			model.addAttribute("vo1",vo1);
			model.addAttribute("vo2",vo2);
			model.addAttribute("vo3",vo3);
			if(vo1 != null&&vo1.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo1.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo1.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
			}
			return ORDER_DETATIL;
		}else if(ConstProp.XYX_XWCK.equals(orderVo.getProduct_code())){//小微短期
			MicroExportVo vo = insuranceOperationService.getMicroExportVoByOrderID(oid);
			model.addAttribute("vo",vo);
			if(vo != null&&vo.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
			}
			model.addAttribute(ConstProp.REG_RULE, RegionUtils.getRegionNameByALLCode(vo.getLawsuit_province(),vo.getLawsuit_city(),vo.getLawsuit_area())+vo.getLawsuit_address());
			return ORDER_MIRO_DETATIL;
		}else if(ConstProp.BZX_TB_GCTB.equals(orderVo.getProduct_code())
				||ConstProp.BZX_YG_GCTB.equals(orderVo.getProduct_code())
				||ConstProp.BZX_DB_GCTB.equals(orderVo.getProduct_code())){//投标
			SpecialBidVo vo = insuranceOperationService.getSpecialBidVoByOrderID(oid);
			model.addAttribute("otList", OfficeType.listT(orderVo.getProduct_code().contains("DB")?"DB":"OT"));
			model.addAttribute("vo",vo);
			model.addAttribute("reg_policy", RegionUtils.getRegionNameByALLCode(vo.getProvince(),vo.getCity(),vo.getArea_code()));
			if(vo != null&&vo.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
				model.addAttribute("reg_role_1", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_district()));
			}
			return ORDER_BUILD_DETATIL;
		}else if(ConstProp.BZX_GCLY.equals(orderVo.getProduct_code())){//履约
			SpecialPerformanceVo_1 vo1 = insuranceOperationService.getSpecialPerformanceVo_1ByOrderID(oid);
			SpecialPerformanceVo_2 vo2 = insuranceOperationService.getSpecialPerformanceVo_2ByOrderID(oid);
			SpecialPerformanceVo_3 vo3 = insuranceOperationService.getSpecialPerformanceVo_3ByOrderID(oid);
			model.addAttribute("vo1",vo1);
			model.addAttribute("vo2",vo2);
			model.addAttribute("vo3",vo3);
			model.addAttribute("reg_policy", RegionUtils.getRegionNameByALLCode(vo1.getProvince(),vo1.getCity(),vo1.getArea_code()));
			if(vo2 != null&&vo2.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo2.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo2.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo2.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
			}
			return ORDER_LY_DETATIL;
		}else if(ConstProp.BZX_SSBQ.equals(orderVo.getProduct_code())){//诉讼
			SpecialLitigationVo_1 vo1 = insuranceOperationService.getSpecialLitigationVo_1ByOrderID(oid);
			SpecialLitigationVo_2 vo2 = insuranceOperationService.getSpecialLitigationVo_2ByOrderID(oid);
			SpecialLitigationVo_3 vo3 = insuranceOperationService.getSpecialLitigationVo_3ByOrderID(oid);
			model.addAttribute("vo1",vo1);
			model.addAttribute("vo2",vo2);
			model.addAttribute("vo3",vo3);
			model.addAttribute("reg_policy", RegionUtils.getRegionNameByALLCode(vo1.getProvince(),vo1.getCity(),vo1.getArea_code()));
			if(vo1 != null&&vo1.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo1.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo1.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
			}
			return ORDER_SS_DETATIL;
		}else if(ConstProp.GZX.equals(orderVo.getProduct_code().split("-")[ConstProp.INT_NUMBER_ZERO])) {//公责险

			SpecialPublicDutyVo vo = insuranceOperationService.getSpecialPublicDutyVoByOrderID(oid);
			List<NatureLinkage> natureList = NatureLinkage.doList();
			model.addAttribute("vo",vo);
			model.addAttribute("comTypeList", IdType.comList());
			model.addAttribute("natureList",natureList);
			if(vo != null&&vo.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
				model.addAttribute("reg_role_1", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_district()));
			}
			return ORDER_GZX_DETATIL;
		}else if(ConstProp.ZZX.equals(orderVo.getProduct_code().split("-")[ConstProp.INT_NUMBER_ZERO])) {//公责险
			LOTEPolicyVo vo = insuranceOperationService.getLOTEPolicyVoByOrderID(oid);
			List<NatureLinkage> natureList = NatureLinkage.doList();
			model.addAttribute("vo",vo);
			model.addAttribute("comTypeList", IdType.comList());
			model.addAttribute("natureList",natureList);
			if(vo != null&&vo.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
				model.addAttribute("reg_role_1", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_district()));
			}
			if(vo != null&&vo.getSpecialExhibitionVo() != null){
				model.addAttribute("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));
			}
			return ORDER_LOTE_DETATIL;
		}else if(ConstProp.TYX.equals(orderVo.getProduct_code().split("-")[ConstProp.INT_NUMBER_ZERO])){
			if(order != null){
				GMRPolicyVo vo = insuranceOperationService.getGMRPolicyVoByOrderID(oid);
				List<NatureLinkage> natureList = NatureLinkage.doList();
				List<IdType> typeList = IdType.doList();
				List<ResponsibilityVo> irpVoList = insProductResponsibilityService.findResponsibilityVoList(orderVo.getProduct_oid());
				model.addAttribute("vo",vo);
				model.addAttribute("irpVoList",irpVoList);
				model.addAttribute("typeList",typeList);
				model.addAttribute("natureList",natureList);
				if(vo != null&&vo.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
					model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
				}
				if(vo!= null&&vo.getSpecialExhibitionVo()!= null){
					model.addAttribute("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));
				}
				return ORDER_GMR_DETATIL;
			}
		}else if(ConstProp.GZZRX.equals(orderVo.getProduct_code().split("-")[ConstProp.INT_NUMBER_ZERO])){
			if(order != null){
				SpecialHirelingVo vo = insuranceOperationService.getSpecialHirelingVoByOrderID(oid);
				List<NatureLinkage> natureList = NatureLinkage.doList();
				List<IdType> typeList = IdType.doList();
				model.addAttribute("vo",vo);
				model.addAttribute("typeList",typeList);
				model.addAttribute("natureList",natureList);
				if(vo != null&&vo.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
					model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
					model.addAttribute("reg_role_1", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ONE).getReg_district()));
				}
				return ORDER_GZZRX_DETATIL;
			}
		}else if(ConstProp.GYX.equals(orderVo.getProduct_code().split("-")[ConstProp.INT_NUMBER_ZERO])){
			GYXPolicyVo vo = insuranceOperationService.getGYXPolicyVoByOrderID(oid);
			List<IdType> typeList = IdType.doList();
			List<ResponsibilityVo> irpVoList = insProductResponsibilityService.findResponsibilityVoList(orderVo.getProduct_oid());
			model.addAttribute("vo",vo);
			model.addAttribute("typeList",typeList);
			model.addAttribute("irpVoList",irpVoList);
			if(vo != null&&vo.getRoleSubjectList().size()>ConstProp.INT_NUMBER_ZERO){
				model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_province(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_city(),vo.getRoleSubjectList().get(ConstProp.INT_NUMBER_ZERO).getReg_district()));
			}
			return ORDER_GYX_DETATIL;
		}
		return null;

	}

	/**
	 * <b> 在保人员列表页 </b>
	 * @author ZXF
	 * @create 2019/09/29 0029 15:07
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/underWarrantyList/{oid}")
	public String underWarrantyList(@PathVariable Long oid, ModelMap model, HttpServletRequest request) {
		model.addAttribute("oid", oid);
		return UNDER_WARRANTY_LIST;
	}

	/**
	 * <b> 在保人员数据 </b>
	 * @author ZXF
	 * @create 2019/09/29 0029 15:07
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/underWarrantyList_table")
	public @ResponseBody Object underWarrantyList_table(@RequestParam Map<Object, Object> params){
		Map<Object,Object> p = CTLUtil.init(getRequest(),params);
		CTLUtil.out(preseverApplyService.queryResultSet(p), getResponse());
		return null;
	}

	@RequestMapping("/down_result_set/{oid}")
	public void downResultSet(@PathVariable Long oid, HttpServletResponse resp) {
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		if(orderVo != null&&StringUtils.isNotEmpty(orderVo.getExternal_reference())){
			Map<Object,Object> p = Maps.newHashMap();
			p.put("ins_insurance_slip_id",oid);
			p.put("external_reference",orderVo.getExternal_reference());
			preseverApplyService.downResultSet(p,resp);
		}
	}

	private String idTypeSet(String value){
		if ( "0".equals(value) ) {
			return "身份证";
		} else if ("1".equals(value)) {
			return "组织机构代码证";
		}else if ("2".equals(value)) {
			return "三证合一统一信用代码";
		}else if ("3".equals(value)) {
			return "护照";
		}else if ("4".equals(value)) {
			return "台胞证";
		}else if ("5".equals(value)) {
			return "返乡证";
		}else if ("6".equals(value)) {
			return "税务登记证";
		}else if ("7".equals(value)) {
			return "营业执照";
		}
		return "其他";
	}

	private String natureLinkageSet(String value){
		if ( "0".equals(value) ) {
			return "机关";
		} else if ("1".equals(value)) {
			return "事业单位";
		}else if ("2".equals(value)) {
			return "社会团体";
		}else if ("3".equals(value)) {
			return "国有企业";
		}else if ("4".equals(value)) {
			return "民营企业";
		}else if ("5".equals(value)) {
			return "外资企业";
		}else if ("6".equals(value)) {
			return "国有独资";
		}else if ("7".equals(value)) {
			return "国有控股";
		}else if ("8".equals(value)) {
			return "国有联营";
		}else if ("9".equals(value)) {
			return "私营企业";
		}else if ("10".equals(value)) {
			return "乡镇企业";
		}else if ("11".equals(value)) {
			return "个体企业";
		}else if ("12".equals(value)) {
			return "外商独资";
		}else if ("13".equals(value)) {
			return "中外合资";
		}else if ("14".equals(value)) {
			return "中外合作";
		}
		return "其他";
	}

	/**
	 * <b>根据订单号跳转核保界面 </b>
	 *
	 * @param oid
	 * @param model
	 * @return
	 * @author ZXF
	 * @date 2017年1月17日 下午2:36:23
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:underwriting:view")
	@RequestMapping("/initOrderAudit/{oid}")
	public String initOrderAudit(@PathVariable Long oid, ModelMap model) {
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		if(orderVo != null){
			InsInsuranceSlip insOrderForm = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(orderVo.getOid()));
			ProPrimary insProduct = insProductService.getProduct(Long.parseLong(orderVo.getProduct_oid()));
			ProPrimaryExpire insProductgg = insProductggService.getInsProductggByInsProductID(insProduct.getPro_primary_id());
			UnderwriteVo underwriteVo = insUnderwriteService.accordingToInsUnderwriteIntoUnderwriteVo(insOrderForm.getUnderwrite());
			model.addAttribute("insProductgg", insProductgg);
			model.addAttribute("underwriteVo", underwriteVo);//承保Vo
			model.addAttribute("insProduct", insProduct);
			model.addAttribute("orderVo",orderVo);
			return ORDER_ACCEPT_INSURANCE;
		}
		return null;

	}

	/**
	 * 诉讼核保查询详情  承保查询
	 * @param oid
	 * @param model
	 * @return
	 */
	@RequiresPermissions(value = {"orderForm:list:underwriting:view","orderForm:list:underwrite:view"},logical= Logical.OR)
    @RequestMapping("/initOrderAuditLitigation/{oid}/{type}")
    public String initOrderAuditLitigation(@PathVariable Long oid,@PathVariable String type, ModelMap model) throws InvocationTargetException, IntrospectionException, IllegalAccessException, NoSuchFieldException {
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		OrderFormDetailsVo vo = insOrderFormDetailsVoService.selectInsTransactionByInsOrderFormVo(oid);
		SpecialLitigationVo_1 vo1 = insuranceOperationService.getSpecialLitigationVo_1ByOrderID(oid);
		SpecialLitigationVo_2 vo2 = insuranceOperationService.getSpecialLitigationVo_2ByOrderID(oid);
		SpecialLitigationVo_3 vo3 = insuranceOperationService.getSpecialLitigationVo_3ByOrderID(oid);
		model.addAttribute("vo", vo);
		model.addAttribute("vo1",vo1);
		model.addAttribute("vo2",vo2);
		model.addAttribute("vo3",vo3);
		model.addAttribute("orderVo", orderVo);
		model.addAttribute("underwrite", vo.getInsUnderwrite());
		if(vo1.getRoleSubjectList().size()>0){
			model.addAttribute("reg_role", RegionUtils.getRegionNameByALLCode(vo1.getRoleSubjectList().get(0).getReg_province(),vo1.getRoleSubjectList().get(0).getReg_city(),vo1.getRoleSubjectList().get(0).getReg_district()));
		}
		if("1".equals(type)) {
			return ORDER_ACCEPT_INSURANCE_LITIGATION;
		}else{
			List<InsTransaction> tranList = insuranceOperationService.accordingToOrderIDToGetInsTransaction(oid);
			model.addAttribute("transaction", (tranList!=null && !tranList.isEmpty())?tranList.get(0):new InsTransaction());
			return ORDER_UNDERWRITING_LITIGATION;
		}
    }

	/**
	 * 诉讼核保查询详情  承保查询
	 * @param oid
	 * @param model
	 * @return
	 */
	@RequiresPermissions(value = {"orderForm:list:underwriting:view","orderForm:list:underwrite:view"},logical= Logical.OR)
    @RequestMapping("/initOrderAuditPG/{oid}/{type}")
    public String initOrderAuditPG(@PathVariable Long oid,@PathVariable String type, ModelMap model) throws InvocationTargetException, IntrospectionException, IllegalAccessException, NoSuchFieldException {
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		OrderFormDetailsVo vo = insOrderFormDetailsVoService.selectInsTransactionByInsOrderFormVo(oid);
		SpecialPerformanceVo_1 vo1 = insuranceOperationService.getSpecialPerformanceVo_1ByOrderID(oid);
		SpecialPerformanceVo_2 vo2 = insuranceOperationService.getSpecialPerformanceVo_2ByOrderID(oid);
		SpecialPerformanceVo_3 vo3 = insuranceOperationService.getSpecialPerformanceVo_3ByOrderID(oid);
		model.addAttribute("vo1",vo1);
		model.addAttribute("vo2",vo2);
		model.addAttribute("vo3",vo3);
		model.addAttribute("vo", vo);
		model.addAttribute("orderVo", orderVo);
		model.addAttribute("underwrite", vo.getInsUnderwrite());
		if("1".equals(type)) {
			return ORDER_ACCEPT_INSURANCE_PG;
		}else{
			List<InsTransaction> tranList = insuranceOperationService.accordingToOrderIDToGetInsTransaction(oid);
			model.addAttribute("transaction", (tranList!=null && !tranList.isEmpty())?tranList.get(0):new InsTransaction());
			return ORDER_UNDERWRITING_PG;
		}
    }

    /**
     * <b> 订单复制 </b>
     * @author ZXF
     * @create 2019/08/14 0014 14:40
     * @version
     * @注意事项 </b>
     */
	@RequiresPermissions("orderForm:list:underwriting:edit")
	@RequestMapping("/copyPolicy/{oid}")
	@ResponseBody
	public AjaxResult copyPolicy(@PathVariable Long oid) {
		return insuranceOperationService.copyPolicy(oid);
	}


	/**
	 * <b>核保数据更新 </b>
	 *
	 * @param vo
	 * @param order_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月17日 下午3:38:58
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:underwriting:edit")
	@RequestMapping(value = "/updateOrderAudit", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult updateOrderAudit(HttpServletRequest request, @ModelAttribute("vo") UnderwriteVo vo, @ModelAttribute("order_id") Long order_id){
		String signOperate = request.getParameter("signOperate");
		return insuranceOperationService.updateOrderAudit(signOperate,vo,order_id);
	}

	/**
	 *
	 * <b>拒保操作，记录拒保原因及变更订单状态 </b>
	 *
	 * @param request
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年2月6日 下午1:28:56
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:declinature:edit")
	@RequestMapping(value = "/orderAuditFail", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult orderAuditFail(HttpServletRequest request, @ModelAttribute("order_id") Long order_id){
		if(order_id != null){
			String ty = request.getParameter("ty");
			String remarks = request.getParameter("remarks");
			if(StringUtils.isEmpty(remarks)){
				return fail(false, "请填写拒保理由!");
			}
			if(StrUtil.isNotBlank(insuranceOperationService.orderAuditFail(ty,remarks,order_id))){
				return success(true, "拒保操作成功!");
			}else{
				return fail(false, "拒保操作失败!");
			}
		}else{
			return fail(false, "数据丢失!");
		}
	}

	/**
	 *
	 * <b>删除订单(暂未用到) </b>
	 *
	 * @param request
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年2月6日 下午1:28:56
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:delete")
	@RequestMapping(value = "/orderDelete", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult orderDelete(HttpServletRequest request, @ModelAttribute("order_id") Long order_id){
		if(order_id != null){
			InsInsuranceSlip order = insInsuranceSlipService.getInsOrderForm(order_id);
			order.setOrder_status(DictConst.ORDER_STATUS_YFQ);
			if(insInsuranceSlipService.updateById(order)){
				return json(true, "删除操作成功!");
			}else{
				return fail(false, "删除操作失败!");
			}
		}else{
			return fail(false, "数据丢失!");
		}
	}

	/**
	 * <b>根据订单号跳转承保界面 </b>
	 *
	 * @param oid
	 * @param model
	 * @return
	 * @author ZXF
	 * @date 2017年1月17日 下午2:36:23
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:underwrite:view")
	@RequestMapping("/initOrderUnderwriting/{oid}")
	public String initOrderUnderwriting(@PathVariable Long oid, ModelMap model) {
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		if(orderVo != null){
			//TODO 可优化点，查询InsInsuranceSlip调用的方法可优化
			InsInsuranceSlip insOrderForm = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(orderVo.getOid()));
			UnderwriteVo underwriteVo = insUnderwriteService.accordingToInsUnderwriteIntoUnderwriteVo(insOrderForm.getUnderwrite());
			model.addAttribute("orderVo",orderVo);
			model.addAttribute("underwriteVo", underwriteVo);
			return ORDER_UNDERWRITING;
		}
		return null;
	}

	/**
	 * <b>承保数据更新并变更状态 </b>
	 *
	 * @param
	 * @param
	 * @return
	 * @author ZXF
	 * @date 2017年1月17日 下午3:39:11
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:underwrite:edit")
	@RequestMapping(value = "/updateOrderUnderwriting", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult updateOrderUnderwriting(@ModelAttribute("orderFormVo") OrderFormVo orderFormVo,HttpServletRequest request){
		String signOperate = request.getParameter("signOperate");
		String out_of_pocket = request.getParameter("out_of_pocket");
		String acceptanceTime = request.getParameter("acceptance_time");
		String underwritingOid = request.getParameter("underwritingOid");
		return insuranceOperationService.updateOrderUnderwriting( orderFormVo, underwritingOid, acceptanceTime, out_of_pocket, signOperate);
	}

	/**
	 * <b>根据订单号查看支付详情 </b>
	 *
	 * @param oid
	 * @param model
	 * @return
	 * @author ZXF
	 * @date 2017年1月17日 下午2:36:23
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:payment:view")
	@RequestMapping("/initTransactionDetail/{oid}")
	public String initTransactionDetail(@PathVariable Long oid, ModelMap model) {
		OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(oid);
		if(orderVo != null){
			List<InsTransaction> transactionList = insuranceOperationService.accordingToOrderIDToGetInsTransaction(oid);
			model.addAttribute("orderVo",orderVo);
			model.addAttribute("transactionList",transactionList);
			return TRANSACTION_DETATIL;
		}
		return null;

	}

	/**
	 * <b>承保数据更新 </b>
	 *
	 * @param
	 * @param
	 * @return
	 * @author ZXF
	 * @date 2017年1月17日 下午3:39:11
	 * @注意事项 </b>
	 * <b>
	 */
	@RequiresPermissions("orderForm:list:payment:edit")
	@RequestMapping(value = "/updateTransactionPayOrderNumber", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult updateTransactionPayOrderNumber(HttpServletRequest request){
		String order_id = request.getParameter(ConstProp.ORDER_ID);
		String[] payOrderNumbers = request.getParameterValues("pay_order_number");
		return insuranceOperationService.updateTransactionPayOrderNumber( payOrderNumbers, order_id);
	}

	/**
	 * <b>保单退保 </b>
	 *
	 * @param request
	 * @param order_id 订单id
	 * @author ZXF
	 * @create 2020/01/10 0010 14:04
	 * @version
	 * @注意事项 </b>
	 */
	@RequiresPermissions("orderForm:list:surrender")
	@RequestMapping(value = "/surrender", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult surrender(SurrenderVo surrenderVo, HttpServletRequest request){
		return insuranceOperationService.surrender(surrenderVo,request);
	}

	/**
	 * <b> 修改联系人信息 </b>
	 * @author ZXF
	 * @create 2020/01/17 0017 19:57
	 * @version
	 * @注意事项 </b>
	 */
	@RequiresPermissions("orderForm:list:payment:edit")
	@RequestMapping(value = "/updateInsRolePolicyLink", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult updateInsRolePolicyLink(ParamVo paramVo){
		return insuranceOperationService.updateInsRolePolicyLink(paramVo);
	}

   /**
     * <b>获取PSS订单列表 </b>
     */
   @RequiresPermissions("orderForm:list:pss:view")
    @RequestMapping("/findOrderList/pss")
    public String findOrderListPss(ModelMap model) {
        return PSS_ORDER_LIST;
    }
	/**
	 * <b>获取ARS订单列表 </b>
	 */
	@RequiresPermissions("orderForm:list:ars:view")
	@RequestMapping("/findOrderList/ars")
	public String findOrderListArs(ModelMap model) {
		return ARS_ORDER_LIST;
	}
	/**
	 *  Pss订单详情查询
	 */
	@RequestMapping("/getOrderPssObject/pss/{oid}")
	public String getOrderPssObject(@PathVariable Long oid, Model model){
		return PSS_ORDER_MANAGER;
	}

	/**
	 *  ARS订单详情查询
	 */
	@RequestMapping("/getOrderPssObject/ars/{oid}")
	public String getOrderArsObject(@PathVariable Long oid, Model model){
		return ARS_ORDER_MANAGER;
	}
}
