package com.bcxin.ins.models.order.policy.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.TokenUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;


/**
 * <b> 客户管理系统用外嵌业务 </b>
 * @author ZXF
 * @create 2024/02/03 0003 14:09
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping(value = "${apiPath}/customerManagement")
public class CustomerManagementActionController extends BaseController {

	/**
	 * <b> 保险保单列表查询 </b>
	 * @author ZXF
	 * @create 2024/02/03 0003 14:10
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/policy/order")
	public String policyOrder() {
		String bcxToken = getRequest().getParameter("bcxToken");
		String account = TokenUtils.getAccountFromBcxToken(bcxToken);
		String sup_id = "sup_admin";
		if (StringUtils.isBlank(account)) {
			sup_id = "error";
		}
		return "forward:/api/myPolicy/findOrderList/"+sup_id;
	}

	/**
	 * <b> 保险保全列表查询 </b>
	 * @author ZXF
	 * @create 2024/02/03 0003 14:10
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/policy/record")
	public String policyRecord() {
		String bcxToken = getRequest().getParameter("bcxToken");
		String account = TokenUtils.getAccountFromBcxToken(bcxToken);
		String sup_id = "sup_admin";
		if (StringUtils.isBlank(account)) {
			sup_id = "error";
		}
		return "forward:/api/myApply/findApplyList/"+sup_id;
	}

	/**
	 * <b> 保险保全账单列表查询 </b>
	 * @author ZXF
	 * @create 2024/02/03 0003 14:10
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/policy/record/bill")
	public String policyRecordBill() {
		String bcxToken = getRequest().getParameter("bcxToken");
		String account = TokenUtils.getAccountFromBcxToken(bcxToken);
		String sup_id = "sup_admin";
		if (StringUtils.isBlank(account)) {
			sup_id = "error";
		}
		return "forward:/api/myApply/findPayList/"+sup_id;
	}

}
