package com.bcxin.ins.models.order.policy.service.impl;


import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.models.order.policy.dao.SpecialPublicDutyDao;
import com.bcxin.ins.models.order.policy.service.SpecialPublicDutyService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <b>公责险特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class SpecialPublicDutyServiceImpl extends ServiceImpl<SpecialPublicDutyDao, SpecialPublicDuty> implements SpecialPublicDutyService {

	@Autowired
	private SpecialPublicDutyDao dao;

	public SpecialPublicDuty initSpecialPublicDuty(){
		SpecialPublicDuty specialPublicDuty = new SpecialPublicDuty();//
		dao.insert(specialPublicDuty);
		return specialPublicDuty;
	}

	/**
	 * <b>根据Vo及公责险ID更新SpecialPublicDuty数据 </b>
	 *
	 * @param vo
	 * @param afrID 公责险id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheSpecialPublicDutyVoSetUpSpecialPublicDuty(SpecialPublicDutyVo vo, Long afrID){
		SpecialPublicDuty specialPublicDuty = dao.selectById(afrID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), specialPublicDuty);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(specialPublicDuty);
	}

	/**
	 * <b>获取SpecialPublicDutyVo根据公责险id查询公责险信息插入到SpecialPublicDutyVo </b>
	 *
	 * @param vo 公责险辅助表
	 * @param afrID 公责险id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getSpecialPublicDutyVoByPolicyID(SpecialPublicDutyVo vo, Long afrID){
		SpecialPublicDuty specialPublicDuty = dao.selectById(afrID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialPublicDuty), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
