package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.SpecialPerformance;
import com.bcxin.ins.models.order.policy.dao.SpecialPerformanceDao;
import com.bcxin.ins.models.order.policy.service.SpecialPerformanceService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <b>企业短期特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class SpecialPerformanceServiceImpl extends ServiceImpl<SpecialPerformanceDao, SpecialPerformance> implements SpecialPerformanceService {

	@Autowired
	private SpecialPerformanceDao dao;
	

	/**
	 * <b>履约特殊字段表信息 </b> TODO 联动关联表已封装，待测试
	 *
	 * @param oid InsSpecialPerformanceID
	 * @author ZXF
	 * @date 2017年1月5日 下午4:50:12
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialPerformance getInsSpecialPerformanceBusiness(Long oid){
		return dao.selectById(oid);
	}

	/**
	 * <b>初始化履约特殊字段表信息 </b>
	 *
	 * @author ZXF
	 * @date 2017年1月5日 下午4:50:12
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialPerformance initInsSpecialPerformance(){
		SpecialPerformance insSpecialPerformance = new SpecialPerformance();
		dao.insert(insSpecialPerformance);
		return insSpecialPerformance;
	}


	/**
	 * <b>获取SpecialPerformanceVo_1根据履约id查询企业短期信息插入到SpecialPerformanceVo_1 </b>
	 *
	 * @param vo 履约辅助表
	 * @param ceID 履约id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getSpecialPerformanceVo_1BySpecial_id(SpecialPerformanceVo_1 vo, Long ceID){
		SpecialPerformance insSpecialPerformance = getInsSpecialPerformanceBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insSpecialPerformance), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * <b>获取SpecialPerformanceVo_2根据履约id查询企业短期信息插入到SpecialPerformanceVo_2 </b>
	 *
	 * @param vo 履约辅助表
	 * @param ceID 履约id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getSpecialPerformanceVo_2BySpecial_id(SpecialPerformanceVo_2 vo, Long ceID){
		SpecialPerformance insSpecialPerformance = getInsSpecialPerformanceBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insSpecialPerformance), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b>获取SpecialPerformanceVo_3根据履约id查询企业短期信息插入到SpecialPerformanceVo_3 </b>
	 *
	 * @param vo 履约辅助表
	 * @param ceID 履约id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialPerformanceVo_3BySpecial_id(SpecialPerformanceVo_3 vo, Long ceID) {
		SpecialPerformance insSpecialPerformance = getInsSpecialPerformanceBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insSpecialPerformance), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b>根据Vo及履约ID更新SpecialPerformanceVo_1数据 </b>
	 *
	 * @param vo
	 * @param special_id 履约id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialPerformanceVo_1SetUpInsSpecialPerformance(
			SpecialPerformanceVo_1 vo, Long special_id) {
		SpecialPerformance insSpecialPerformance = getInsSpecialPerformanceBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insSpecialPerformance);
		} catch (Exception e) {
			e.printStackTrace();
		}

		dao.updateById(insSpecialPerformance);

	}

	/**
	 * <b>根据Vo及履约ID更新SpecialPerformanceVo_2数据 </b>
	 *
	 * @param vo
	 * @param special_id 履约id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialPerformanceVo_2SetUpInsSpecialPerformance(
			SpecialPerformanceVo_2 vo, Long special_id) {
		SpecialPerformance insSpecialPerformance = getInsSpecialPerformanceBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insSpecialPerformance);
		} catch (Exception e) {
			e.printStackTrace();
		}

		dao.updateById(insSpecialPerformance);

	}

	/**
	 * <b>根据Vo及履约ID更新SpecialPerformanceVo_3数据 </b>
	 *
	 * @param vo
	 * @param special_id 履约id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialPerformanceVo_3SetUpInsSpecialPerformance(
			SpecialPerformanceVo_3 vo, Long special_id) {
		SpecialPerformance insSpecialPerformance = getInsSpecialPerformanceBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insSpecialPerformance);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insSpecialPerformance);

	}


}
