package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsShipInvoices;
import com.bcxin.ins.models.order.policy.service.ShipInvoicesService;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.bcxin.ins.models.order.policy.dao.ShipInvoicesDao;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * 发票Service
 * @author liumd
 * @date 2016年12月30日
 */
@Service
@Transactional
public class ShipInvoicesServiceImpl extends ServiceImpl<ShipInvoicesDao, InsShipInvoices> implements ShipInvoicesService {

	@Autowired
	private ShipInvoicesDao shipInvoicesDao;

	@Override
	public InsShipInvoices getShipInvoicesById(Long id) {
		List<InsShipInvoices> lis = shipInvoicesDao.getShipInvoicesById(id);
		return lis.size() > 0 ? lis.get(0) : null;
	}

	@Override
	public List<InsShipInvoices> getShipInvoicesByShipDeclareId(Long shipDeclareId) {
		List<InsShipInvoices> lis = shipInvoicesDao.getShipInvoicesByShipDeclareId(shipDeclareId);
		return lis.size() > 0 ? lis : null;
	}

	@Override
	public List<InsShipInvoices> getShipInvoicesByShipExpireId(Long shipExpireId) {
		List<InsShipInvoices> lis = shipInvoicesDao.getShipInvoicesByShipExpireId(shipExpireId);
		return lis.size() > 0 ? lis : null;
	}

	
}
