package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsShipExpire;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.bcxin.ins.models.order.policy.dao.ShipExpireDao;
import com.bcxin.ins.models.order.policy.service.ShipExpireService;

import java.util.List;


/**
 * 逾期Service
 * @author liumd
 * @date 2016年12月30日
 */
@Service
@Transactional
public class ShipExpireServiceImpl extends ServiceImpl<ShipExpireDao, InsShipExpire> implements ShipExpireService {
	
	@Autowired
	private ShipExpireDao shipExpireDao;

	@Override
	public InsShipExpire getShipExpireById(Long id) {
		List<InsShipExpire> lis = shipExpireDao.getShipExpireById(id);
		return lis.size() > 0 ? lis.get(0) : null;
	}

	@Override
	public InsShipExpire getShipExpireByShipDeclareId(Long shipDeclareId) {
		List<InsShipExpire> lis = shipExpireDao.getShipExpireByShipDeclareId(shipDeclareId);
		return lis.size() > 0 ? lis.get(0) : null;
	}

	
}
