package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.base.service.impl.BaseServiceImpl;
import com.bcxin.ins.entity.policy_core.InsRoleFavoree;
import com.bcxin.ins.models.order.policy.dao.InsRoleFavoreeDao;
import com.bcxin.ins.models.order.policy.service.InsRoleFavoreeService;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * <b>受益人业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsRoleFavoreeServiceImpl extends ServiceImpl<InsRoleFavoreeDao, InsRoleFavoree> implements InsRoleFavoreeService {

	@Autowired
	private InsRoleFavoreeDao insRoleFavoreeDao;
	
	/**
	 * <b>根据投保人信息人表id查询受益人信息表 </b> 
	 * 
	 * @param oid 投保人信息人表id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 下午4:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsRoleFavoree> selectInsRoleFavoreeByInsRoleInpolicy(Long oid){
		return insRoleFavoreeDao.selectInsRoleFavoreeByInsRoleInpolicy(oid);
	}
}
