package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StOverdueDetail;
import com.bcxin.ins.models.order.policy.dao.InsOverdueDetailDao;
import com.bcxin.ins.models.order.policy.service.InsOverdueDetailService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OverdueDetailVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsOverdueDetailServiceImpl extends ServiceImpl<InsOverdueDetailDao, StOverdueDetail> implements InsOverdueDetailService {

	@Autowired
	private InsOverdueDetailDao dao;
	/**
	 * <b>通过账龄及坏账分析id查询所有逾期详细信息 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	public List<StOverdueDetail> selectInsOverdueDetailByInsBadDebt(Long oid){
		return dao.selectInsOverdueDetailByInsBadDebt(oid);
	}
	
	/**
	 * <b>根据Vo及账龄及坏账分析表ID更新InsOverdueDetail数据 </b> 
	 * 
	 * @param vo
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheOverdueDetailVoSetUpInsOverdueDetail(OverdueDetailVo vo, Long bad_debt_id){
		StOverdueDetail insOverdueDetail = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insOverdueDetail = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insOverdueDetail = new StOverdueDetail();
			insOverdueDetail.getBad_debt().setSt_bad_debt_id(bad_debt_id);
			dao.insert(insOverdueDetail);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insOverdueDetail);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insOverdueDetail);
	}
	
	/**
	 * <b>接收页面传回的逾期详细信息信息列表进行更新 </b> 
	 * 
	 * @param voList 逾期详细信息信息列表
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void setOverdueDetailByOverdueDetailVo(List<OverdueDetailVo> voList, Long bad_debt_id){
		if(voList != null && voList.size()> ConstProp.INT_NUMBER_ZERO){
			ruleOutDoesNotExist(voList, bad_debt_id);
			for(OverdueDetailVo vo : voList){
				accordingToTheOverdueDetailVoSetUpInsOverdueDetail(vo,bad_debt_id);
			}
		}
	}
	
	/**
	 * <b>排除数据库存在的但页面被删除的条目信息，获取这些条目并删除 </b> 
	 * 
	 * @param voList
	 * @param bad_debt_id
	 * @author ZXF 
	 * @date 2017年1月13日 上午10:59:02
	 * @注意事项 </b>
	 * <b>
	 */
	private void ruleOutDoesNotExist(List<OverdueDetailVo> voList,
			Long bad_debt_id) {
		List<StOverdueDetail> iodList = selectInsOverdueDetailByInsBadDebt(bad_debt_id);
		for(StOverdueDetail iod : iodList){
			int i = ConstProp.INT_NUMBER_ZERO;
			for(OverdueDetailVo vo : voList){
				if(StrUtil.isNotBlank(vo.getOid())){
					if(iod.getSt_overdue_detail_id() == Long.parseLong(vo.getOid())){
						i = ConstProp.INT_NUMBER_ONE;
					}
				}
			}
			if(i == ConstProp.INT_NUMBER_ZERO){
				dao.deleteById(iod.getSt_overdue_detail_id());
			}
		}
	}
	
	/**
	 * <b>将逾期详细信息类插入到OverdueDetailVo集合 </b> 
	 * 
	 * @param odList 逾期详细信息列表
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public List<OverdueDetailVo> getOverdueDetailVoListByInsOverdueDetailList(List<StOverdueDetail> odList){
		List<OverdueDetailVo> voList = new ArrayList<OverdueDetailVo>();
		if(odList != null && odList.size()>ConstProp.INT_NUMBER_ZERO){
			for(StOverdueDetail od : odList){
				voList.add(accordingToInsOverdueDetailIntoOverdueDetailVo(od));
			}
		}
		return voList;
	}
	
	/**
	 * <b>根据逾期详细信息转换成 OverdueDetailVo</b> 
	 * 
	 * @param od 逾期详细信息
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	public OverdueDetailVo accordingToInsOverdueDetailIntoOverdueDetailVo(StOverdueDetail od){
		OverdueDetailVo vo = new OverdueDetailVo();
		if(od != null){
			vo.setOid(String.valueOf(od.getSt_overdue_detail_id()));
			try {
				MyConverUtil.map2PO(MyConverUtil.PO2Map(od), vo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return vo;
	}
}
