package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StDebtAges;
import com.bcxin.ins.models.order.policy.dao.InsDebtAgesDao;
import com.bcxin.ins.models.order.policy.service.InsDebtAgesService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DebtAgesVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsDebtAgesServiceImpl extends ServiceImpl<InsDebtAgesDao, StDebtAges> implements InsDebtAgesService {
	@Autowired
	private InsDebtAgesDao dao;
	/**
	 * <b>通过账龄及坏账分析id查询所有账龄及坏账分析周期 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	public List<StDebtAges> selectInsDebtAgesByInsBadDebt(Long oid){
		return dao.selectInsDebtAgesByInsBadDebt(oid);
	}
	
	/**
	 * <b>根据Vo及账龄及坏账分析表ID更新InsDebtAges数据 </b> 
	 * 
	 * @param vo
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheDebtAgesVoSetUpInsDebtAges(DebtAgesVo vo, Long bad_debt_id){
		StDebtAges insDebtAges = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insDebtAges = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insDebtAges = new StDebtAges();
			insDebtAges.getBad_debt().setSt_bad_debt_id(bad_debt_id);
			dao.insert(insDebtAges);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insDebtAges);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insDebtAges);
	}
	
	/**
	 * <b>接收页面传回的账龄及坏账分析周期信息信息列表进行更新 </b> 
	 * 
	 * @param voList 账龄及坏账分析周期信息信息列表
	 * @param bad_debt_id 账龄及坏账分析表id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void setDebtAgesByDebtAgesVo(List<DebtAgesVo> voList, Long bad_debt_id){
		if(voList != null && voList.size()>0){
			for(DebtAgesVo vo : voList){
				accordingToTheDebtAgesVoSetUpInsDebtAges(vo,bad_debt_id);
			}
		}
	}
	
	/**
	 * <b>将账龄及坏账分析周期类插入到DebtAgesVo集合 </b> 
	 * 
	 * @param daList 账龄及坏账分析周期表
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public List<DebtAgesVo> getDebtAgesVoListByInsDebtAgesList(List<StDebtAges> daList){
		List<DebtAgesVo> voList = new ArrayList<DebtAgesVo>();
		if(daList != null && daList.size()> ConstProp.INT_NUMBER_ZERO){
			for(StDebtAges da : daList){
				voList.add(accordingToInsDebtAgesIntoDebtAgesVo(da));
			}
		}
		return voList;
	}
	
	/**
	 * <b>根据账龄及坏账分析周期转换成 DebtAgesVo</b> 
	 * 
	 * @param da 账龄及坏账分析周期
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	public DebtAgesVo accordingToInsDebtAgesIntoDebtAgesVo(StDebtAges da){
		DebtAgesVo vo = new DebtAgesVo();
		if(da == null){
			return vo;
		}
		vo.setOid(String.valueOf(da.getSt_debt_ages_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(da), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}
}
