package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.base.service.impl.BaseServiceImpl;
import com.bcxin.ins.entity.policy_special.StCreditManagement;
import com.bcxin.ins.models.order.policy.dao.InsCreditManagementDao;
import com.bcxin.ins.models.order.policy.service.InsCreditManagementService;
import com.bcxin.ins.models.order.policy.service.InsManagerDetailService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;



@Service
@Transactional
public class InsCreditManagementServiceImpl extends ServiceImpl<InsCreditManagementDao, StCreditManagement> implements InsCreditManagementService {


	@Autowired
	private InsCreditManagementDao dao;
	@Autowired
	private InsManagerDetailService insManagerDetailService;
	
	/**
	 * <b>根据id查询 InsCreditManagement 及关联表封装</b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:46:29
	 * @注意事项 </b>
	 * <b>
	 */
	public StCreditManagement packagingInsCreditManagement(Long oid){
		StCreditManagement icm = dao.selectById(oid);
		if(icm != null){
			icm.setInsManagerDetail(insManagerDetailService.selectInsManagerDetailByInsCreditManagement(icm.getSt_credit_management_id()));
		}
		return icm;
	}

	@Override
	public StCreditManagement initInsCreditManagement() {
		StCreditManagement insCreditManagement = new StCreditManagement();
		dao.insert(insCreditManagement);
		return insCreditManagement;
	}
	
	/**
	 * <b>根据Vo及公司信用管理表ID更新InsCreditManagement数据 </b> 
	 * 
	 * @param vo
	 * @param creditManagementID 公司信用管理表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheCommonExportVo_3SetUpInsCreditManagement(CommonExportVo_3 vo, Long creditManagementID){
		StCreditManagement icm = dao.selectById(creditManagementID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), icm);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(icm);
	}
	
	/**
	 * <b>根据公司信用管理表信息转换成 CommonExportVo_3</b> 
	 * 
	 * @param icm 公司信用管理表
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToInsCreditManagementIntoCommonExportVo_3(CommonExportVo_3 vo, StCreditManagement icm){
		if(icm != null){
			try {
				MyConverUtil.map2PO(MyConverUtil.PO2Map(icm), vo);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
