package com.bcxin.ins.models.order.policy.dao;

import com.bcxin.ins.core.base.dao.BasDao;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>投保人/被保人信息表数据访问  </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface InsRoleInpolicyDao extends BaseMapper<InsRoleInpolicy> {

	public InsRoleInpolicy selectById(@Param("id") Long id);
	
	/**
	 * <b>根据投保单id查询投保单被保人列表 </b> 
	 * 
	 * @param oid 投保单id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 下午4:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsRoleInpolicy> selectInsRoleInpolicyByInsInsuranceSlip(@Param("oid") Long oid);

	/**
	 * <b>根据投保单id查询被保险人数量 </b>
	 *
	 * @param oid 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	public int countInsurancedByID(@Param("oid") Long oid);

	/**
	 * <b>根据订单id查询被保险人列表 </b>
	 *
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2017年4月14日 下午10:20:20
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsRoleInpolicy> getRoleInPolicyByOrderId(@Param("order_id") Long order_id, @Param("kind") String kind);

	/**
	 * <b> 修改投保人的联系人信息 </b>
	 * @author ZXF
	 * @create 2020/01/17 0017 20:05
	 * @version
	 * @注意事项 </b>
	 */
	public Integer updateInsRolePolicyLink(@Param("oid") String oid, @Param("name") String name, @Param("tel") String tel, @Param("email") String email);

	/**
	 * <b> 根据订单id查询投被保险人信息列表 </b>
	 * @author ZXF
	 * @create 2018/08/13 0013 10:29
	 * @version
	 * @注意事项 </b>
	 */
	List<RoleSubjectVo> selectRoleSubjectVoByInsInsuranceSlip(@Param("oid") Long oid);

	List<Map<String,String>> findPerson(@Param("order_id") Long order_id);
}
