package com.bcxin.ins.models.order.policy.dao;


import com.bcxin.ins.core.base.dao.BasDao;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;


/**
 * <b>全球买家表数据访问 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface InsBuyersDao extends BaseMapper<ComBuyers> {

	/**
	 * <b>通过3字段查询是否存在买家，如果没有新建 </b> 
	 * 
	 * @param name
	 * @param address
	 * @param country
	 * @return
	 * @author ZXF 
	 * @date 2017年1月7日 下午5:53:09
	 * @注意事项 </b>
	 * <b>
	 */
	public ComBuyers selectInsBuyersBySomeField(@Param("name") String name, @Param("address") String address, @Param("country") String country);

	/**
	 * <b>通过code 查询全球买家，如果没有 为空</b> 
	 * 
	 * @param code
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月16日 下午3:55:00
	 * @注意事项 </b>
	 * <b>
	 */
	public ComBuyers selectInsBuyersByCode(@Param("code") String code);
	
	
}
