package com.bcxin.ins.models.claim.service.impl;

import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.entity.policy_report.InsCommonReport;
import com.bcxin.ins.models.claim.dao.InsCommonReportDao;
import com.bcxin.ins.models.claim.service.*;
import com.bcxin.ins.models.order.policy.service.InsuranceOperationService;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.report_pac.*;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;


/**
 * <b>雇主责任险雇员特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsCommonReportServiceImpl extends ServiceImpl<InsCommonReportDao, InsCommonReport> implements InsCommonReportService {

	@Autowired
	private InsCommonReportDao dao;
	@Autowired
	private InsuranceOperationService insuranceOperationService;
	@Autowired
	private InsPaymentInfoService insPaymentInfoService;
	@Autowired
	private InsClaimInformationService insClaimInformationService;
	@Autowired
	private InsCaseScheduleService insCaseScheduleService;
	@Autowired
	private InsCaseInfoService insCaseInfoService;


	/**
	 * <b> 根据id查询报案结果 </b>
	 * @author ZXF
	 * @create 2019/11/19 0019 14:41
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public InsCommonReportVo getInsCommonReportVoById(Long oid){
		return dao.getInsCommonReportVoById(oid);
	}

	/**
	 * <b> 报案详情 </b>
	 * @author ZXF
	 * @create 2019/12/06 0006 14:08
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public InsCommonReportVo getInsCommonReportVoInfoById(Long oid){
		InsCommonReportVo insCommonReportVo = getInsCommonReportVoById(oid);
		if(insCommonReportVo == null){
			return insCommonReportVo;
		}
		OrderFormVo order = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(insCommonReportVo.getIns_insurance_slip_id()));
		InsPaymentInfoVo insPaymentInfoVo = insPaymentInfoService.getInsPaymentInfoVo(Long.parseLong(insCommonReportVo.getIns_payment_info_id()));
		insCommonReportVo.setInsPaymentInfoVo(insPaymentInfoVo);
		insClaimInformationService.getInsCommonReportVoByReportID(insCommonReportVo,oid);
		insCaseInfoService.getInsCommonReportVoByReportID(insCommonReportVo,oid);
		insCaseScheduleService.getInsCommonReportVoByReportID(insCommonReportVo,oid);
		String accident_address = RegionUtils.getRegionNameByALLCode(insCommonReportVo.getAccident_province_code()
				,insCommonReportVo.getAccident_city_code()
				,insCommonReportVo.getAccident_county_code())+insCommonReportVo.getAccident_place();
		insCommonReportVo.setAccident_address(accident_address);
		String sign = order==null?ConstProp.BLANK_CHAR:order.getProduct_code().contains(ConstProp.GZZRX_CA)?"CA":ConstProp.BLANK_CHAR;
		ReportCodeVo rcvo = new ReportCodeVo(sign);
		if("CA".equals(sign)){
			insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_1()));
		}else{
			if("0".equals(insCommonReportVo.getIs_sync())){
				insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_1())+"："+rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_2()));
			}else{
				insCommonReportVo.setAccident_cause_level(rcvo.getCxyyName(insCommonReportVo.getAccident_cause_level_2()));
			}
		}
		insCommonReportVo.setInjured_detail_content(setInj(insCommonReportVo.getInjured_detail()
				,insCommonReportVo.getOutpatient_list()
				,insCommonReportVo.getMaim_list()
				,insCommonReportVo.getDemise_list()));
		return insCommonReportVo;
	}

	/**
	 * <b> 修改理赔状态为结案 </b>
	 * @author ZXF
	 * @create 2020/04/02 0002 17:06
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void settleALawsuitByID(Long oid){
		dao.settleALawsuitByID(oid);
	}

	//组装人伤相关信息
	private String setInj(String injured_detail, String outpatient_list, String maim_list, String demise_list){
		String content = ConstProp.BLANK_CHAR;
		if(StringUtils.isEmpty(injured_detail)){
			return content;
		}
		String[] injs = injured_detail.split(",");
		for (String str : injs) {
			if(str.equals("01")){
				content += "门诊："+outpatient_list+"；";
			}else if(str.equals("02")){
				content += "住院、伤残："+maim_list+"；";
			}else if(str.equals("03")){
				content += "死亡："+demise_list+"；";
			}
		}
		return content;
	}

	/**
	 * <b> 根据订单id 查询报案列表</b>
	 * @author ZXF
	 * @create 2019/11/19 0019 14:37
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public PageResult selectInsCommonReportVoListByOrderID(Map<Object,Object> p){
		return new PageResult(dao.selectInsCommonReportVoListByOrderIDCnt(p),dao.selectInsCommonReportVoListByOrderID(p));
	}

}
