package com.bcxin.ins.models.apply.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.SysLogService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.core.util.JwtUtil;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.models.apply.service.PreseverApplyService;

import com.bcxin.ins.models.order.policy.service.InsuranceOperationService;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.Map;


/**
 * <b>后台接口模块保全申请单处理 </b>
 *
 * @author zhongjinahui
 * @date 2017年8月03日 下午 13：23：42
 * @注意事项 </b> <b>
 */
@Controller
@RequestMapping(value = "${apiPath}/myApply")
public class PreserverApplyActionController extends BaseController {

    @Autowired
    private InsuranceOperationService insuranceOperationService;
    @Autowired
    private PreseverApplyService preseverApplyService;
    @Autowired
    private SysLogService logService;

    /**
     * PG3.5 保全列表
     */
    private static final String PRESERVER_LIST = getViewPath("admin/apply/api/preserver_apply_list");
    /**
     * PG3.5.1 保全详情-增减
     */
    private static final String PRESERVER_DETAIL_ADD_SUB = getViewPath("admin/apply/api/perserver_detail_add_sub");
    private static final String PRESERVER_DETAIL_ADD_SUB1 = getViewPath("admin/apply/api/order_detail");
    /**
     * PG2.1 订单列表
     */
    private static final String ORDER_LIST = getViewPath("admin/order/api/order_manager_list");
    /**
     * PG3.5.1 保全详情-替换
     */
    private static final String PRESERVER_DETAIL_MODIFY = getViewPath("admin/apply/api/perserver_detail_modify");

    /**
     * PG3.6 保全汇总账单列表
     */
    private static final String PRESERVER_PAY_LIST = getViewPath("admin/apply/api/preserver_pay_list");
    /**
     * PG3.7 保全结算列表
     */
    private static final String PRESERVER_SETTLEMENT_PAY_LIST = getViewPath("admin/apply/api/preserver_settlement_pay_list");

    /**
     * PG3.6.2 保全汇总子账单列表
     */
    private static final String PRESERVER_CHILD_BILL_PAY = getViewPath("admin/apply/api/perserver_child_bill_pay");
    /**
     * PG3.7.1 保全结算子账单列表
     */
    private static final String PRESERVER_CHILD_SETTLEMENT_PAY = getViewPath("admin/apply/api/perserver_child_settlement_pay");
    /**
     * PG3.6.1 缴费详情
     */
    private static final String PRESERVER_DETAIL_PAY = getViewPath("admin/apply/api/perserver_detail_pay");

    /**
     * 批单修复辅助页
     */
    private static final String APPLY_REPAIR = getViewPath("admin/apply/api/apply_repair");

    private static String MIN = "min";
    private static String MAX = "max";

    /**
     * <a>根据供应商查询保全列表 </a>
     *
     * @param model
     * @return
     * @author zhongjianhui
     * @date 2017年8月03日 下午 17：35：42
     * @注意事项 </b> <b>
     */
    @RequestMapping("/findApplyList/{sup_id}")
    public String findOrderList(ModelMap model, @PathVariable String sup_id) throws Exception {
        if(!"sup_admin".equals(sup_id)){
            throw new Exception("403-无访问权限！");
        }
        model.addAttribute("sup_id", sup_id);
        return PRESERVER_LIST;
    }

    @RequestMapping("/applyList_table/{sup_id}")
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params,
                        @PathVariable String sup_id, HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        if ("sup_admin".equals(sup_id)) sup_id = "";
        params.put("sup_id", sup_id);
        CTLUtil.out(preseverApplyService.query(p), resp);//进行查询，并转换
        return null;
    }

    /**
     * <b> 导出时间区间中华雇主【待审核】状态的保全人员列表 </b>
     * @author ZXF
     * @create 2019/10/10 0010 16:51
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/down_record_result_set")
    public void downRecordResultSet(HttpServletRequest req, HttpServletResponse resp) {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String name = req.getParameter("name");
        preseverApplyService.downRecordResultSet(keyword,name,start_time,end_time,resp);
    }

    /**
     * <b> 导出指定投保人和已选时间区间【待审核、审批通过】状态的保全申请单明细 </b>
     * @author ZXF
     * @create 2019/10/10 0010 16:52
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/down_record_detail")
    public void downRecordDetail(HttpServletRequest req, HttpServletResponse resp) {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String name = req.getParameter("name");
        preseverApplyService.downRecordDetail(keyword,name,start_time,end_time,resp);
    }

    /**
     * <b> 导出在保人员数据及保全金额 </b>
     * @author ZXF
     * @create 2020/02/14 0014 16:10
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/down_success_result_set")
    public void downSuccessResultSet(HttpServletRequest req, HttpServletResponse resp) {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String type = req.getParameter("type");
        String name = req.getParameter("name");
        String isGQ = req.getParameter("isGQ");
        preseverApplyService.downSuccessResultSet(keyword,name,start_time,end_time,type,isGQ,resp);
    }

    /**
     * <b> 电子批单补偿 </b>
     * @author ZXF
     * @create 2020/11/13 0013 9:40
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/getDZPD/{id}")
    @ResponseBody
    public R getDZPD( @PathVariable Long id) {
        return preseverApplyService.getDZPD(id);
    }


     /*
    *
    * 保全申请record操作结束
    *
    *
    */



  /*
    *
    * 保全详情detail操作开始：增减和替换
    *
    *
    */

    /**
     * <aa>保全详情增减 </aa >
     *
     * @param model
     * @return
     * @author zhongjianhui
     * @date 2017年8月03日 下午 17：35：42
     * @注意事项 </b> <b>
     */
    @RequestMapping("/perserverDetailAddByID/{id}/{sup_id}")
    public String perserverDetailAddByID(ModelMap model, @PathVariable Long id, @PathVariable String sup_id) {
        InsPreservationRecordVo preservationRecordVo = preseverApplyService.accordingToApplyIDToGetpreservationRecordVo(id);
        model.addAttribute("preservationRecordVo", preservationRecordVo);
        model.addAttribute("logList", logService.findSysLogByOrderID(String.valueOf(id)));
        model.addAttribute("sup_id", sup_id);
        OrderFormVo order = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(preservationRecordVo.getIns_insurance_slip_id()));
        model.addAttribute("apprSign", StringUtils.isEmpty(order.getProduct_code())?0:order.getProduct_code().contains("GZZRX-CA")?1:0);
        return PRESERVER_DETAIL_ADD_SUB;
    }

    /**
     * <a>根据保全record id查出人员详情列表：增减和替换共用 </a>
     *
     * @param params
     * @return
     * @author zhongjianhui
     * @date 2017年8月06日 下午 15：35：42
     * @注意事项 </b> <b>
     */
    @RequestMapping("/perserverDetail/{id}/{status}")
    @ResponseBody
    public Object queryDetail(@RequestParam Map<Object, Object> params, @PathVariable String id, @PathVariable String status, HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);
        params.put("id", id);
        params.put("status", status);
        CTLUtil.out(preseverApplyService.queryDetail(params), resp);
        return null;
    }
    @RequestMapping("/perserverUpdataButton/{id}")
    @ResponseBody
    public boolean queryStatus( @PathVariable Long id) {
        return preseverApplyService.accordingToApplyIDToGetStatus(id);
    }
    /**
     * <a>审核不通过操作，记录不通过原因及变更人员状态：增减和替换共用 </a>
     *
     * @param request
     * @return
     * @author zhongjianhui
     * @date 2017年8月10日 下午1:28:56
     * @注意事项 </b>
     * <b>
     */

    @RequestMapping(value = "/applyAuditFail2", method = RequestMethod.POST)
    @ResponseBody
    public R applyAuditFail1(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map<Object, Object> p = CTLUtil.init(request, params);
        return preseverApplyService.statusUpd(p,request);

    }
    @RequestMapping(value = "/updataReviseStatus", method = RequestMethod.POST)
    @ResponseBody
    public R updataReviseStatus(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map<Object, Object> p = CTLUtil.init(request, params);

        return preseverApplyService.updataReviseStatus(p,request);
    }

    @RequestMapping(value = "/updataCAReviseStatus")
    @ResponseBody
    public String updataReviseStatus(HttpServletRequest request) {
        String token = request.getParameter("token");
        JSONObject json;
        try{
            json = JwtUtil.getJsonByParseJWT(token,JwtUtil.JWT_SECRET);
            if(json == null){
                return JSON.toJSONString( Result.fail("未携带有效信息！"));
            }
        }catch(io.jsonwebtoken.ExpiredJwtException e1){
            return JSON.toJSONString( Result.fail("token已经过期！"));
        }catch (Exception e){
            return JSON.toJSONString( Result.fail("token解析出错！"));
        }
        return JSON.toJSONString(preseverApplyService.updataCAReviseStatus(json.getString("recordId")
                ,json.getString("recordStatus")
                ,json.getString("remark")
                ,json.getString("reviseSerialNumIns")
                ,json.getString("revisePath")
                ,request));
    }

    @RequestMapping("/saveResultSet/{id}/{revise_type}")
    @ResponseBody
    public R saveResultSet( @PathVariable Long id,@PathVariable String revise_type) {
        return preseverApplyService.pushResultSetByRecord(id,revise_type);
    }

    @RequestMapping("/uploadFile/{upload_id}/{upload_Type}")
    @ResponseBody
    public R uploadFilePay(MultipartHttpServletRequest request,@PathVariable String upload_id,
                           @PathVariable String upload_Type) throws Exception {
        MultipartFile pay_file = request.getFile("upload_file");
        String path = OSSFileUtil.huaweiOBSFileUpload(pay_file,"/record/");
        if (StringUtils.isNotEmpty(path)) {
            return preseverApplyService.doUploadFile(path, upload_id, upload_Type);
        }else {
            return new R(false, "请选择要上传的文件");
        }

    }

    @RequestMapping(value = "/setPdNo", method = RequestMethod.POST)
    @ResponseBody
    public R setPdNo(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map<Object, Object> p = CTLUtil.init(request, params);
        return preseverApplyService.setPdNo(p,request);
    }

   /*
    * 保全详情替换
    *
    * */

    /**
     * <ab>保全详情替换 </ab>
     *
     * @param model
     * @return
     * @author zhongjianhui
     * @date 2017年8月03日 下午 17：35：42
     * @注意事项 </b> <b>
     */
    @RequestMapping("/perserverDetailChangeByID/{id}/{sup_id}")
    public String perserverDetailChangeByID(ModelMap model, @PathVariable Long id ,@PathVariable String sup_id) {
        InsPreservationRecordVo preservationRecordVo = preseverApplyService.accordingToApplyIDToGetpreservationRecordVo(id);
        model.addAttribute("logList", logService.findSysLogByOrderID(String.valueOf(id)));
        model.addAttribute("preservationRecordVo", preservationRecordVo);
        model.addAttribute("sup_id", sup_id);
        OrderFormVo order = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(preservationRecordVo.getIns_insurance_slip_id()));
        model.addAttribute("apprSign", StringUtils.isEmpty(order.getProduct_code())?0:order.getProduct_code().contains("GZZRX-CA")?1:0);
//        Long policyId=Long.valueOf(preservationRecordVo.getIns_insurance_slip_id());
//        String resultDate = preseverApplyService.getEffectiveByPolicyId(policyId);
//        model.addAttribute("logList", logService.findSysLogByOrderID(String.valueOf(id)));
//        model.addAttribute("max", resultDate.split(",")[1]);
//        model.addAttribute("min", resultDate.split(",")[0]);
        return PRESERVER_DETAIL_MODIFY;
    }


    /**
     * <b>根据保全record id查出人员详情然后根据人员的company_id查询出原被保险人详情列表 </b>
     *
     * @param params
     * @return
     * @author zhongjianhui
     * @date 2017年8月06日 下午 15：35：42
     * @注意事项 </b> <b>
     */

    @RequestMapping("/perserverOldPerson/{id}/{status}")
    @ResponseBody
    public Object queryOldPerson(@RequestParam Map<Object, Object> params, @PathVariable String id, @PathVariable String status, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init(req, params);
        params.put("id", id);
        params.put("status", status);
        CTLUtil.out(preseverApplyService.queryOldPerson(params), resp);
        logger.info(JSON.toJSONString(preseverApplyService.queryOldPerson(params)));

        return null;
    }
  /*
    *
    * 保全详情detail操作结束：增减和替换
    *
    *
    */


  /*
  *
  * 保全缴费操作开始
  * */


    /**
     * <b>根据供应商查询保全汇总账单列表 </b>
     *
     * @param model
     * @return
     * @author zhongjianhui
     * @date 2017年8月06日 下午 15：35：42
     * @注意事项 </b> <b>
     */
    @RequestMapping("/findPayList/{sup_id}")
    public String findPayList(ModelMap model, @PathVariable String sup_id) throws Exception {
        if(!"sup_admin".equals(sup_id)){
            throw new Exception("403-无访问权限！");
        }
        model.addAttribute("sup_id", sup_id);
        return PRESERVER_PAY_LIST;
    }


    @RequestMapping("/applyPayList_table/{sup_id}")
    @ResponseBody
    public Object queryPay(@RequestParam Map<Object, Object> params, @PathVariable String sup_id, HttpServletRequest req, HttpServletResponse resp,ModelMap model) {
        Map<Object, Object> p = CTLUtil.init(req, params);
        if ("sup_admin".equals(sup_id)) sup_id = "";
        model.addAttribute("sup_id", sup_id);
        params.put("sup_id", sup_id);
        CTLUtil.out(preseverApplyService.queryBillPay(params), resp);
        return null;
    }

    @RequestMapping("/childBillList/{parentPayId}/{isPart}")
    public String childBillList(ModelMap model, @PathVariable Long parentPayId, @PathVariable String isPart) {
        logger.info(JSON.toJSONString(parentPayId));
        InsPreservationPayVo insPreservationPayVo = preseverApplyService.accordingToPayIDToGetpreservationPayVo(parentPayId);
        logger.info(JSON.toJSONString(insPreservationPayVo));
//        model.addAttribute("logList", logService.findSysLogByOrderID(String.valueOf(id)));
        model.addAttribute("insPreservationPayVo", insPreservationPayVo);
        model.addAttribute("parentPayId", parentPayId+"");
        model.addAttribute("isPart", isPart);
        return PRESERVER_CHILD_BILL_PAY;
    }

    /**
     * <b> 根据保全payid查出汇总子账单详情分页List </b>
     * @author ZXF
     * @create 2024/05/06 0006 11:07
     * @version
     * @注意事项 </b>
     */

    @RequestMapping("/getBillListForPage")
    @ResponseBody
    public Object getBillListForPage(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init(req, params);
        CTLUtil.out(preseverApplyService.queryChildBillPay(params), resp);

        return null;
    }

    /**
     * <b>根据供应商查询保全结算列表 </b>
     *
     * @param model
     * @return
     * @author zhongjianhui
     * @date 2017年8月06日 下午 15：35：42
     * @注意事项 </b> <b>
     */
    @RequestMapping("/findSettlementPayList/{sup_id}")
    public String findSettlementList(ModelMap model, @PathVariable String sup_id) throws Exception {
        if(!"sup_admin".equals(sup_id)){
            throw new Exception("403-无访问权限！");
        }
        model.addAttribute("sup_id", sup_id);
        return PRESERVER_SETTLEMENT_PAY_LIST;
    }


    @RequestMapping("/applySettlementPayList_table/{sup_id}")
    @ResponseBody
    public Object querySettlementPay(@RequestParam Map<Object, Object> params, @PathVariable String sup_id, HttpServletRequest req, HttpServletResponse resp,ModelMap model) {
        Map<Object, Object> p = CTLUtil.init(req, params);
        if ("sup_admin".equals(sup_id)) sup_id = "";
        model.addAttribute("sup_id", sup_id);
        params.put("sup_id", sup_id);
        CTLUtil.out(preseverApplyService.querySettlementPay(params), resp);
        return null;
    }

    @RequestMapping("/childSettlementList/{parentPayId}")
    public String childSettlementList(ModelMap model, @PathVariable Long parentPayId) {
        logger.info(JSON.toJSONString(parentPayId));
        InsPreservationPayVo insPreservationPayVo = preseverApplyService.accordingToPayIDToGetpreservationPayVo(parentPayId);
        logger.info(JSON.toJSONString(insPreservationPayVo));
//        model.addAttribute("logList", logService.findSysLogByOrderID(String.valueOf(id)));
        model.addAttribute("insPreservationPayVo", insPreservationPayVo);
        model.addAttribute("parentPayId", parentPayId+"");
        return PRESERVER_CHILD_SETTLEMENT_PAY;
    }

    /**
     * <b> 根据保全payid查出汇总子账单详情分页List </b>
     * @author ZXF
     * @create 2024/05/06 0006 11:07
     * @version
     * @注意事项 </b>
     */

    @RequestMapping("/getChildSettlementListForPage")
    @ResponseBody
    public Object getChildSettlementListForPage(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init(req, params);
        CTLUtil.out(preseverApplyService.queryChildSettlementPay(params), resp);

        return null;
    }

    /**
     * <b>根据页面勾选条目生成部分账单 </b>
     * @param isSummaryBill 是否为汇总账单
     * @param payIds 勾选数据列的id集合
     * @author ZXF
     * @create 2024/04/26 0026 11:04
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("createPartBill")
    public @ResponseBody String createPartBill(String isSummaryBill, String payIds){
        JSONObject json = preseverApplyService.createPartBill(isSummaryBill,payIds.split(","));
        return json.toJSONString();
    }

    @RequestMapping("createPartBillByNo")
    public @ResponseBody String createPartBillByNo(String isSummaryBill, String payNos){
        JSONObject json = preseverApplyService.createPartBillByNo(isSummaryBill,payNos.split(","));
        return json.toJSONString();
    }

    @RequestMapping("/downBillPay")
    public void downBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        if(StringUtils.isNotEmpty(keyword)){
            keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
        }
        String et = ConstProp.BLANK_CHAR;
        if(StringUtils.isNotEmpty(end_time)){
            et = end_time+ConstProp.DAY_23;
        }
        preseverApplyService.downBillPay( pay_status, start_time, et, keyword, resp);

    }

    @RequestMapping("/downChildBillPay")
    public void downChildBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String pay_status = req.getParameter("pay_status");
        String parentPayId = req.getParameter("parentPayId");
        if(StringUtils.isNotEmpty(keyword)){
            keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
        }
        String et = ConstProp.BLANK_CHAR;
        if(StringUtils.isNotEmpty(end_time)){
            et = end_time+ConstProp.DAY_23;
        }
        preseverApplyService.downChildBillPay( Long.parseLong(parentPayId), pay_status, start_time, et, keyword, resp);

    }

    @RequestMapping("/downChildSettlementBillPay")
    public void downChildSettlementBillPay(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String keyword = req.getParameter("keyword");
        String start_time = req.getParameter("start_time");
        String end_time = req.getParameter("end_time");
        String parentPayId = req.getParameter("parentPayId");
        if(StringUtils.isNotEmpty(keyword)){
            keyword = new String(keyword.getBytes(ConstProp.ENCODE_ISO_8859_1), ConstProp.ENCODE_UTF8);
        }
        String et = ConstProp.BLANK_CHAR;
        if(StringUtils.isNotEmpty(end_time)){
            et = end_time+ConstProp.DAY_23;
        }
        preseverApplyService.downChildSettlementBillPay( Long.parseLong(parentPayId), start_time, et, keyword, resp);

    }

     /*
  *
  * 保全缴费操作结束
  * */


        /*
  *
  * 缴费详情操作开始
  * */

    /**
     * <b>缴费详情：根据pay ID查询出保全信息和缴费处理所需的数据 </b>
     *
     * @param model
     * @return
     * @author zhongjianhui
     * @date 2017年8月12日 下午 14：35：42
     * @注意事项 </b> <b>
     */
    @RequestMapping("/payDetailByID/{id}")
    public String payDetailAddByID(ModelMap model, @PathVariable Long id) {
        logger.info(JSON.toJSONString(id));
        InsPreservationPayVo insPreservationPayVo = preseverApplyService.accordingToPayIDToGetpreservationPayVo(id);
        logger.info(JSON.toJSONString(insPreservationPayVo));
//        model.addAttribute("logList", logService.findSysLogByOrderID(String.valueOf(id)));
        model.addAttribute("insPreservationPayVo", insPreservationPayVo);
        return PRESERVER_DETAIL_PAY;
    }

    /**
     * <b>根据保全pay id查出缴费详情分页List </b>
     *
     * @param params
     * @return
     * @author zhongjianhui
     * @date 2017年8月11日 下午 15：35：42
     * @注意事项 </b> <b>
     */

    @RequestMapping("/perserverPayDetail/{id}")
    @ResponseBody
    public Object queryPayDetail(@RequestParam Map<Object, Object> params, @PathVariable String id, HttpServletRequest req, HttpServletResponse resp) {
        CTLUtil.init(req, params);
        params.put("id", id);
        CTLUtil.out(preseverApplyService.queryPayDetail(params), resp);

        return null;
    }
    @RequestMapping(value = "/updataPayStatus", method = RequestMethod.POST)
    @ResponseBody
    public R updataPayStatus(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map<Object, Object> p = CTLUtil.init(request, params);
        return preseverApplyService.updataPayStatus(p);
    }

    @RequestMapping(value = "/overPay", method = RequestMethod.POST)
    @ResponseBody
    public R overPay(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map<Object, Object> p = CTLUtil.init(request, params);
        return preseverApplyService.overPay(p);
    }

      /*
  *
  * 缴费详情操作结束
  * */

    /**
     * <b> 批单修复辅助页 </b>
     * @author ZXF
     * @create 2020/09/07 0007 10:57
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/applyRepair/{sup_id}")
    public String applyRepair(ModelMap model, @PathVariable String sup_id) throws Exception {
        if(!"sup_admin".equals(sup_id)){
            throw new Exception("403-无访问权限！");
        }
        model.addAttribute("sup_id", sup_id);
        return APPLY_REPAIR;
    }
}
