package com.bcxin.ins.models.apply.service.impl;

import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.entity.common.ComTaskUnSeeFeeRecord;
import com.bcxin.ins.models.apply.dao.ComTaskUnSeeFeeRecordDao;
import com.bcxin.ins.models.apply.service.ComTaskUnSeeFeeRecordService;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Map;


@Service
@Transactional
public class ComTaskUnSeeFeeRecordServiceImpl extends ServiceImpl<ComTaskUnSeeFeeRecordDao, ComTaskUnSeeFeeRecord> implements ComTaskUnSeeFeeRecordService {

    @Autowired
    private ComTaskUnSeeFeeRecordDao dao;

    private Logger log =  LoggerFactory.getLogger(ComTaskUnSeeFeeRecordServiceImpl.class);

    /**
     * 任务列表查询
     *
     * @param p
     */
    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(dao.queryCnt(p),dao.query(p));
    }

    /**
     * 删除任务
     *
     * @param p
     */
    @Override
    public R del(Map<Object, Object> p) {
        try{
            //删除公告信息
            deleteById(Long.valueOf(String.valueOf(p.get("com_task_un_see_fee_record_id"))));
            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("删除残留任务，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }
}
