package com.bcxin.ins.models.apply.dao;


import com.bcxin.ins.entity.policy_core.InsPreservationDetail;

import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.vo.excel.RecordDetailExcelVo;
import com.bcxin.ins.vo.excel.RecordExcelVo;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsPreservationDetailVo;

import com.bcxin.ins.vo.excel.RecordSuccessExcelVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>保全表数据访问 </b>
 *
 * @author zhongjianhui
 * @date 2017年08月04日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface PreseverApplyDetailDao extends BaseMapper<InsPreservationDetail> {
    //通过条件比对拿结果集对应数据的id来修改人员表的business_id字段
    void updateBusiness_idForDetail(@Param("now_record_id") Long now_record_id,@Param("last_record_id") Long last_record_id);
    //查询保全申请数据
    List<Map<Object,Object>> queryDetail(Map<Object, Object> p);
    /*查询保全申请总行数*/
    int queryDetailCnt(Map<Object, Object> p);
    //查询保全申请数据
    List<Map<Object,Object>> queryOldPerson(Map<Object, Object> p);
    //查询保全申请数据2
    List<InsRoleInpolicy> queryOldPerson2(@Param("record_id") Long record_id);
    /*查询保全申请总行数*/
    int queryOldPersonCnt(Map<Object, Object> p);
    /*查询结果集原被保险人总条数*/
    int queryOldPersonFromResultSetCnt(Map<Object, Object> p);
    /*查询结果集原被保险人列表*/
    List<Map<Object,Object>> queryOldPersonFromResultSet(Map<Object, Object> p);
    List<Map<Object,Object>> queryOldPersonFromResultSet2(Map<Object, Object> p);
    int queryStatus(@Param("record_id") Long record_id);
    List<InsPreservationDetailVo> findDetailFormVoByID(@Param("detail_id") Long pay_id);
     int updataDetailFormByKeyword(@Param("detail_id") String detail_id, @Param("status") String status, @Param("remark") String remark);
    /**
     * <b> 导出当前周中华雇主[待审核]状态的保全人员列表(仅支持筛选增员、减员类型的保全单) </b>
     * @author ZXF
     * @create 2019/08/29 0029 16:58
     * @version
     * @注意事项 </b>
     */
    List<RecordExcelVo> downRecordResultSet(@Param("keyword") String keyword, @Param("name") String name, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("product_code") String product_code);

    /**
     * <b> 导出指定投保人和已选时间区间【待审核、审批通过】状态的保全申请单明细(仅支持筛选增员、减员类型的保全单) </b>
     * @author ZXF
     * @create 2019/08/29 0029 16:58
     * @version
     * @注意事项 </b>
     */
    List<RecordDetailExcelVo> downRecordDetail(@Param("keyword") String keyword, @Param("name") String name, @Param("start_time") String start_time, @Param("end_time") String end_time);

    /**
     * <b> 导出在保人员数据及保全金额 </b>
     * @author ZXF
     * @create 2020/02/14 0014 16:13
     * @version
     * @注意事项 </b>
     */
    List<RecordSuccessExcelVo> downSuccessResultSet(@Param("keyword") String keyword, @Param("name") String name, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("type") String type);

    /**
     * <b> 导出已过期在保人员数据及保全金额 </b>
     * @author ZXF
     * @create 2020/02/14 0014 16:13
     * @version
     * @注意事项 </b>
     */
    List<RecordSuccessExcelVo> downSuccessResultSetGQ(@Param("keyword") String keyword, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("type") String type);
    /**
     * <b> 保单在保人员转批改明细 </b>
     * @author ZXF
     * @create 2023/09/04 0004 10:49
     * @version
     * @注意事项 </b>
     */
    List<InsPreservationDetail> findZBPer(@Param("orderId") String orderId);
}
