package com.bcxin.ins.models.apply.dao;


import com.bcxin.ins.entity.policy_core.InsPreservationPay;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>保全表数据访问 </b>
 *
 * @author zhongjianhui
 * @date 2017年08月04日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface PreseverApplyDao extends BaseMapper<InsPreservationRecord> {

	//查询保全申请数据
	List<Map<Object,Object>> query(Map<Object, Object> p);
	/*查询保全申请总行数*/
	int queryCnt(Map<Object, Object> p);
	//保存地址
	int updateDetailResivePathByID(@Param("record_id") Long record_id,@Param("revise_path") String revise_path);

	int updatePayPathResivePathByID(@Param("pay_id") Long pay_id,@Param("pay_inform_path") String pay_inform_path);
	//查询保全申请数据

	//查询保全缴费
	List<Map<Object,Object>> queryPay(Map<Object, Object> p);
	/*查询保全缴费总行数*/
	int queryPayCnt(Map<Object, Object> p);

	//查询保全汇总账单
	List<Map<Object,Object>> queryBillPay(Map<Object, Object> p);
	/*查询保全汇总账单总行数*/
	int queryBillPayCnt(Map<Object, Object> p);

	//查询保全结算单
	List<Map<Object,Object>> querySettlementPay(Map<Object, Object> p);
	/*查询保全结算单总行数*/
	int querySettlementPayCnt(Map<Object, Object> p);

	//查询保全汇总子账单
	List<Map<Object,Object>> queryChildBillPay(Map<Object, Object> p);
	/*查询保全汇总子账单总行数*/
	int queryChildBillPayCnt(Map<Object, Object> p);

	//查询保全结算子账单
	List<Map<Object,Object>> queryChildSettlementPay(Map<Object, Object> p);
	/*查询保全结算子账单总行数*/
	int queryChildSettlementPayCnt(Map<Object, Object> p);


	/**
	 * <b> 是否险种一致 </b>
	 * @param isSummaryBill 是否为汇总账单
	 * @param pays 勾选数据列的id集合
	 * @author ZXF
	 * @create 2024/04/26 0026 11:24
	 * @version
	 * @注意事项 </b>
	 */
	int isConsistentInsurancePlan(@Param("isSummaryBill") String isSummaryBill,@Param("pays") String[] pays);
	/**
	 * <b> 是否归属同一账号 </b>
	 * @param isSummaryBill 是否为汇总账单
	 * @param pays 勾选数据列的id集合
	 * @author ZXF
	 * @create 2024/04/26 0026 11:24
	 * @version
	 * @注意事项 </b>
	 */
	int isConsistentAccount(@Param("isSummaryBill") String isSummaryBill,@Param("pays") String[] pays);
	String isPartBillSign(@Param("pays") String[] pays);
	List<Map<String,String>> isConsistentSummaryBill(@Param("pays") String[] pays);
	List<InsPreservationPay>  consistentBillMerge(@Param("isSummaryBill") String isSummaryBill, @Param("pays") String[] pays);
	String findPayIdsByPayNos(@Param("payNos") String[] payNos);
	InsPreservationPay getPayExAndMonth(@Param("policyNo") String policyNo, @Param("star") Date star, @Param("end") Date end);
	/**
	 * <b> 查找指定子账单对应汇总账单，如果汇总账单下不存在未完成缴费的账单就将汇总账单设置为完成 </b>
	 * @author ZXF
	 * @create 2024/05/07 0007 16:41
	 * @version
	 * @注意事项 </b>
	 */
	int updateOverParentPay(@Param("pays") String[] pays);
	/**
	 * <b> 给指定账单设置上级账单id </b>
	 * @author ZXF
	 * @create 2024/04/24 0024 13:46
	 * @version
	 * @注意事项 </b>
	 */
	int updateParentPayId(@Param("parent_id") Long parent_id,@Param("pays") String[] pays);
	/**
	 * <b> 给指定账单设置上级部分账单id </b>
	 * @author ZXF
	 * @create 2024/04/24 0024 13:46
	 * @version
	 * @注意事项 </b>
	 */
	int updateParentPartBillId(@Param("parent_id") Long parent_id,@Param("pay_status") String pay_status,@Param("pays") String[] pays);
	/**
	 * <b> 汇总账单下的子账单是否包含未完成的部分账单业务 </b>
	 * @author ZXF
	 * @create 2024/05/06 0006 14:26
	 * @version
	 * @注意事项 </b>
	 */
	int isOtherChildBill(@Param("isSummaryBill") String isSummaryBill,@Param("parent_id") Long parent_id);
	/**
	 * <b> 根据上级账单及账单类型组装结算账单 </b>
	 * @author ZXF
	 * @create 2024/05/06 0006 14:28
	 * @version
	 * @注意事项 </b>
	 */
	InsPreservationPay getFootPayByParentId(@Param("isSummaryBill") String isSummaryBill,@Param("parent_id") Long parent_id);
	/**
	 * <b> 子账单打上结算单标记 </b>
	 * @author ZXF
	 * @create 2024/05/06 0006 14:58
	 * @version
	 * @注意事项 </b>
	 */
	int updateParentFootId(@Param("parent_id") Long parent_id,@Param("pay_status") String pay_status,@Param("pays") String[] pays);

	List<InsPreservationRecordVo> findRecordFormVoByID(@Param("id") Long id);

	List<InsPreservationRecordVo> listInsPreservationRecordVoByTranNo(@Param("tran_no") String tran_no);

	int deleteResultSetByTranNo(@Param("tran_no") String tran_no);

	/**
	 * <b>根据保全申请单id查询InsPreservationRecordVo </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	public InsPreservationRecordVo findInsPreservationRecordVoById( @Param("oid") Long oid );

	List<InsPreservationPayVo> findPayFormVoByID(@Param("id") Long id);
	//查询缴费详情数据
	List<Map<Object,Object>> queryPayDetail(Map<Object, Object> p);
	/*查询缴费详情总行数*/
	int queryPayDetailCnt(Map<Object, Object> p);

	//查询   record中缴费所需的数据
	List<Map<Object,Object>> queryPayecordForPay(Map<Object, Object> p);

	List<InsPreservationResultSet> findResultSetVoByRecordID(@Param("record_id") Long record_id);
	List<InsPreservationResultSet> findResultSetVoByRecordID_TSFF(@Param("record_id") Long record_id);
	int updateRecordStatus(InsPreservationRecordVo vo);
	int updateRelease_time(@Param("record_id") String record_id,@Param("release_time") String release_time);
	int updatePayStatus(@Param("pay_id") String pay_id, @Param("fact_total_amount") String fact_total_amount, @Param("pay_status") String pay_status);
	int findPaymentPeriod(@Param("record_id") Long record_id);
	Long selectHavePayID(@Param("record_id") Long record_id);
	List<Map> findCheckPendingPreservationRecord(@Param("init_time") String init_time);

	void batchInsert(@Param("list") List<InsPreservationResultSet> list);
	int batchUpdateStatus(@Param("id") Long[] id, @Param("status") int status, @Param("type") String type, @Param("date") String date);

	//查询在保人员数据
	List<Map<Object,Object>> queryResultSet(Map<Object, Object> p);
	List<ResultSetExcelVo> queryResultSetVo(Map<Object, Object> p);
	/*查询在保人员总行数*/
	int queryResultSetCnt(Map<Object, Object> p);

	/*根据订单id修改在保人员状态为废弃*/
	int updateResultSetStatus(@Param("order_id") Long order_id);
	/*根据订单id统计已审核的保全单数量*/
	int recordCount(@Param("order_id") Long order_id);
	/*根据订单id修改保全单状态为废弃*/
	int deleteRecord(@Param("order_id") Long order_id);
	/*根据订单id修改保全缴费状态为废弃*/
	int deletePay(@Param("order_id") Long order_id);

	int setPdNo(@Param("list") String[] list);
	/*根据传入已结算的账单id更新存在归属关系的保全信息的结算状态为已结算*/
	int setRecordPayStatusByPayId(@Param("pays") String[] pays);
}
