<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>残留任务列表</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">

                <div class="ibox-content">
                    <div class="alert alert-success">
                        残留任务记录指请求第三方接口时失败记录当时入参、方法、类等信息，后台通过定时器间歇性轮询直到成功后自动销毁记录（列表存在记录说明有接口异常），请谨慎手动删除！
                    </div>
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input  class="easyui-textbox" name="keyword" data-options="prompt:'方法名/类名/注释'" placeholder="" style="width:275px;" />
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryBtn" type="button" class="btn  btn-primary btn-sm" >
                                                            <i class="glyphicon glyphicon-search"></i> 搜索</button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryForm" type="button" class="btn btn-primary btn-sm " >
                                                            <i class="glyphicon glyphicon-minus"></i> 清空</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <table id="defaultTable"
                                           data-toggle="table"
                                           data-show-refresh="true"
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="sort"
                                           data-url="${ctx}/residual/query"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="asc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="false" data-field="rownum" data-formatter="rownumFn">序号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="method_name" >方法名</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="annotation" >注释</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="class_name" >类名</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="param_num" >入参个数</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="param_type_arr" >参数类型</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="param_value_arr" >参数值</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="create_time">产生时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="false" data-field="" data-formatter="formatOperationFn">操作 </th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
            });

        });

        function rownumFn(value, row, index){
            var opt = $('#defaultTable').bootstrapTable('getOptions');
            if(opt.pageSize=="All") return index +1;
            return opt.pageSize * (opt.pageNumber - 1) + index + 1;
        }

        function formatOperationFn(index, row) {
            var str = "";
            <shiro:hasPermission name="residual:win:del">
                var onClick2= "member_del(this,'"+row.com_task_residual_id+"')";
                var onClick3= "member_execute(this,'"+row.com_task_residual_id+"')";
                str += '<a class="remove m-l-sm text-primary" href="javascript:void(0)" onclick="'+onClick2+'" title="删除" > <i class="glyphicon glyphicon-remove"></i></a>';
                str += '<a class="remove m-l-sm text-primary" href="javascript:void(0)" onclick="'+onClick3+'" title="执行" > <i class="glyphicon  glyphicon-play-circle"></i></a>';
            </shiro:hasPermission>
                return str;
        }
        /*删除任务*/
        function member_del(obj, id) {
            layer.confirm('确认要删除残留任务信息吗？', {  btn: ['确定', '取消'] }, function () {
                g_ajax('${ctx}/residual/del',{com_task_residual_id:id}, function(json){
                    comm_back(json);
                });
            });
        }
        /*批量执行任务*/
        function batchExecuteTask(){
            layer.confirm('确认批量执行列表中的任务操作吗？',{btn: ['确定','取消'] //按钮
            }, function(){
                g_ajax('${ctx}/residual/batchExecuteTask',{}, function(json){
                    comm_back(json);
                });
            });
        }

        /*执行任务*/
        function member_execute(obj, id) {
            layer.confirm('确认要执行残留任务信息吗？', {  btn: ['确定', '取消'] }, function () {
                g_ajax('${ctx}/residual/executeTask',{com_task_residual_id:id}, function(json){
                    comm_back(json);
                });
            });
        }
        function comm_back(json){
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
