<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
    <title>设置佣金</title>
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-table-master/bootstrap-table.min.css" />
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" />
    <link href="${ctxsta}/admin/product/css/bootstrap.min.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/font-awesome.min.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/common.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/establish.css" rel="stylesheet">
    <link rel="stylesheet" href="${ctxsta}/admin/product/css/style.min.css"/>
    <!--[if lt IE 9]>
    <script src="${ctxsta}/admin/product/js/html5shiv.min.js"></script>
    <script src="${ctxsta}/admin/product/js/respond.min.js"></script>
    <![endif]-->
</head>

<body class="gray-bg">
<div class="container content ">
    <div class="nav-head">
        <div class="step step3">
            <ul>
                <li >
                    <strong>选择一级分销商</strong>
                </li>
                <li >
                    <strong>选择需分配的产品</strong>
                </li>

                <li class="current">
                    <strong>设置佣金</strong>
                </li>
                <li>
                    <strong>完成</strong>
                </li>
            </ul>
        </div>
    </div>

    <div class="create">
        <form class="form-horizontal" id="productFrom"  action="${ctx}/ins/product/saveCompanyBrokerageOne" method="POST">
            <table class="table table-bordered">
                <thead>
                <tr>
                    <td>序号</td>
                    <td>产品名称</td>
                    <td>产品类型</td>
                    <td>价格</td>
                    <td>供应商</td>
                    <td>可分配佣金</td>
                    <td>分销商佣金</td>
                </tr>
                </thead>
                <tbody>
                <c:forEach items="${plst}" var="product" varStatus="status">
                    <input class="hidden" name="list[${status.index}].productId" value="${product.id}">
                    <input class="hidden" name="list[${status.index}].supplierId" value="${companyId}">
                    <tr>
                        <td>${status.index + 1}</td>
                        <td>${product.insuranceName}</td>
                        <td>${fns:getDictLabel (product.productType,"product_type","")}</td>
                        <td>无</td>
                        <td>${product.supplier.companyName}</td>
                        <td><fmt:formatNumber value="${product.distributable}" pattern="0.00"/>%</td>
                        <td><input  class="prodcutfee"  type="text" style="width:50px"  onkeyup="onkeyupValue(this,${product.distributable})" name="list[${status.index}].brokerage" placeholder="00.00"/><span> %</span></td>
                    </tr>
                </c:forEach>


                </tbody>
            </table>
            <div class="row choice">
                <div class="col-xs-6">
                    <p>将分配选择 <span >${plst.size()}</span> 件产品 给 <span>${slist.size()}</span> 名分销商</p>
                </div>
            </div>
            <input  name="productIds" class="hidden" id="productIds" value="${productIds}"/>
            <div class="row">
                <div class="row finish">
                    <div class="col-sm-9 col-sm-offset-2">
                        <a class="btn btn-long btn-lightgreen"  onclick="tijiaoForm()">上一步</a>
                        <a class="btn btn-long btn-lightgreen" id="submit" onclick="checkForm(this)" href="#">完成分配</a>
                        <a onclick="hideWidow()" class="btn btn-long btn-lightgreen">取消分配</a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<bcxinFooter>
    <!-- 自定义js -->
    <script type="text/javascript">
        function  hideWidow() {
            layer_close();
        }
        function  checkForm(obj){
            var flag=false;
            $(".prodcutfee").each(function () {
                if($(this).val()==null ||$(this).val()==""){
                    flag=true;
                }
            });
            if(flag){
                layer.msg("请填写完整的分销商佣金！");
            }else{
                toAjaxSubmit(obj);
            }
        }
        /**
         * 输入限制
         * @param obj
         * @param distributable
         */
        function onkeyupValue(obj,distributable){
            var  value = obj.value;
            if(!/^-?\d+\.?\d{0,2}$/.test(value)){
                layer.msg('只能输入数字，小数点后只能保留两位');
                $(obj).val('');
            }
            var type = '${company.companyType}';
            var leve = '${company.distributionLevel}';
            if(type=='2'&&(leve=='2'||leve=='3')){
                if(parseFloat(value)>parseFloat(distributable)){
                    layer.msg('设置佣金不能大于可分配佣金!');
                    $(obj).val('');
                }
            }else if(type=='4'){
                if(parseFloat(value)>parseFloat(distributable)){
                    layer.msg('设置佣金不能大于可分配佣金!');
                    $(obj).val('');
                }
            }
        }

        function replaceNotNumber(obj)
        {
            var pattern = /^\d+(\.\d{2})?$/;
            if(pattern.test(obj.value))
            {
                layer.msg("请输入数字！");
                obj.value = obj.value.replace(pattern,"");
            }
        }
        function  changeNum(){
            var boxArray = document.getElementsByName('productName');
            var total = 0;
            for(var i=0;i<boxArray.length;i++){
                if(boxArray[i].checked){
                    total++;
                }
            }
            $("#checkNum").html(total);
        }
        function  tijiaoForm(){
            var url = "${ctx}/ins/product/list/openProductList?productIds="+$("#productIds").val()+"&companyId=${companyId}"
            var form = $("#productFrom");
             form.attr("action",url);
             form.submit();
        }
    </script>
</bcxinFooter>
</body>
</html>
