<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>

	<%@include file="/WEB-INF/include/head.jsp"%>
</head>
<body>
<div class="container bid">
	<div class="content">
		<h3>基础信息</h3>
		<p class="clearfix"><span class="pull-right">订单状态：${fns:getDictLabel (orderVo.policy_status,"order_status","")}</span></p>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">订单号</li>
					<li class="no-bor">${orderVo.trade_serial_number}</li>
					<li class="no-bor">下单时间</li>
					<li class="no-bor">${fn:substring(orderVo.start_time, 0, fn:length(orderVo.start_time)-3)}</li>
					<li class="no-bor">支付方式</li>
					<li class="no-bor">
						<c:set var="paymentMethods" value="${empty transactionList ? '' : transactionList[0].pay_type}"></c:set>
						${empty paymentMethods ? '' : fns:getDictLabel (paymentMethods,"pay_type","")}
					</li>
					<li class="no-bor">最后支付时间</li>
					<li class="no-bor">
						<c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
						<c:if test="${not empty endTimes }">
							<fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:if>
					</li>
					<li class="no-bor">支付流水号</li>
					<li class="no-bor">
						<c:forEach items="${transactionList}" var="list">
							${list.trade_serial_number}<br/>
						</c:forEach>
						<%--${transactionList.size()>0 ? transactionList.size() : '0'}/${orderVo.pay_methods eq '1' ? '1' : orderVo.pay_methods eq '2' ? '4' : '0'}
						<c:if test="${not empty transactionList}">
							<a href="javascript:void(0)" onclick="member_show('支付详情','${ctx}/ins/policy/initTransactionDetail/${orderVo.oid}','','','900',null)" title="支付详情">
								支付详情
							</a>
						</c:if>--%>
					</li>
					<li class="no-bor">下单帐号</li>
					<li class="no-bor">${orderVo.login_name}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">产品信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">产品名称</li>
					<li class="no-bor" title="${orderVo.product_name}">${orderVo.product_name}</li>
					<li class="no-bor">保费（元）</li>
					<li class="no-bor">${orderVo.gross_premium}</li>
					<li class="no-bor">保险期限</li>
					<li class="no-bor">
						${underwriteVo.deadline}${empty underwriteVo.deadline ? '' : '天'}
					</li>
					<li class="no-bor">生效日期</li>
					<li class="no-bor">${orderVo.inception_date}</li>
					<li class="no-bor">保险地区</li>
					<li class="no-bor">${reg_policy}</li>
					<li class="no-bor">保险金额/赔偿限额</li>
					<li class="no-bor">${orderVo.insured_amount}</li>
				</ul>
				<table class="table ">
					<tbody>
					<tr>
						<td class="col-sm-4 col-xs-4">保障责任</td>
						<td class="col-sm-2 col-xs-2">
							<c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
							<c:choose>
								<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
									保险金额
								</c:when>
								<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
									赔偿限额
								</c:when>
								<c:otherwise>
									保险金额
								</c:otherwise>
							</c:choose>
						</td>
						<td class="col-sm-2 col-xs-2">免赔额</td>
						<td class="col-sm-2 col-xs-2">赔付比例</td>
						<td class="col-sm-2 col-xs-2">免赔天数</td>
					</tr>
					<c:forEach items="${ vo.responsibilityVoList }" var="irp">
						<tr <c:choose>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
								hidden
							</c:when>
							<c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:otherwise>

							</c:otherwise>
						</c:choose>>
							<td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
							<td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
								<c:choose>
									<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:otherwise>
										<span>-</span>
									</c:otherwise>
								</c:choose>
							</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
						</tr>
					</c:forEach>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">投保人/被投保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">投保人/被保险人</li>
					<li class="no-bor" title="${ vo1.roleSubjectList[0].name_cn}">${ vo1.roleSubjectList[0].name_cn}</li>
					<li class="no-bor">申请人/原告主体资格</li>
					<li class="no-bor">${empty vo1.roleSubjectList[0].right_as_principal ? '' : vo1.roleSubjectList[0].right_as_principal eq '1' ? '公民':'法人'}</li>
					<li class="no-bor">证件类型</li>
					<li class="no-bor">${empty vo1.roleSubjectList[0].id_type ? '' : vo1.roleSubjectList[0].id_type eq '1'? '组织机构代码或统一社会信用代码' : '身份证或护照'}</li>
					<li class="no-bor">证件号</li>
					<li class="no-bor">${vo1.roleSubjectList[0].organization_code}</li>
					<li class="no-bor">联系地址</li>
					<li class="no-bor" title="${reg_role}${vo1.roleSubjectList[0].reg_address}">${reg_role}${vo1.roleSubjectList[0].reg_address}</li>
					<li class="no-bor">邮编</li>
					<li class="no-bor">${vo1.roleSubjectList[0].zip_code}</li>
					<li class="no-bor">联系人</li>
					<li class="no-bor" title="${vo1.roleSubjectList[0].link_name}">${vo1.roleSubjectList[0].link_name}</li>
					<li class="no-bor">联系电话</li>
					<li class="no-bor">${vo1.roleSubjectList[0].phone}</li>
					<li class="no-bor">电邮地址</li>
					<li class="wd80">${vo1.roleSubjectList[0].link_email}</li>
				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo1.roleSubjectList[0].app_idcard_path&&vo1.roleSubjectList[0].app_idcard_path.length()>1}">
						<li>
							<img src="${ vo1.roleSubjectList[0].app_idcard_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">身份证复印件</span>
								<a target="_blank" href="${ vo1.roleSubjectList[0].app_idcard_path}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo1.roleSubjectList[0].app_address_path&&vo1.roleSubjectList[0].app_address_path.length()>1}">
						<li>
							<img src="${ vo1.roleSubjectList[0].app_address_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">常住地证明文件复印件</span>
								<a target="_blank" href="${vo1.roleSubjectList[0].app_address_path}">下载</a>
							</p>
						</li>
					</c:if>

					<c:if test="${ not empty vo1.roleSubjectList[0].app_spouse_card_path&&vo1.roleSubjectList[0].app_spouse_card_path.length()>1}">
						<li>
							<img src="${ vo1.roleSubjectList[0].app_spouse_card_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">配偶身份证复印件</span>
								<a target="_blank" href="${ vo1.roleSubjectList[0].app_spouse_card_path}">下载</a>
							</p>
						</li>
					</c:if>

					<c:if test="${ not empty vo1.roleSubjectList[0].app_trauschein_path&&vo1.roleSubjectList[0].app_trauschein_path.length()>1}">
						<li>
							<img src="${ vo1.roleSubjectList[0].app_trauschein_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">结婚证复印件</span>
								<a target="_blank" href="${ vo1.roleSubjectList[0].app_trauschein_path}">下载</a>
							</p>
						</li>
					</c:if>

					<c:if test="${ not empty vo1.roleSubjectList[0].app_business_path&&vo1.roleSubjectList[0].app_business_path.length()>1}">
						<li>
							<img src="${ vo1.roleSubjectList[0].app_business_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">营业执照复印件</span>
								<a target="_blank" href="${ vo1.roleSubjectList[0].app_business_path}">下载</a>
							</p>
						</li>
					</c:if>

				</ul>
			</div>
		</div>
	</div>
	
	<c:if test="${not empty vo1.lnAccusedVo}">
		<c:forEach items="${vo1.lnAccusedVo}" var="ln" varStatus="numpass">
			<div class="content">
				<h3 class="mb20">对方当事人（被告／第三人）基本信息（<c:if test="${numpass.index == 0}">一</c:if><c:if test="${numpass.index == 1}">二</c:if><c:if test="${numpass.index == 2}">三</c:if><c:if test="${numpass.index == 3}">四</c:if><c:if test="${numpass.index == 4}">五</c:if><c:if test="${numpass.index == 5}">六</c:if><c:if test="${numpass.index == 6}">七</c:if><c:if test="${numpass.index == 7}">八</c:if><c:if test="${numpass.index == 8}">九</c:if><c:if test="${numpass.index == 9}">十</c:if>）</h3>
				<div class="row bid-context">
					<div class="col-sm-12">
						<ul class="bid-ul">
							<li class="no-bor">投保人/被保险人</li>
							<li class="no-bor" title="${ln.par_full_name }">
									${ln.par_full_name }
							</li>
							<li class="no-bor">被申请人/被告主体资格</li>
							<li class="no-bor">
									${ ln.par_right_as_principal eq '1' ? '公民':'法人'}
							</li>
							<li class="no-bor">第三人</li>
							<li class="no-bor">
									${ln.par_any_one }
							</li>
							<li class="no-bor">证件类型</li>
							<li class="no-bor">
									${ ln.par_id_type eq '0' ? '身份证或护照':'组织机构代码或统一社会信用代码'}
							</li>
							<li class="no-bor">证件号</li>
							<li class="no-bor">
									${ ln.par_organizing_code}
							</li>
							<li class="no-bor">联系地址</li>
							<li class="no-bor" title="${ ln.par_address}">
									${ ln.par_address}
							</li>
							<li class="no-bor">邮编</li>
							<li class="no-bor">
									${ ln.par_zipcode}
							</li>
							<li class="no-bor">联系人</li>
							<li class="no-bor" title="${ ln.par_name}">
									${ ln.par_name}
							</li>
							<li class="no-bor">联系电话</li>
							<li class="no-bor">
									${ ln.par_phone}
							</li>
							<li class="no-bor">电邮地址</li>
							<li class="no-bor">
									${ ln.par_email}
							</li>
						</ul>
					</div>
					<div class="img-show col-xs-12">
						<ul>
							<c:if test="${ not empty ln.par_idcard_path&&ln.par_idcard_path.length()>1}">
								<li>
									<img src="${ ln.par_idcard_path}" alt="1" style="width: 100px;"/>
									<p>
										<span class="pull-left">身份证复印件</span>
										<a target="_blank" href="${ ln.par_idcard_path}">下载</a>
									</p>
								</li>
							</c:if>
							<c:if test="${ not empty ln.par_address_path&&ln.par_address_path.length()>1}">
								<li>
									<img src="${ ln.par_address_path}" alt="1" style="width: 100px;"/>
									<p>
										<span class="pull-left">常住地证明文件复印件</span>
										<a target="_blank" href="${ ln.par_address_path}">下载</a>
									</p>
								</li>
							</c:if>
							<c:if test="${ not empty ln.par_spouse_card_path&&ln.par_spouse_card_path.length()>1}">
								<li>
									<img src="${ ln.par_spouse_card_path}" alt="1" style="width: 100px;"/>
									<p>
										<span class="pull-left">配偶身份证复印件</span>
										<a target="_blank" href="${ ln.par_spouse_card_path}">下载</a>
									</p>
								</li>
							</c:if>
							<c:if test="${ not empty ln.par_trauschein_path&&ln.par_trauschein_path.length()>1}">
								<li>
									<img src="${ ln.par_trauschein_path}" alt="1" style="width: 100px;"/>
									<p>
										<span class="pull-left">结婚证复印件</span>
										<a target="_blank" href="${ ln.par_trauschein_path}">下载</a>
									</p>
								</li>
							</c:if>
							<c:if test="${ not empty ln.par_business_path&&ln.par_business_path.length()>1}">
								<li>
									<img src="${ ln.par_business_path}" alt="1" style="width: 100px;"/>
									<p>
										<span class="pull-left">营业执照复印件</span>
										<a target="_blank" href="${ ln.par_business_path}">下载</a>
									</p>
								</li>
							</c:if>

						</ul>
					</div>
				</div>
			</div>
		</c:forEach>
	</c:if>

	<div class="content">
		<h3 class="mb20">案件信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">所在地区</li>
					<li class="no-bor" title="${reg_policy}">${reg_policy}</li>
					<li class="no-bor">律师事务所</li>
					<li class="no-bor" title="${vo1.law_firm}">${vo1.law_firm}</li>
					<li class="no-bor">保全类型</li>
					<li class="no-bor">${empty vo1.preserve_type ? '':vo1.preserve_type eq '1'? '诉讼前财产保全':'诉讼中财产保全'}</li>
					<li class="no-bor">案件审理法院</li>
					<li class="no-bor" title="${vo1.court}">${vo1.court}</li>
					<li class="no-bor">案号</li>
					<li class="wd80 no-bor">${vo1.reference}</li>
					<li class="he80">案由</li>
					<li class="wd80 he80">${vo1.brief}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">申请保全的财产信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li>申请保全的财产价值</li>
					<li class="wd80">${vo1.valuation}</li>
					<li class="wd100">申请保全的财产类别</li>
					<li class="wd20 bg" style="height: 80px">房产</li>
					<li class="wd60" style="height: 80px;line-height: 20px;text-align: left;padding: 5px 10px;">${vo1.house_address}</li>
					<li class="wd20 rig-bor" style="height: 80px">
						<c:if test="${not empty vo1.house_claims}">
						    <a target="_blank" href="${vo1.house_claims}">下载附件</a>
						</c:if>
                    </li>
					<li class="wd20 bg" style="height: 80px">现金/银行账户</li>
					<li class="wd60" style="height: 80px;line-height: 20px;text-align: left;padding: 5px 10px;">${vo1.cash_address}</li>
					<li class="wd20 rig-bor" style="height: 80px">
						<c:if test="${not empty vo1.cash_claims}">
							<a target="_blank" href="${vo1.cash_claims}">下载附件</a>
						</c:if>
					</li>
					<li class="wd20 bg" style="height: 80px">机器设备</li>
					<li class="wd60" style="height: 80px;line-height: 20px;text-align: left;padding: 5px 10px;">${vo1.facility_address}</li>
					<li class="wd20 rig-bor" style="height: 80px">
						<c:if test="${not empty vo1.facility_claims}">
							<a target="_blank" href="${vo1.facility_claims}">下载附件</a>
						</c:if>
					</li>
					<li class="wd20 bg" style="height: 80px">汽车/工程机械</li>
					<li class="wd60" style="height: 80px;line-height: 20px;text-align: left;padding: 5px 10px;">${vo1.instrument_address}</li>
					<li class="wd20 rig-bor" style="height: 80px">
						<c:if test="${not empty vo1.instrument_claims}">
							<a target="_blank" href="${vo1.instrument_claims}">下载附件</a>
						</c:if>
					</li>
					<li class="wd20 bg bor-btm" style="height: 80px">其它标的</li>
					<li class="wd60 bor-btm" style="height: 80px;line-height: 20px;text-align: left;padding: 5px 10px;">${vo1.otherobject_address}</li>
					<li class="wd20 rig-bor bor-btm" style="height: 80px">
						<c:if test="${not empty vo1.otherobject_claims}">
							<a target="_blank" href="${vo1.otherobject_claims}">下载附件</a>
						</c:if>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">案件资料</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li>《起诉状》原件（盖公章）</li>
					<li class="wd80">
						<c:if test="${not empty vo3.qs_subfile_original}">
							<a target="_blank" href="${vo3.qs_subfile_original}">下载附件</a>
						</c:if>
					</li>
					<li>证据目录及证据（证据须标明来源、有无原件）</li>
					<li class="wd80">
						<c:if test="${not empty vo3.qs_subfile_proof}">
							<a target="_blank" href="${vo3.qs_subfile_proof}">下载附件</a>
						</c:if>
					</li>
					<li>《保全申请书》</li>
					<li class="wd80">
						<c:if test="${not empty vo3.bq_subfile_apply}">
							<a target="_blank" href="${vo3.bq_subfile_apply}">下载附件</a>
						</c:if>
					</li>
					<li>财产线索</li>
					<li class="wd80">
						<c:if test="${not empty vo3.bq_subfile_clew}">
							<a target="_blank" href="${vo3.bq_subfile_clew}">下载附件</a>
						</c:if>
					</li>
					<li>受理案件通知书</li>
					<li class="wd80">
						<c:if test="${not empty vo3.sl_subfile_accepted}">
							<a target="_blank" href="${vo3.sl_subfile_accepted}">下载附件</a>
						</c:if>
					</li>
					<li>诉讼须知、举证通知书</li>
					<li class="wd80">
						<c:if test="${not empty vo3.sl_subfile_notice}">
							<a target="_blank" href="${vo3.sl_subfile_notice}">下载附件</a>
						</c:if>
					</li>
					<li>告知审判庭组成人员通知书</li>
					<li class="wd80">
						<c:if test="${not empty vo3.sl_subfile_tell}">
							<a target="_blank" href="${vo3.sl_subfile_tell}">下载附件</a>
						</c:if>
					</li>
					<li>补充资料1</li>
					<li class="wd80">
						<c:if test="${not empty vo3.supplement_a}">
							<a target="_blank" href="${vo3.supplement_a}">下载附件</a>
						</c:if>
					</li>
					<li>补充资料2</li>
					<li class="wd80">
						<c:if test="${not empty vo3.supplement_b}">
							<a target="_blank" href="${vo3.supplement_b}">下载附件</a>
						</c:if>
					</li>
					<li>补充资料3</li>
					<li class="wd80">
						<c:if test="${not empty vo3.supplement_c}">
							<a target="_blank" href="${vo3.supplement_c}">下载附件</a>
						</c:if>
					</li>
					<li>补充资料4</li>
					<li class="wd80">
						<c:if test="${not empty vo3.supplement_d}">
							<a target="_blank" href="${vo3.supplement_d}">下载附件</a>
						</c:if>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<!-- 票单信息 start -->
	<div class="content">
		<h3 class="mb20">单证信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">是否需要纸质保单</li>
					<li class="no-bor">
						${vo2.mailPolicyVo.need_insur_bill eq '0' ? '否' : '是'}
					</li>
					<li class="no-bor">收件人</li>
					<li class="no-bor">
						${ vo2.mailPolicyVo.receiver_name}
					</li>
					<li class="no-bor">收件人手机</li>
					<li class="no-bor">
						${ vo2.mailPolicyVo.receiver_mobile}
					</li>
					<li class="no-bor">收件地址</li>
					<li class="no-bor">
						${ vo2.mailPolicyVo.receiver_address_detail}
					</li>
					<li class="no-bor">是否需要纸质发票</li>
					<li class="no-bor">
						${vo2.mailPolicyVo.need_receipt eq '0' ? '否' : '是'}
					</li>
					<li class="no-bor">发票种类</li>
					<li class="no-bor">
						${vo2.mailPolicyVo.need_receipt eq '0' ? '' : vo2.mailPolicyVo.invoice_type eq '0' ? '增值税普通发票' : '增值税专用发票'}
					</li>
					<c:if test="${vo2.mailPolicyVo.invoice_type eq '0'}">
						<li class="no-bor">收件单位</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.receipt_head}">
							${ vo2.mailPolicyVo.receipt_head}
						</li>
						<li class="no-bor">收件人</li>
						<li class="no-bor">
							${ vo2.mailPolicyVo.taker_name}
						</li>
						<li class="no-bor">收件人手机</li>
						<li class="no-bor">
							${ vo2.mailPolicyVo.taker_mobile}
						</li>
						<li class="no-bor">收件地址</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.taker_address_detail}">
							${ vo2.mailPolicyVo.taker_address_detail}
						</li>
						<li class="no-bor">纳税人识别号</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.taxpayer_number_invoice}">
								${ vo2.mailPolicyVo.taxpayer_number_invoice}
						</li>
					</c:if>
					<c:if test="${vo2.mailPolicyVo.invoice_type eq '1'}">
						<li class="no-bor">纳税人识别号</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.taxpayer_number_invoice}">
								${ vo2.mailPolicyVo.taxpayer_number_invoice}
						</li>
						<li class="no-bor">注册地址</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.register_address_invoice}">
								${ vo2.mailPolicyVo.register_address_invoice}
						</li>
						<li class="no-bor">开户银行</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.bank_invoice}">
								${ vo2.mailPolicyVo.bank_invoice}
						</li>
						<li class="no-bor">电话</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.receipt_phone}">
								${ vo2.mailPolicyVo.receipt_phone}
						</li>
						<li class="no-bor">银行账号</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.bank_account_invoice}">
								${ vo2.mailPolicyVo.bank_account_invoice}
						</li>
					</c:if>
				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo2.mailPolicyVo.tax_cert}">
						<li>
							<img src="${ vo2.mailPolicyVo.tax_cert}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">税务登记证</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.tax_cert}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.tax_prove}">
						<li>
							<img src="${ vo2.mailPolicyVo.tax_prove}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">一般纳税人证明</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.tax_prove}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.bank_licence}">
						<li>
							<img src="${ vo2.mailPolicyVo.bank_licence}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">银行开户许可证</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.bank_licence}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.business_license}">
						<li>
							<img src="${ vo2.mailPolicyVo.business_license}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">营业执照副本</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.business_license}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.auth_cert}">
						<li>
							<img src="${ vo2.mailPolicyVo.auth_cert}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">增票授权委托书</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.auth_cert}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
	<!-- 票单信息  end -->
<c:if test="${ not empty orderVo.external_reference && not empty orderVo.insure_path}">
	<div class="content">
		<h3 class="mb20">保单信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li> 电子保单</li>
					<li class="wd80">
						<a target="_blank" href="${orderVo.insure_path}">查看</a>
					</li>
				</ul>
			</div>
		</div>
	</div>
</c:if>
	<c:if test="${ not empty orderVo.remarks}">
		<div class="content">
			<h3 class="mb20">其它</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li> 备注</li>
						<li class="wd80">
								${ orderVo.remarks}
						</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<%--<div class="operation">
		<div class="row oper-deta">
			<div class="col-xs-12">
				<h3>操作记录</h3>
				<ul class="detail">
					<li class="bc">操作时间</li>
					<li class="bc">操作人员</li>
					<li class="bc">操作事项</li>
					<li class="bc">备注</li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
				</ul>
			</div>
		</div>
	</div>--%>
	<%--<div class="examine text-center">
		<a class="btn btn-long btn-lightgreen">核保/承保</a>
		<a class="btn btn-long btn-lightgreen">票单配送</a>
	</div>--%>
</div>

<script type="text/javascript" src="${ctxsta}/admin/product/js/jquery-1.11.3.js"></script>
<script>
    $(function(){
        function lineHeight(name){
            var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
            $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
        }
        lineHeight("big");
        lineHeight("img-look");
        lineHeight("addr");
        lineHeight("day");
    })
</script>
</body>
</html>
