<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>订单详情</title>
	<%@include file="/WEB-INF/include/head.jsp"%>
</head>
<body class="gray-bg">
	<div class="wrapper animated fadeInRight">
		<div class="row">
			<div class="col-sm-12">
				<div class="ibox float-e-margins">
					<!-- 基础信息 start -->
					<div class="ibox-title">
						<h5> 订单信息</h5>
					</div>
					<div class="ibox-content">
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">状态：</label>
							<div class="col-sm-4">
								${fns:getDictLabel (orderVo.policy_status,"order_status","")}
							</div>
						</div>	
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">订单号：</label>
							<div class="col-sm-4">
								${orderVo.trade_serial_number}
							</div>
							<label class="col-sm-2 control-label">下单时间：</label>
							<div class="col-sm-4">
								${fn:substring(orderVo.start_time, 0, fn:length(orderVo.start_time)-3)}
							</div>
						</div>
                        <div class="form-group">

                            <label class="col-sm-2 control-label">支付方式：</label>
                            <div class="col-sm-4">
                                <c:set var="paymentMethods" value="${empty transactionList ? '' : transactionList[0].pay_type}"></c:set>
                                ${empty paymentMethods ? '-' : fns:getDictLabel (paymentMethods,"pay_type","")}
                            </div>
                            <label class="col-sm-2 control-label">最后支付时间：</label>
                            <div class="col-sm-4">
                                <c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
                                <c:if test="${not empty endTimes }">
                                    <fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
                                </c:if>
                            </div>
                        </div>
                        <div class="form-group">

                            <label class="col-sm-2 control-label">支付期数：</label>
                            <div class="col-sm-4">
                                ${empty transactionList ? '-' : transactionList.size()}
								${orderVo.pay_methods eq '2' ? '/4' : '/1'}
                                <c:if test="${not empty transactionList}">
                                    <a href="javascript:void(0)" onclick="member_show('支付详情','${ctx}/ins/policy/initTransactionDetail/${orderVo.oid}','','','900',null)" title="支付详情">
                                        支付详情
                                    </a>
                                </c:if>
                            </div>
							<label class="col-sm-2 control-label">下单帐号：</label>
							<div class="col-sm-4">${orderVo.login_name}</div>
						</div>
					</div>
					<!-- 基础信息 end -->

					<!-- 产品信息  start-->
					<div class="ibox-title">
						<h5> 产品信息 </h5>
					</div>
					<div class="ibox-content">
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">产品名称：</label>
							<div class="col-sm-4">
								${orderVo.product_name}
							</div>
							<label class="col-sm-2 control-label">保费（元）：</label>
							<div class="col-sm-4">
								${orderVo.gross_premium}
							</div>
						</div>
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">保险期限：</label>
							<div class="col-sm-10">
								一年
                            </div>
						</div>
					</div>
					<!-- 基础信息 end -->

					<!-- 投保人信息 start -->
					<div class="ibox-title">
						<h5>投保人信息</h5>
					</div>
					<div class="ibox-content">
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">公司名称（中文）：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].name_cn}
								</div>
								<label class="col-sm-2 control-label">公司名称（英文）：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].name_en}
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">企业注册号：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].aaum_code}
								</div>
								<label class="col-sm-2 control-label">成立日期：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].register_date}
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">注册地址：</label>
								<div class="col-sm-4">
									${reg_role}${vo1.roleSubjectList[0].reg_address}
								</div>
								<label class="col-sm-2 control-label">联系人：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].link_name}
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">企业性质：</label>
								<div class="col-sm-4">
									${fns:getDictLabel (vo1.roleSubjectList[0].com_type,"comType","")}
								</div>
								<label class="col-sm-2 control-label">联系人职务：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].link_duty}
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">电话：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].link_phone}
								</div>
								<label class="col-sm-2 control-label">传真：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].link_fax}
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">电邮地址：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].link_email}
								</div>
								<label class="col-sm-2 control-label"> 投保业务类别</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].business_nature}
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">买方所属行业：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].sectors_sold}
								</div>
								<label class="col-sm-2 control-label"> 投保人关联企业信息</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].companies_detail}
								</div>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">是否已有信用险保单：</label>
								<div class="col-sm-4">
									${ vo1.roleSubjectList[0].id_insurance == 0 ? '否NO':'是YES'}
								</div>
								<c:if test="${ vo1.roleSubjectList[0].id_insurance == 1}">
								<label class="col-sm-2 control-label">已有保单所属保险公司：</label>
								<div class="col-sm-4">
									${vo1.roleSubjectList[0].insurance_name }
								</div>
								</c:if>
							</div>
							<div class="hr-line-dashed"></div>
							<div class="form-group">
								<label class="col-sm-2 control-label">投保币种：</label>
								<div class="col-sm-4">
									${fns:getDictLabel (vo1.roleSubjectList[0].currency_required,"currencyRequired","")}
								</div>
								<label class="col-sm-2 control-label">预计未来12个月的 投保营业额：</label>
								<div class="col-sm-4">
									内贸：${ vo1.roleSubjectList[0].turnover_domestic}，出口：${ vo1.roleSubjectList[0].turnover_export}
								</div>
							</div>
					</div>
				</div>
				<!-- 投保人资料 end -->
				<!-- 投保业务情况说明 start -->
				<div class="ibox-title">
					<h5> 投保业务情况说明 </h5>
				</div>
				<div class="ibox-content">
					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">保障的产品或服务：</label>
						<div class="col-sm-4">
							${vo1.product_service}
						</div>
						<label class="col-sm-2 control-label">合同是否有物权保留条款：</label>
						<div class="col-sm-4">
							${ vo1.is_retention_contract == 0 ? '否NO':'是YES'}
						</div>
					</div>
					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">销售常用付款方式：</label>
						<div class="col-sm-4">
							${fns:getDictLabel(vo1.payment_terms,"paymentTerms","")}
						</div>
						<label class="col-sm-2 control-label">是否提供赊账期：</label>
						<div class="col-sm-4">
							${ vo1.period_extended}
						</div>
					</div>
					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">业务特殊性说明:：</label>
						<div class="col-sm-10">
							${vo1.particularity}
						</div>
					</div>
				</div>
				<!-- 投保业务情况说明 end -->
				<!-- 销售额 start -->
				<div class="ibox-title">
					<h5> 销售额 </h5>
				</div>
				<div class="ibox-content">
					<table class="table table-bordered">
						<tr>
							<th colspan="3">最近三年销售额</th>
							<th colspan="3">上一财年出口销售方式占比</th>
						</tr>
						<tbody>
							<tr>
								<td>账务年度</td>
								<td>国内贸易金额</td>
								<td>出口贸易金额</td>
								<td>现金交易占比</td>
								<td colspan="2">${vo1.breakdowns_cash}</td>
							</tr>
							<tr>
								<td>${vo1.recentYearsSellList[0].financial_year}</td>
	                            <td>${vo1.recentYearsSellList[0].domestic}</td>
	                            <td>${vo1.recentYearsSellList[0].export}</td> 
								<td>信用证交易占比</td>
								<td colspan="2">${vo1.breakdowns_lc}</td>
							</tr>
							<tr>
								<td>${vo1.recentYearsSellList[1].financial_year}</td>
	                            <td>${vo1.recentYearsSellList[1].domestic}</td>
	                            <td>${vo1.recentYearsSellList[1].export}</td> 
								<td>关联交易占比</td>
								<td colspan="2">${vo1.breakdowns_associated}</td>
							</tr>
							<tr>
								<td>${vo1.recentYearsSellList[2].financial_year}</td>
	                            <td>${vo1.recentYearsSellList[2].domestic}</td>
	                            <td>${vo1.recentYearsSellList[2].export}</td> 
								<td>赊账交易占比</td>
								<td colspan="2">${vo1.breakdowns_oa}</td>
							</tr>
							<tr>
								<td></td>
								<td></td>
								<td></td>
								<td>托收交易占比</td>
								<td colspan="2">${vo1.breakdowns_dpda}</td>
							</tr>
							<tr>
								<td></td>
								<td></td>
								<td></td>
								<td>合计</td>
								<td colspan="2">${vo1.breakdowns_sum}</td>
							</tr>
							<tr>
								<td colspan="6">预计下一保险期间须投保信用销售总额</td>
							</tr>
							<tr>
								<td>国别</td>
								<td>年销售额</td>
								<td colspan="2">赊账期内最高的曝险赊销金额</td>
								<td>买家个数</td>
								<td>付款方式</td>
							</tr>
							<c:forEach items="${ vo1.forecastedDetailList }" varStatus="index">
	                        <tr>
	                            <td>${ vo1.forecastedDetailList[index.index].country}</td>
	                            <td>${ vo1.forecastedDetailList[index.index].annual_sales}</td>
	                            <td colspan="2">${ vo1.forecastedDetailList[index.index].hca}</td> 
	                            <td>${ vo1.forecastedDetailList[index.index].buyers_num}</td>
	                            <td>${fns:getDictLabel (vo1.forecastedDetailList[index.index].payment_terms,"paymentTerms","")}</td>
	                        </tr>
	                        </c:forEach>
						</tbody>
					</table>
				</div>
				<!-- 销售额  end-->
				<!-- 应收账款余额分布 start -->
				<div class="ibox-title">
					<h5> 应收账款余额分布 </h5>
				</div>
				<div class="ibox-content">
					<table class="table table-bordered">
						<thead>
							<tr>
								<th colspan="5">应收账款余额统计截止日期：${vo2.ar_as_of}</th>
							</tr>
							<tr>
								<th rowspan="2">未尝债务区间：</th>
								<th colspan="2">内贸</th>
								<th colspan="2">出口</th>
							</tr>
							<tr>
								<th>未偿债务总额</th>
								<th>债务人数量</th>
								<th>未偿债务总额</th>
								<th>债务人数量</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>1-10,000</td>
								<td>${vo2.arDebtorsList[0].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[0].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[0].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[0].export_total}</td>
							</tr>
							<tr>
								<td>10,001-20,000</td>
								<td>${vo2.arDebtorsList[1].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[1].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[1].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[1].export_total}</td>
							</tr>
							<tr>
								<td>20,001-50,000</td>
								<td>${vo2.arDebtorsList[2].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[2].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[2].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[2].export_total}</td>
							</tr>
							<tr>
								<td>50,001-100,000</td>
								<td>${vo2.arDebtorsList[3].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[3].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[3].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[3].export_total}</td>
							</tr>
							<tr>
								<td>100,001-500,000</td>
								<td>${vo2.arDebtorsList[4].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[4].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[4].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[4].export_total}</td>
							</tr>
							<tr>
								<td>500,001-1,000,000</td>
								<td>${vo2.arDebtorsList[5].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[5].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[5].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[5].export_total}</td>
							</tr>
							<tr>
								<td>1,000,001-5,000,000</td>
								<td>${vo2.arDebtorsList[6].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[6].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[6].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[6].export_total}</td>
							</tr>
							<tr>
								<td>5,000,000-∞</td>
								<td>${vo2.arDebtorsList[7].domestic_total}</td>
                            	<td>${vo2.arDebtorsList[7].domestic_buyers}</td>
								<td>${vo2.arDebtorsList[7].export_buyers}</td> 
                            	<td>${vo2.arDebtorsList[7].export_total}</td>
							</tr>
							<tr>
								<td>总计</td>
								<td>${vo2.domestic_total_sum}</td>
	                            <td>${vo2.domestic_buyers_sum}</td>
	                            <td>${vo2.export_buyers_sum}</td> 
	                            <td>${vo2.export_total_sum}</td>
							</tr>
						</tbody>
					</table>
				</div>
				<!-- 应收账款余额分布end -->

				<!-- 账龄及坏账日期 start -->
				<div class="ibox-title">
					<h5> 账龄及坏账日期 </h5>
				</div>
				<div class="ibox-content">
					<table class="table table-bordered">
						<thead>
							<tr>
								<th colspan="5">账龄及坏账统计截止日期：${vo2.as_of}</th>
							</tr>
							<tr>
								<th>企业销售变现天数：</th>
								<th colspan="2">内贸：${vo2.domestics}</th>
								<th colspan="2">出口：${vo2.exports}</th>
							</tr>
							<tr>
								<th>账龄分布</th>
								<th>内贸坏账金额</th>
								<th>内贸坏账占比</th>
								<th>外贸坏账金额</th>
								<th>外贸坏账占比</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>未到期</td>
								<td>${vo2.debtAgesList[0].domestic_amount}</td>
	                            <td>${vo2.debtAgesList[0].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[0].domestic_percentage}">%</c:if></td>
	                            <td>${vo2.debtAgesList[0].export_amount}</td>
	                            <td>${vo2.debtAgesList[0].export_percentage}<c:if test="${not empty vo2.debtAgesList[0].export_percentage}">%</c:if></td> 
							</tr>
							<tr>
								<td>超期01-30天</td>
								<td>${vo2.debtAgesList[1].domestic_amount}</td>
	                            <td>${vo2.debtAgesList[1].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[0].domestic_percentage}">%</c:if></td>
	                            <td>${vo2.debtAgesList[1].export_amount}</td>
	                            <td>${vo2.debtAgesList[1].export_percentage}<c:if test="${not empty vo2.debtAgesList[0].export_percentage}">%</c:if></td> 
							</tr>
							<tr>
								<td>超期31-60天</td>
								<td>${vo2.debtAgesList[2].domestic_amount}</td>
	                            <td>${vo2.debtAgesList[2].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[0].domestic_percentage}">%</c:if></td>
	                            <td>${vo2.debtAgesList[2].export_amount}</td>
	                            <td>${vo2.debtAgesList[2].export_percentage}<c:if test="${not empty vo2.debtAgesList[0].export_percentage}">%</c:if></td> 
							</tr>
							<tr>
								<td>超期61-90天</td>
								<td>${vo2.debtAgesList[3].domestic_amount}</td>
	                            <td>${vo2.debtAgesList[3].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[0].domestic_percentage}">%</c:if></td>
	                            <td>${vo2.debtAgesList[3].export_amount}</td>
	                            <td>${vo2.debtAgesList[3].export_percentage}<c:if test="${not empty vo2.debtAgesList[0].export_percentage}">%</c:if></td> 
							</tr>
							<tr>
								<td>超期＞90天</td>
								<td>${vo2.debtAgesList[4].domestic_amount}</td>
	                            <td>${vo2.debtAgesList[4].domestic_percentage}<c:if test="${not empty vo2.debtAgesList[0].domestic_percentage}">%</c:if></td>
	                            <td>${vo2.debtAgesList[4].export_amount}</td>
	                            <td>${vo2.debtAgesList[4].export_percentage}<c:if test="${not empty vo2.debtAgesList[0].export_percentage}">%</c:if></td> 
							</tr>
							<tr>
								<td>合计</td>
								<td>${vo2.domestic_amount_sum}</td>
	                            <td>${vo2.domestic_percentage_sum}<c:if test="${not empty vo2.domestic_percentage_sum}">%</c:if></td>
	                            <td>${vo2.export_amount_sum}</td>
	                            <td>${vo2.export_percentage_sum}<c:if test="${not empty vo2.export_percentage_sum}">%</c:if></td>
							</tr>
							<tr>
	                            <td colspan="4">是否已有买方逾期31天以上?</td>
	                            <td>${vo2.is_overdue_buyers == 0 ? '否NO':'是YES'}</td>
	                        </tr> 
	                        <c:if test="${ vo2.is_overdue_buyers == 1 }">
							<tr>
								<td colspan="5">买方逾期31天以上信息</td>
							</tr>
							<tr>
								<th>买方名称/买方国家</th>
								<th>总账款余额</th>
								<th>逾期账款金额</th>
								<th>逾期账款最早到期日</th>
								<th>已执行的催收方案</th>
							</tr>
							<c:forEach items="${ vo2.overdueDetailList }" varStatus="index">
	                        <tr>
	                            <td>${vo2.overdueDetailList[index.index].country}</td>
	                            <td>${vo2.overdueDetailList[index.index].total_debt}</td>
	                            <td>${vo2.overdueDetailList[index.index].debt}</td> 
	                            <td>${vo2.overdueDetailList[index.index].due_date}</td>
	                            <td>${vo2.overdueDetailList[index.index].taken}</td> 
	                        </tr> 
	                        </c:forEach>
	                        </c:if>
							<tr>
								<td colspan="5">坏账分析</td>
							</tr>
							<tr>
								<th>财务年度</th>
								<th>年度坏账损失总计金额</th>
								<th>年度最大单个坏账损失金额</th>
								<th>年度坏账损失个数</th>
								<th>成功追回款项金额</th>
							</tr>
							<tr>
	                            <td>${vo2.badAnalysisList[0].year}</td>
	                            <td>${vo2.badAnalysisList[0].bad_debt_total}</td>
	                            <td>${vo2.badAnalysisList[0].bad_debt_loss}</td>
	                            <td>${vo2.badAnalysisList[0].bad_debt_number}</td>
	                            <td>${vo2.badAnalysisList[0].take_back_amount}</td>
	                        </tr> 
	                        <tr>
	                            <td>${vo2.badAnalysisList[1].year}</td>
	                            <td>${vo2.badAnalysisList[1].bad_debt_total}</td>
	                            <td>${vo2.badAnalysisList[1].bad_debt_loss}</td>
	                            <td>${vo2.badAnalysisList[1].bad_debt_number}</td>
	                            <td>${vo2.badAnalysisList[1].take_back_amount}</td>
	                        </tr> 
	                        <tr>
	                            <td>${vo2.badAnalysisList[2].year}</td>
	                            <td>${vo2.badAnalysisList[2].bad_debt_total}</td>
	                            <td>${vo2.badAnalysisList[2].bad_debt_loss}</td>
	                            <td>${vo2.badAnalysisList[2].bad_debt_number}</td>
	                            <td>${vo2.badAnalysisList[2].take_back_amount}</td>
	                        </tr> 
							<tr>
								<td colspan="5">过去三年三笔最大呆坏账详情</td>
							</tr>
							<tr>
								<th>债务人（姓名及地址）</th>
								<th>年份</th>
								<th>债务人所属国家</th>
								<th>付款方式</th>
								<th>坏账原因</th>
								<th>坏账金额</th>
								<th>处理现状</th>
							</tr>
							<tr>
	                            <td>${vo2.pastBadDetailList[0].debtor}</td>
	                            <td>${vo2.pastBadDetailList[0].before_year}</td>
	                            <td>${vo2.pastBadDetailList[0].country}</td>
	                            <td>${vo2.pastBadDetailList[0].payment_terms}</td>
	                            <td>${vo2.pastBadDetailList[0].reason}</td>
	                            <td>${vo2.pastBadDetailList[0].debtamount}</td>
	                            <td>${vo2.pastBadDetailList[0].bad_status}</td>
	                        </tr>
	                        <tr>
	                            <td>${vo2.pastBadDetailList[1].debtor}</td>
	                            <td>${vo2.pastBadDetailList[1].before_year}</td>
	                            <td>${vo2.pastBadDetailList[1].country}</td>
	                            <td>${vo2.pastBadDetailList[1].payment_terms}</td>
	                            <td>${vo2.pastBadDetailList[1].reason}</td>
	                            <td>${vo2.pastBadDetailList[1].debtamount}</td>
	                            <td>${vo2.pastBadDetailList[1].bad_status}</td>
	                        </tr>
	                        <tr>
	                            <td>${vo2.pastBadDetailList[2].debtor}</td>
	                            <td>${vo2.pastBadDetailList[2].before_year}</td>
	                            <td>${vo2.pastBadDetailList[2].country}</td>
	                            <td>${vo2.pastBadDetailList[2].payment_terms}</td>
	                            <td>${vo2.pastBadDetailList[2].reason}</td>
	                            <td>${vo2.pastBadDetailList[2].debtamount}</td>
	                            <td>${vo2.pastBadDetailList[2].bad_status}</td>
	                        </tr>
						</tbody>
					</table>
				</div>
				<!-- 账龄及坏账日期   end -->

				<!-- 投保的前十大买家 start -->
				<div class="ibox-title">
					<h5> 投保的前十大买家 </h5>
				</div>
				<div class="ibox-content">
					<table class="table table-bordered">
						<thead>
							<tr>
								<th>买家名称</th>
								<th>买家地址</th>
								<th>买家所属国家</th>
								<th>付款方式</th>
								<th>单一买家年度赊销金额</th>
								<th>拟保障的单一买家 最高信用限额</th>
							</tr>
						</thead>
						<tbody>
							<c:forEach items="${ vo2.topBuyersList }" varStatus="index">
	                        <tr>
	                            <td>${vo2.topBuyersList[index.index].customer_name}</td>
	                            <td>${vo2.topBuyersList[index.index].address}</td>
	                            <td>${vo2.topBuyersList[index.index].country}</td>
	                            <td>${fns:getDictLabel (vo2.topBuyersList[index.index].payment_terms,"paymentTerms","")}</td>
	                            <td>${vo2.topBuyersList[index.index].credit_amount}</td>
	                            <td>${vo2.topBuyersList[index.index].amount_requested}</td>
	                        </tr>
	                        </c:forEach>
							<tr>
								<td colspan="3">是否同意保险公司联系买家并透露投保人名字</td>
								<td colspan="3">${vo2.is_disclose_name == 0 ? '否NO':'是YES'}</td>
							</tr>
						</tbody>
					</table>
				</div>
				<!-- 投保的前十大买家  end -->
				<!-- 企业信用管理信息  start -->
				<div class="ibox-title">
					<h5> 企业信用管理信息 </h5>
				</div>
				<div class="ibox-content">
					<table class="table table-bordered">
						<thead>
							<tr>
								<th colspan="4">发票开具时间</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>货物发送日后几天</td>
								<td>${vo3.delivery}</td>
								<td>其它时间</td>
								<td>${vo3.other_date}</td>
							</tr>
						</tbody>
					</table>
					<table class="table table-bordered">
						<thead>
							<tr>
								<th colspan="3">信用风险管控人资料</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>信用风险管控人职务名称</td>
								<td>信用风险管控人职务范围</td>
								<td>信用风险管控人授权等级</td>
							</tr>
							<tr>
	                            <td>${vo3.managerDetailList[0].job_title}&nbsp;</td>
	                            <td>${vo3.managerDetailList[0].responsibility}</td> 
	                            <td>${vo3.managerDetailList[0].level}</td> 
	                        </tr>
	                        <tr>
	                            <td>${vo3.managerDetailList[1].job_title}&nbsp;</td>
	                            <td>${vo3.managerDetailList[1].responsibility}</td> 
	                            <td>${vo3.managerDetailList[1].level}</td> 
	                        </tr>
	                        <tr>
	                            <td>${vo3.managerDetailList[2].job_title}&nbsp;</td>
	                            <td>${vo3.managerDetailList[2].responsibility}</td> 
	                            <td>${vo3.managerDetailList[2].level}</td> 
	                        </tr>
						</tbody>
					</table>
					<table class="table table-bordered">
						<tbody>
							<tr>
								<td>是否每一客户都被授予内部信用额度</td>
								<td>${ vo3.is_creditlimit == 0 ? '否NO':'是YES'}</td>
							</tr>
							<tr>
								<td colspan="2">内部信用额度审批所依据信息的主要获取渠道（如付款表现，企业年报，实地拜访等），并陈述针对新买方/已有买方如何应用。</td>
							</tr>
							<tr>
								<td colspan="2">${ vo3.provide_details}</td>
							</tr>
							<tr>
								<td colspan="2"><c:if test="${not empty vo3.material_path}"><a href="javascript:void(0);" onclick="sodownload('${ vo3.material_path}','补充材料');">补充材料下载</a></c:if></td>
							</tr>
						</tbody>
					</table>
					<table class="table table-bordered">
						<tbody>
							<tr>
								<td>应收账款催收方式</td>
								<td>是/否</td>
								<td>自到期日至采取行动日的天数</td>
							</tr>
							<tr>
								<td>到期日前致电客户</td>
								<td>${ vo3.is_expire_before == 0 ? '否NO':'是YES'}</td>
                             	<td>${ vo3.expire_before_now}</td>
							</tr>
							<tr>
								<td>到期日后致电客户</td>
								<td>${ vo3.is_expire_after == 0 ? '否NO':'是YES'}</td>
                             	<td>${ vo3.now_expire_after}</td>
							</tr>
							<tr>
								<td>催收信函</td>
								<td>${ vo3.is_chasing_letters == 0 ? '否NO':'是YES'}</td>
                             	<td>${ vo3.chasing_letters}</td>
							</tr>
							<tr>
								<td>暂停发货</td>
								<td>${ vo3.is_deliveries_suspended == 0 ? '否NO':'是YES'}</td>
                             	<td>${vo3.deliveries_suspended_day}</td>
							</tr>
							<tr>
								<td>实地拜访</td>
								<td>${ vo3.is_visits == 0 ? '否NO':'是YES'}</td>
                             	<td>${ vo3.visits_day}</td>
							</tr>
							<tr>
								<td>委托追帐公司</td>
								<td>${ vo3.is_debt_collectors == 0 ? '否NO':'是YES'}</td>
                             	<td>${ vo3.debt_collectors_day}</td>
							</tr>
							<tr>
								<td>诉诸法律手段</td>
								<td>${ vo3.is_legal_action == 0 ? '否NO':'是YES'}</td>
                             	<td>${ vo3.legal_action_day}</td>
							</tr>
							<tr>
								<td>其它 – 请详述</td>
								<td>${vo3.is_others == 0 ? '否NO':'是YES'}</td>
                             	<td>${vo3.others_day}</td>
							</tr>
						</tbody>
					</table>
				</div>
				<!-- 企业信用管理信息  end -->
				<!-- 争议处理  start -->
				<div class="ibox-title">
					<h5>
						争议处理 
					</h5>
				</div>
				<div class="ibox-content">
					<div class="form-group">
						<div class="col-sm-12">
							因履行本保险合同发生的争议，由被保险人和保险人友好协商解决，协商不成的，提交  ${vo3.arbitral_institution}  仲裁委员会仲裁；
						</div>
					</div>
				</div>
				<!-- 争议处理  end -->
				<!-- 投保人申明  start -->
				<div class="ibox-title">
					<h5> 投保人申明 </h5>
				</div>
				<div class="ibox-content">
					<div class="form-group">
						<div class="col-sm-12">
							<p class="mt30">本公司在此申明，本投保单及其附件中所提供的信息均属实无误，且构成与保险人签订的正式保单的基础。本公司承担在正式保单生效前向保险人告知任何重要信息变更的义务。</p>
							<p>本公司理解，除非之后的正式保单开始生效，否则本投保单对双方都不具约束力。以下签名为本公司授权人，代表本公司签订本投保单。</p>
						</div>
					</div>
				</div>
				<!-- 投保人申明  end -->
				<!-- 票单信息 start -->
				<div class="ibox-title">
					<h5>
						单证信息
					</h5>
				</div>
				<div class="ibox-content">

					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-7 control-label">保单信息：</label>
					</div>

					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">是否需要纸质保单：</label>
						<div class="col-sm-10">
							${vo3.mailPolicyVo.need_insur_bill eq '0' ? '否' : '是'}
						</div>
					</div>

					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">收件人：</label>
						<div class="col-sm-4">
							${ vo3.mailPolicyVo.receiver_name}
						</div>
						<label class="col-sm-2 control-label">收件人手机：</label>
						<div class="col-sm-4">
							${ vo3.mailPolicyVo.receiver_mobile}
						</div>
					</div>
					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">收件地址：</label>
						<div class="col-sm-10">
							${ vo3.mailPolicyVo.receiver_address_detail}
						</div>
					</div>

					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">是否需要纸质发票：</label>
						<div class="col-sm-4">
							${vo3.mailPolicyVo.need_receipt eq '0' ? '否' : '是'}
						</div>
						<label class="col-sm-2 control-label">发票种类：</label>
						<div class="col-sm-4">
							${vo3.mailPolicyVo.need_receipt eq '0' ? '' : vo3.mailPolicyVo.invoice_type eq '0' ? '增值税普通发票' : '增值税专用发票'}
						</div>

					</div>
					<c:if test="${vo3.mailPolicyVo.invoice_type eq '0'}">
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">收件单位：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.receipt_head}
							</div>
							<label class="col-sm-2 control-label">收件人：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.taker_name}
							</div>
						</div>
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">收件人手机：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.taker_mobile}
							</div>
							<label class="col-sm-2 control-label">收件地址：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.taker_address_detail}
							</div>

						</div>
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">纳税人识别号：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.taxpayer_number_invoice}
							</div>
							<label class="col-sm-2 control-label">&nbsp;</label>
							<div class="col-sm-4">
								&nbsp;
							</div>

						</div>
					</c:if>
					<c:if test="${vo3.mailPolicyVo.invoice_type eq '1'}">
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">纳税人识别号：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.taxpayer_number_invoice}
							</div>
							<label class="col-sm-2 control-label">注册地址：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.register_address_invoice}
							</div>

						</div>
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">开户银行：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.bank_invoice}
							</div>
							<label class="col-sm-2 control-label">电话：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.receipt_phone}
							</div>

						</div>
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">银行账号：</label>
							<div class="col-sm-4">
									${ vo3.mailPolicyVo.bank_account_invoice}
							</div>
						</div>

						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<div class="col-sm-4">
								<label class="col-sm-4 control-label">税务登记证：</label>
								<div class="col-sm-8 col-xs-8">&nbsp;
									<c:if test="${not empty vo3.mailPolicyVo.tax_cert}">
										<img alt="税务登记证" src="${ vo3.mailPolicyVo.tax_cert}" style="width: 100%;height: 100%">
										<p>
											<a target="_blank" href="${  vo3.mailPolicyVo.tax_cert}">下载</a>
										</p>
									</c:if>
								</div>
							</div>
							<div class="col-sm-4">
								<label class="col-sm-4 control-label">一般纳税人证明：</label>
								<div class="col-sm-8 col-xs-8">&nbsp;
									<c:if test="${not empty vo3.mailPolicyVo.tax_prove}">
										<img alt="一般纳税人证明" src="${ vo3.mailPolicyVo.tax_prove}" style="width: 100%;height: 100%">
										<p>
											<a target="_blank" href="${  vo3.mailPolicyVo.tax_prove}">下载</a>
										</p>
									</c:if>
								</div>
							</div>
							<div class="col-sm-4">
								<label class="col-sm-4 control-label">银行开户许可证：</label>
								<div class="col-sm-8 col-xs-8">&nbsp;
									<c:if test="${not empty vo3.mailPolicyVo.bank_licence}">
										<img alt="银行开户许可证" src="${ vo3.mailPolicyVo.bank_licence}" style="width: 100%;height: 100%">
										<p>
											<a target="_blank" href="${  vo3.mailPolicyVo.bank_licence}">下载</a>
										</p>
									</c:if>
								</div>
							</div>
							<div class="col-sm-4">
								<label class="col-sm-4 control-label">营业执照副本：</label>
								<div class="col-sm-8 col-xs-8">&nbsp;
									<c:if test="${not empty vo3.mailPolicyVo.business_license}">
										<img alt="营业执照副本" src="${ vo3.mailPolicyVo.business_license}" style="width: 100%;height: 100%">
										<p>
											<a target="_blank" href="${  vo3.mailPolicyVo.business_license}">下载</a>
										</p>
									</c:if>
								</div>
							</div>
							<div class="col-sm-4">
								<label class="col-sm-4 control-label">增票授权委托书：</label>
								<div class="col-sm-8 col-xs-8">&nbsp;
									<c:if test="${not empty vo3.mailPolicyVo.auth_cert}">
										<img alt="增票授权委托书" src="${ vo3.mailPolicyVo.auth_cert}" style="width: 100%;height: 100%">
										<p>
											<a target="_blank" href="${  vo3.mailPolicyVo.auth_cert}">下载</a>
										</p>
									</c:if>
								</div>
							</div>
						</div>
					</c:if>
				</div>
				<c:if test="${ not empty orderVo.external_reference && not empty orderVo.insure_path}">
					<div class="ibox-title">
						<h5>
							保单信息
						</h5>
					</div>
					<div class="ibox-content">
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">电子保单：</label>
							<div class="col-sm-10">
								<a target="_blank" href="${orderVo.insure_path}">查看</a>
							</div>
						</div>
					</div>
				</c:if>
				<c:if test="${ not empty orderVo.remarks}">
					<div class="ibox-title">
						<h5>
							其它
						</h5>
					</div>
					<div class="ibox-content">
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<label class="col-sm-2 control-label">备注:</label>
							<div class="col-sm-10">
									${ orderVo.remarks}
							</div>
						</div>
					</div>
				</c:if>
				<!-- 票单信息  end -->
				<!-- 操作记录  start -->
				<%--<div class="ibox-title">
					<h5>
						<c:if test="${empty dict}">操作记录 </c:if>
					</h5>
				</div>
				<div class="ibox-content">
					<table class="table table-bordered">
						<thead>
							<tr>
								<th>操作时间</th>
								<th>操作人员</th>
								<th>操作事项</th>
								<th>备注</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>1</td>
								<td>张三</td>
								<td>男</td>
								<td>23</td>
							</tr>
							<tr>
								<td>1</td>
								<td>张三</td>
								<td>男</td>
								<td>23</td>
							</tr>
						</tbody>
					</table>
				</div>--%>
				<!-- 操作记录  end -->
			</div>
		</div>
	</div>
	</div>
	<bcxinFooter>
		<!-- iCheck -->
		<script src="${ctxsta}/common/icheck/icheck.min.js"></script>
		<!-- 自定义js -->
		<script type="text/javascript">
			$(document).ready(function() {
				$('input').iCheck({
					checkboxClass : 'icheckbox_flat-green',
					radioClass : 'iradio_flat-green'
				});
			});
		</script>
	</bcxinFooter>
</body>
</html>
