<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>信息统计</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
    <style>
        .ibox-content{
            background-color: #fff !important;
        }
    </style>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>产品访问数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;">
                        <select class="form-control" onchange="p1($(this).val())">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="chartmain" style="height: 700px">
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>产品销售数量及金额统计数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;">
                        <select class="form-control" onchange="p2($(this).val())">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="amtprochart" style="height: 700px">
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
            });

        });
        function planFn(value, row, index){
            return row.plan_star_time + '~' + row.plan_end_time;
        }
        function informTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '系统升级';
            }else if('1' == value){
                it = '功能或产品推广';
            }
            return it;
        }
        function executeTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '每次';
            }else if('1' == value){
                it = '单次';
            }else if('1' == value){
                it = '暂停';
            }
            return it;
        }

        function rownumFn(value, row, index){
            var opt = $('#defaultTable').bootstrapTable('getOptions');
            if(opt.pageSize=="All") return index +1;
            return opt.pageSize * (opt.pageNumber - 1) + index + 1;
        }

        function formatOperationFn(index, row) {
            var str = "";
            //查看然后编辑按钮
            <shiro:hasPermission name="myinf:win:upd">
                var onClick = "layer_show('修改公告-"+row.city_name+"','${ctx}/myinf/win/upd?com_inform_id=${p.com_inform_id}',980,null);";
                str += '<a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="'+onClick+'" title="查看" > <i class="glyphicon glyphicon-edit"></i></a>';
            </shiro:hasPermission>
            <shiro:hasPermission name="myinf:win:del">
                var onClick2= "member_del(this,'"+row.com_inform_id+"')";
                str += '<a class="remove m-l-sm text-primary" href="javascript:void(0)" onclick="'+onClick2+'" title="删除" > <i class="glyphicon glyphicon-remove"></i></a>';
            </shiro:hasPermission>
                return str;
        }
        /*删除公告*/
        function member_del(obj, id) {
            layer.confirm('确认要删除该公告信息吗？', {  btn: ['确定', '取消'] }, function () {
                g_ajax('${ctx}/myinf/del',{com_inform_id:id}, function(json){
                    comm_back(json);
                });
            });
        }
        function comm_back(json){
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }
        function p1(y){
            g_ajax('${ctx}/mysta/req-pro',{year:y}, function(json){
                if(json.success == true){
                    prochart(json.data);
                }
            });
        }
        function p2(y){
            g_ajax('${ctx}/mysta/amt-pro',{year:y}, function(json){
                if(json.success == true){
                    amtprochart(json.data);
                }
            });
        }
        $(function(){
            var date = new Date();
            var year = date.getFullYear();
            p1(year+'');
            setTimeout(function(){p2(year+'');},300);
        });

        function amtprochart(builderJson){
            option = {
                tooltip : {
                    trigger: 'axis',
                    axisPointer : {            // 坐标轴指示器，坐标轴触发有效
                        type : 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
                    }
                },
                legend: {
                    data: ['下单数','金额数']
                },
                grid: {
                    left: '3%',
                    right: '4%',
                    bottom: '3%',
                    containLabel: true
                },
                xAxis:  {
                    type: 'value'
                },
                yAxis: {
                    type: 'category',
                    data: builderJson.pns
                },
                series: [
                    {
                        name: '下单数',
                        type: 'bar',
                        stack: '总计',
                        label: {
                            normal: {
                                show: true,
                                position: 'insideRight'
                            }
                        },
                        data: builderJson.pus
                    },
                    {
                        name: '金额数',
                        type: 'bar',
                        stack: '总计',
                        label: {
                            normal: {
                                show: true,
                                position: 'insideRight'
                            }
                        },
                        data: builderJson.pms
                    }
                ]
            };
            //初始化echarts实例
            var myChart = echarts.init(document.getElementById('amtprochart'));
            //使用制定的配置项和数据显示图表
            myChart.setOption(option);
        }

        function prochart(builderJson){
            option = {
                tooltip: {},
                title: [{
                    subtext: '总访问量 ' + builderJson.all,
                    x: '25%',
                    textAlign: 'center'
                }],
                grid: [{
                    top: 70,
                    bottom: 80,
                    left:180
                }],
                xAxis: [{
                    type: 'value',
                    max: builderJson.max,
                    splitLine: {
                        show: false
                    }
                }],
                yAxis: [{
                    type: 'category',
                    data: Object.keys(builderJson.charts),
                    axisLabel: {
                        interval: 0,
                        rotate: 30
                    },
                    splitLine: {
                        show: false
                    }
                }],
                series: [{
                    type: 'bar',
                    stack: 'chart',
                    z: 3,
                    label: {
                        normal: {
                            position: 'right',
                            show: true
                        }
                    },
                    data: Object.keys(builderJson.charts).map(function (key) {
                        return builderJson.charts[key];
                    })
                }]
            };
            //初始化echarts实例
            var myChart = echarts.init(document.getElementById('chartmain'));
            //使用制定的配置项和数据显示图表
            myChart.setOption(option);
        }

    </script>
</bcxinFooter>
</body>
</html>
