<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>公告列表</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">

                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <div id="toolbar" class="btn-group m-t-sm">
                                        <shiro:hasPermission name="mypro:rXWCK:add">
                                        <button type="button" class="btn btn-primary btn-sm" title="新增公告"
                                                onclick="layer_show('新增公告','${ctx}/myinf/win/add?com_inform_id=${p.com_inform_id}','980',null)">
                                            <i class="glyphicon glyphicon-plus"></i> 新增公告
                                        </button>
                                        </shiro:hasPermission>
                                    </div>
                                    <table id="defaultTable"
                                           data-toggle="table"
                                           data-show-refresh="true"
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="sort"
                                           data-url="${ctx}/myinf/query?com_inform_id=${p.com_inform_id}"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="asc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="false" data-field="rownum" data-formatter="rownumFn">序号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="title" >标题</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="create_time" >创建时间</th>
                                            <%--<th data-halign="center" data-align="center" data-sortable="true" data-field="create_by" >创建人</th>--%>
                                            <%--<th data-halign="center" data-align="center" data-sortable="true" data-field="update_time" >修改时间</th>--%>
                                            <%--<th data-halign="center" data-align="center" data-sortable="true" data-field="update_by" >修改人</th>--%>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="trigger_time" >触发时间</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-formatter="planFn" >计划区间</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="inform_type" data-formatter="informTypeFn">公告类型</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="execute_type" data-formatter="executeTypeFn" >提醒方式</th>
                                            <th data-halign="center" data-align="center" data-sortable="false" data-field="" data-formatter="formatOperationFn">操作 </th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
            });

        });
        function planFn(value, row, index){
            return row.plan_star_time + '~' + row.plan_end_time;
        }
        function informTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '系统升级';
            }else if('2' == value){
                it = '功能或产品推广';
            }
            return it;
        }
        function executeTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '每次';
            }else if('2' == value){
                it = '单次';
            }else if('3' == value){
                it = '暂停';
            }
            return it;
        }

        function rownumFn(value, row, index){
            var opt = $('#defaultTable').bootstrapTable('getOptions');
            if(opt.pageSize=="All") return index +1;
            return opt.pageSize * (opt.pageNumber - 1) + index + 1;
        }

        function formatOperationFn(index, row) {
            var str = "";
            //查看然后编辑按钮
            <shiro:hasPermission name="myinf:win:upd">
                var onClick = "layer_show('修改公告','${ctx}/myinf/win/upd?com_inform_id="+row.com_inform_id+"',980,null);";
                str += '<a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="'+onClick+'" title="查看" > <i class="glyphicon glyphicon-edit"></i></a>';
            </shiro:hasPermission>
            <shiro:hasPermission name="myinf:win:del">
                var onClick2= "member_del(this,'"+row.com_inform_id+"')";
                str += '<a class="remove m-l-sm text-primary" href="javascript:void(0)" onclick="'+onClick2+'" title="删除" > <i class="glyphicon glyphicon-remove"></i></a>';
            </shiro:hasPermission>
                return str;
        }
        /*删除公告*/
        function member_del(obj, id) {
            layer.confirm('确认要删除该公告信息吗？', {  btn: ['确定', '取消'] }, function () {
                g_ajax('${ctx}/myinf/del',{com_inform_id:id}, function(json){
                    comm_back(json);
                });
            });
        }
        function comm_back(json){
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
