package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.models.order.policy.dao.SpecialLitigationDao;
import com.bcxin.ins.models.order.policy.service.LnAccusedService;
import com.bcxin.ins.models.order.policy.service.SpecialLitigationService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * <b>企业短期特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class SpecialLitigationServiceImpl extends ServiceImpl<SpecialLitigationDao, SpecialLitigation> implements SpecialLitigationService {

	@Autowired
	private SpecialLitigationDao dao;
	@Autowired
	private LnAccusedService lnAccusedService;

	/**
	 * <b>诉讼特殊字段表信息 </b> TODO 联动关联表已封装，待测试
	 *
	 * @param oid InsCommonExportID
	 * @author ZXF
	 * @date 2017年1月5日 下午4:50:12
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialLitigation getSpecialLitigationBusiness(Long oid){
		SpecialLitigation specialLitigation = dao.selectById(oid);
		if(specialLitigation != null){
			setLnAccused(specialLitigation);
		}
		return specialLitigation;
	}

	/**
	 * <b>初始化诉讼特殊字段表信息 </b>
	 *
	 * @author ZXF
	 * @date 2017年1月5日 下午4:50:12
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialLitigation initSpecialLitigation(){
		SpecialLitigation specialLitigation = new SpecialLitigation();
		dao.insert(specialLitigation);
		return specialLitigation;
	}


	/**
	 * <b>被告 </b>
	 *
	 * @param specialLitigation
	 * @author ZXF
	 * @date 2017年1月5日 下午4:51:42
	 * @注意事项 </b>
	 * <b>
	 */
	private void setLnAccused(SpecialLitigation specialLitigation){
		List<LnAccused> insLnAccusedList = lnAccusedService.selectLnAccusedBySpecialLitigation(specialLitigation.getSpecial_litigation_id());
		if(insLnAccusedList.size() > ConstProp.INT_NUMBER_ZERO){
			specialLitigation.setLn_accused(insLnAccusedList);
		}
	}

	/**
	 * <b>获取SpecialLitigationVo_1根据诉讼id查询企业短期信息插入到SpecialLitigationVo_1 </b>
	 *
	 * @param vo 诉讼辅助表
	 * @param ceID 诉讼id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getSpecialLitigationVo_1BySpecial_id(SpecialLitigationVo_1 vo, Long ceID){
		SpecialLitigation specialLitigation = getSpecialLitigationBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialLitigation), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setLnAccusedVo(lnAccusedService.packagingLnAccusedVoListByLnAccusedList(specialLitigation.getLn_accused()));
	}

	/**
	 * <b>获取SpecialLitigationVo_2根据诉讼id查询企业短期信息插入到SpecialLitigationVo_2 </b>
	 *
	 * @param vo 诉讼辅助表
	 * @param ceID 诉讼id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getSpecialLitigationVo_2BySpecial_id(SpecialLitigationVo_2 vo, Long ceID){
		SpecialLitigation specialLitigation = getSpecialLitigationBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialLitigation), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b>获取specialLitigationVo_3根据诉讼id查询企业短期信息插入到specialLitigationVo_3 </b>
	 *
	 * @param vo 诉讼辅助表
	 * @param ceID 诉讼id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialLitigationVo_3BySpecial_id(SpecialLitigationVo_3 vo, Long ceID) {
		SpecialLitigation specialLitigation = getSpecialLitigationBusiness(ceID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialLitigation), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b>根据Vo及诉讼ID更新specialLitigationVo_1数据 </b>
	 *
	 * @param vo
	 * @param special_id 诉讼id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialLitigationVo_1SetUpSpecialLitigation(
			SpecialLitigationVo_1 vo, Long special_id) {
		SpecialLitigation specialLitigation = getSpecialLitigationBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), specialLitigation);
		} catch (Exception e) {
			e.printStackTrace();
		}
		/** 被告 */
		lnAccusedService.setLnAccusedByLnAccusedVo(vo.getLnAccusedVo(), specialLitigation.getSpecial_litigation_id());

		dao.updateById(specialLitigation);

	}

	/**
	 * <b>根据Vo及诉讼ID更新specialLitigationVo_2数据 </b>
	 *
	 * @param vo
	 * @param special_id 诉讼id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialLitigationVo_2SetUpSpecialLitigation(
			SpecialLitigationVo_2 vo, Long special_id) {
		SpecialLitigation specialLitigation = getSpecialLitigationBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), specialLitigation);
		} catch (Exception e) {
			e.printStackTrace();
		}

		dao.updateById(specialLitigation);

	}

	/**
	 * <b>根据Vo及诉讼ID更新specialLitigationVo_3数据 </b>
	 *
	 * @param vo
	 * @param special_id 诉讼id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheSpecialLitigationVo_3SetUpSpecialLitigation(
			SpecialLitigationVo_3 vo, Long special_id) {
		SpecialLitigation specialLitigation = getSpecialLitigationBusiness(special_id);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), specialLitigation);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(specialLitigation);

	}


}
